/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmd.midiMotion.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;
import jp.sourceforge.mmd.midiMotion.MidiResolver;

public class MidiConcat
extends JFrame {
    private MidiResolver mir;
    private File midiDir;
    private JButton buttonAdd;
    private JButton buttonDo;
    private JButton jButton1;
    private JButton jButtonDown;
    private JButton jButtonUp;
    private JScrollPane jScrollPane2;
    private JTable midiTable;

    public MidiConcat() {
        super("Midi Concatnate");
        String s = System.getProperty("midiMotion.midiDir");
        if (s != null) {
            this.midiDir = new File(s);
        }
        this.initComponents();
        this.setDropTarget(new HteDropTarget(this));
    }

    private void initComponents() {
        this.jScrollPane2 = new JScrollPane();
        this.midiTable = new JTable();
        this.buttonAdd = new JButton();
        this.buttonDo = new JButton();
        this.jButton1 = new JButton();
        this.jButtonUp = new JButton();
        this.jButtonDown = new JButton();
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.midiTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"\u30d5\u30a1\u30a4\u30eb\u540d", "\u958b\u59cb\u70b9(beat)", "\u9577\u3055(beat)"}));
        this.jScrollPane2.setViewportView(this.midiTable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.getContentPane().add((Component)this.jScrollPane2, gridBagConstraints);
        this.buttonAdd.setText("add");
        this.buttonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MidiConcat.this.buttonAddActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.getContentPane().add((Component)this.buttonAdd, gridBagConstraints);
        this.buttonDo.setText("do");
        this.buttonDo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MidiConcat.this.buttonDoActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        this.getContentPane().add((Component)this.buttonDo, gridBagConstraints);
        this.jButton1.setText("remove");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MidiConcat.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        this.getContentPane().add((Component)this.jButton1, gridBagConstraints);
        this.jButtonUp.setText("\u2191");
        this.jButtonUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MidiConcat.this.jButtonUpActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.getContentPane().add((Component)this.jButtonUp, gridBagConstraints);
        this.jButtonDown.setText("\u2193");
        this.jButtonDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MidiConcat.this.jButtonDownActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        this.getContentPane().add((Component)this.jButtonDown, gridBagConstraints);
        this.pack();
    }

    private void buttonAddActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser(this.midiDir);
        jfc.setFileFilter(new FileNameExtensionFilter("MIDI File", "mid"));
        jfc.setMultiSelectionEnabled(true);
        if (jfc.showOpenDialog(this) != 0) {
            return;
        }
        this.add(jfc.getSelectedFiles());
    }

    private void add(File[] fs) {
        DefaultTableModel m = (DefaultTableModel)this.midiTable.getModel();
        int offset = 0;
        int n = m.getRowCount();
        for (int i = 0; i < n; ++i) {
            offset += ((Integer)m.getValueAt(i, 2)).intValue();
        }
        for (File f : fs) {
            MidiResolver midiR = new MidiResolver(f);
            int l = (int)(midiR.getMidiSeq().getTickLength() / (long)midiR.getReso());
            m.addRow(new Object[]{f, offset, l});
            offset += l;
        }
    }

    private void buttonDoActionPerformed(ActionEvent evt) {
        DefaultTableModel dtm = (DefaultTableModel)this.midiTable.getModel();
        int l = dtm.getRowCount();
        MidiResolver mr = new MidiResolver((File)dtm.getValueAt(0, 0));
        for (int i = 1; i < l; ++i) {
            mr.add(new MidiResolver((File)dtm.getValueAt(i, 0)));
        }
        JFileChooser jfc = new JFileChooser(this.midiDir);
        jfc.setFileFilter(new FileNameExtensionFilter("MIDI File", "mid"));
        if (jfc.showSaveDialog(this) != 0) {
            return;
        }
        File f = jfc.getSelectedFile();
        if (!f.getName().toLowerCase().endsWith(".mid")) {
            f = new File(f.getParentFile(), f.getName() + ".mid");
        }
        try {
            FileOutputStream fos = new FileOutputStream(f);
            mr.write(fos);
            fos.close();
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "IO \u30a8\u30e9\u30fc:" + ex.getLocalizedMessage());
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        DefaultTableModel dtm = (DefaultTableModel)this.midiTable.getModel();
        int i = this.midiTable.getSelectedRow();
        if (i < 0) {
            return;
        }
        int offset = (Integer)dtm.getValueAt(i, 1);
        int n = dtm.getRowCount();
        for (int j = i + i; j < n; ++j) {
            dtm.setValueAt(offset, j, 1);
            offset += ((Integer)dtm.getValueAt(j, 2)).intValue();
        }
        dtm.removeRow(i);
    }

    private void jButtonUpActionPerformed(ActionEvent evt) {
        int i = this.midiTable.getSelectedRow();
        if (i < 1) {
            return;
        }
        DefaultTableModel dtm = (DefaultTableModel)this.midiTable.getModel();
        int n = dtm.getRowCount();
        int offset = (Integer)dtm.getValueAt(i - 1, 1);
        dtm.moveRow(i, i, i - 1);
        for (int j = i - 1; j < n; ++j) {
            dtm.setValueAt(offset, j, 1);
            offset += ((Integer)dtm.getValueAt(j, 2)).intValue();
        }
    }

    private void jButtonDownActionPerformed(ActionEvent evt) {
        int i = this.midiTable.getSelectedRow();
        if (i < 0) {
            return;
        }
        DefaultTableModel dtm = (DefaultTableModel)this.midiTable.getModel();
        int n = dtm.getRowCount();
        if (i == n - 1) {
            return;
        }
        int offset = (Integer)dtm.getValueAt(i, 1);
        dtm.moveRow(i, i, i + 1);
        for (int j = i; j < n; ++j) {
            dtm.setValueAt(offset, j, 1);
            offset += ((Integer)dtm.getValueAt(j, 2)).intValue();
        }
    }

    public static void main(String[] args) {
        MidiResolver midiR1 = null;
        if (args.length < 2) {
            String[] e = System.err;
            e.println("Usage:");
            e.println("\t$ java -jar MID2Motion.jar (Output MIDI) (MIDI file) (MIDI file) ...\n");
            e.println("catted.mid will be outputed.");
            System.exit(1);
        }
        try {
            for (String s : args) {
                FileInputStream fis = new FileInputStream(s);
                if (midiR1 == null) {
                    midiR1 = new MidiResolver(new File(s));
                    continue;
                }
                MidiResolver midiRA = new MidiResolver(new File(s));
                midiR1.add(midiRA);
            }
            midiR1.write(new FileOutputStream("catted.mid"));
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(MidiConcat.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(MidiConcat.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private class HteDropTarget
    extends DropTarget {
        private MidiConcat parent;

        HteDropTarget(MidiConcat midiC) {
            this.parent = midiC;
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            Transferable t = dtde.getTransferable();
            if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dtde.acceptDrop(0x40000000);
                try {
                    List list = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                    MidiConcat.this.add(list.toArray(new File[list.size()]));
                }
                catch (UnsupportedFlavorException e) {
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(this.parent, "IO \u30a8\u30e9\u30fc:" + ex.getLocalizedMessage());
                }
            }
        }
    }
}

