/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmd.motion;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import jp.sfjp.mikutoga.bin.parser.MmdFormatException;
import jp.sfjp.mikutoga.vmd.parser.VmdBasicHandler;
import jp.sfjp.mikutoga.vmd.parser.VmdBoolHandler;
import jp.sfjp.mikutoga.vmd.parser.VmdCameraHandler;
import jp.sfjp.mikutoga.vmd.parser.VmdLightingHandler;
import jp.sfjp.mikutoga.vmd.parser.VmdParser;
import jp.sourceforge.mmd.motion.BonePose;
import jp.sourceforge.mmd.motion.BooleanPose;
import jp.sourceforge.mmd.motion.CameraPose;
import jp.sourceforge.mmd.motion.CsvSpliter;
import jp.sourceforge.mmd.motion.LightPose;
import jp.sourceforge.mmd.motion.MorphPose;
import jp.sourceforge.mmd.motion.MoveOnBone;
import jp.sourceforge.mmd.motion.MoveOnFrame;
import jp.sourceforge.mmd.motion.Pose;
import jp.sourceforge.mmd.motion.ShadowPose;
import jp.sourceforge.mmd.motion.VMDMotionHander;

public class Motion {
    private String modelName = null;
    private int max_frame = 0;
    private TreeMap<Integer, MoveOnFrame> frame_map = new TreeMap();
    private TreeMap<String, MoveOnBone> bone_map = new TreeMap();
    private TreeMap<String, MoveOnBone> morph_map = new TreeMap();
    private ArrayList<CameraPose> cameraArray = new ArrayList();
    private ArrayList<LightPose> lightArray = new ArrayList();
    private ArrayList<ShadowPose> shadowArray = new ArrayList();
    private ArrayList<BooleanPose> booleanArray = new ArrayList();

    public Motion() {
    }

    public Motion(String model_name) {
        this();
        this.modelName = model_name;
    }

    public void put(Pose p) {
        MoveOnBone mob;
        if (p instanceof BonePose) {
            mob = this.bone_map.get(p.nameOfBone);
            if (mob == null) {
                mob = new MoveOnBone(p.nameOfBone);
                this.bone_map.put(p.nameOfBone, mob);
            }
            mob.put(p);
        } else if (p instanceof MorphPose) {
            mob = this.morph_map.get(p.nameOfBone);
            if (mob == null) {
                mob = new MoveOnBone(p.nameOfBone);
                this.morph_map.put(p.nameOfBone, mob);
            }
            mob.put(p);
        } else if (p instanceof CameraPose) {
            this.cameraArray.add((CameraPose)p);
        } else if (p instanceof LightPose) {
            this.lightArray.add((LightPose)p);
        } else if (p instanceof ShadowPose) {
            this.shadowArray.add((ShadowPose)p);
        } else if (p instanceof BooleanPose) {
            this.booleanArray.add((BooleanPose)p);
        }
        MoveOnFrame mof = this.frame_map.get(p.frame);
        if (mof == null) {
            mof = new MoveOnFrame(p.frame);
            this.frame_map.put(p.frame, mof);
            if (p.frame > this.max_frame) {
                this.max_frame = p.frame;
            }
        }
        mof.put(p);
    }

    public void putAll(Pose[] ps, int frame) {
        if (ps == null) {
            return;
        }
        for (Pose p : ps) {
            p.frame = frame;
            this.put(p);
        }
    }

    public Pose[] get(String bone) {
        if (bone == null) {
            return null;
        }
        MoveOnBone mob = this.bone_map.get(bone);
        if (mob == null && (mob = this.morph_map.get(bone)) == null) {
            return null;
        }
        return mob.toArray();
    }

    public Pose[] get(int frame) {
        MoveOnFrame mof = this.frame_map.get(frame);
        if (mof == null) {
            return null;
        }
        return mof.toArray();
    }

    public Pose[] getInterporate(int frame) {
        int i = 0;
        Pose[] ret = new Pose[this.bone_map.size()];
        for (MoveOnBone e : this.bone_map.values()) {
            ret[i] = e.getInterporate(frame);
            ++i;
        }
        return ret;
    }

    public void gc() {
        for (Map.Entry<String, MoveOnBone> mob : this.bone_map.entrySet()) {
            Integer[] list;
            for (Integer i : list = mob.getValue().gc()) {
                this.frame_map.get(i).remove(mob.getKey());
            }
        }
    }

    public void toCSV(OutputStream os) throws IOException {
        MoveOnBone mob;
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter(os, "MS932");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        osw.write("Vocaloid Motion Data 0002,0\n" + this.modelName + "\n");
        int num_bone = 0;
        StringBuilder list = new StringBuilder(4096);
        for (Map.Entry<String, MoveOnBone> entry : this.bone_map.entrySet()) {
            mob = entry.getValue();
            num_bone += mob.size();
            list.append(mob.toCSV());
        }
        osw.write(num_bone + "\n" + list);
        num_bone = 0;
        list = new StringBuilder(4096);
        for (Map.Entry<String, MoveOnBone> entry : this.morph_map.entrySet()) {
            mob = entry.getValue();
            num_bone += mob.size();
            list.append(mob.toCSV());
        }
        osw.write(num_bone + "\n" + list);
        num_bone = 0;
        list = new StringBuilder(4096);
        for (CameraPose cameraPose : this.cameraArray) {
            ++num_bone;
            list.append(cameraPose.toCSV());
        }
        osw.write(num_bone + "\n" + list);
        num_bone = 0;
        list = new StringBuilder(1024);
        for (LightPose lightPose : this.lightArray) {
            ++num_bone;
            list.append(lightPose.toCSV());
        }
        osw.write(num_bone + "\n" + list);
        num_bone = 0;
        list = new StringBuilder(1024);
        for (ShadowPose shadowPose : this.shadowArray) {
            ++num_bone;
            list.append(shadowPose.toCSV());
        }
        osw.write(num_bone + "\n" + list);
        num_bone = 0;
        list = new StringBuilder(1024);
        for (BooleanPose booleanPose : this.booleanArray) {
            ++num_bone;
            list.append(booleanPose.toCSV());
        }
        osw.write(num_bone + "\n" + list);
        osw.flush();
        os.flush();
    }

    public void toVMD(OutputStream os) throws IOException {
        MoveOnBone mob;
        ByteBuffer bbInt = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        try {
            os.write("Vocaloid Motion Data 0002".getBytes("MS932"));
        }
        catch (UnsupportedEncodingException ex) {
            System.err.println("Syntax error in toVMD in Motion class.");
            System.exit(-1);
        }
        os.write(0);
        os.write(bbInt.putInt(0).array());
        byte[] temp = this.modelName.getBytes("MS932");
        os.write(temp);
        for (int i = temp.length; i < 20; ++i) {
            os.write(0);
        }
        int number = 0;
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        for (Map.Entry<String, MoveOnBone> entry : this.bone_map.entrySet()) {
            mob = entry.getValue();
            number += mob.size();
            list.add(mob.toVMD());
        }
        os.write(bbInt.putInt(0, number).array());
        for (byte[] byArray : list) {
            os.write(byArray);
        }
        number = 0;
        list.clear();
        for (Map.Entry<String, MoveOnBone> entry : this.morph_map.entrySet()) {
            mob = entry.getValue();
            number += mob.size();
            list.add(mob.toVMD());
        }
        os.write(bbInt.putInt(0, number).array());
        for (byte[] byArray : list) {
            os.write(byArray);
        }
        number = 0;
        list.clear();
        for (CameraPose cameraPose : this.cameraArray) {
            ++number;
            list.add(cameraPose.toVMD());
        }
        os.write(bbInt.putInt(0, number).array());
        for (byte[] byArray : list) {
            os.write(byArray);
        }
        number = 0;
        list.clear();
        for (LightPose lightPose : this.lightArray) {
            ++number;
            list.add(lightPose.toVMD());
        }
        os.write(bbInt.putInt(0, number).array());
        for (byte[] byArray : list) {
            os.write(byArray);
        }
        number = 0;
        list.clear();
        for (ShadowPose shadowPose : this.shadowArray) {
            ++number;
            list.add(shadowPose.toVMD());
        }
        os.write(bbInt.putInt(0, number).array());
        for (byte[] byArray : list) {
            os.write(byArray);
        }
        number = 0;
        list.clear();
        for (BooleanPose booleanPose : this.booleanArray) {
            ++number;
            list.add(booleanPose.toVMD());
        }
        os.write(bbInt.putInt(0, number).array());
        for (byte[] byArray : list) {
            os.write(byArray);
        }
        os.flush();
    }

    public Motion fromCSV(InputStream is) throws IOException, MmdFormatException {
        return this.fromCSV(is, 0);
    }

    public Motion fromCSV(InputStream is, int offsetF) throws IOException, MmdFormatException {
        Pose p;
        int i;
        int l;
        BufferedReader br = null;
        int numOfLine = 1;
        try {
            br = new BufferedReader(new InputStreamReader(is, "MS932"));
        }
        catch (UnsupportedEncodingException ex) {
            System.err.println("Syntax err in class Motion.fromCSV.");
            System.exit(-1);
        }
        String line = br.readLine();
        if (!line.startsWith("Vocaloid Motion Data")) {
            throw new MmdFormatException("Header error at line " + numOfLine, 0L);
        }
        ++numOfLine;
        line = br.readLine();
        String[] parts = CsvSpliter.split(line);
        if (this.modelName == null) {
            this.modelName = parts[0];
        } else if (this.modelName.compareTo(parts[0]) != 0) {
            throw new MmdFormatException("Not the same model. memory:" + this.modelName + ", file:" + parts[0]);
        }
        ++numOfLine;
        line = br.readLine();
        parts = CsvSpliter.split(line);
        try {
            l = Integer.parseInt(parts[0]);
        }
        catch (NumberFormatException e) {
            throw new MmdFormatException("Illegal number for bone lines: " + e.getMessage() + " at line:" + numOfLine);
        }
        for (i = 0; i < l; ++i) {
            ++numOfLine;
            line = br.readLine();
            try {
                p = BonePose.fromCSV(line);
            }
            catch (NumberFormatException e) {
                throw new MmdFormatException("Illegal number for bone line: " + e.getMessage() + " at line:" + numOfLine);
            }
            if (p == null) continue;
            p.frame += offsetF;
            this.put(p);
        }
        ++numOfLine;
        line = br.readLine();
        if (line == null) {
            return this;
        }
        parts = CsvSpliter.split(line);
        try {
            l = Integer.parseInt(parts[0]);
        }
        catch (NumberFormatException e) {
            throw new MmdFormatException("Illegal number for morph lines: " + e.getMessage() + " at line:" + numOfLine);
        }
        for (i = 0; i < l; ++i) {
            ++numOfLine;
            line = br.readLine();
            try {
                p = MorphPose.fromCSV(line);
            }
            catch (NumberFormatException e) {
                throw new MmdFormatException("Illegal number for morph line: " + e.getMessage() + " at line:" + numOfLine);
            }
            if (p == null) continue;
            p.frame += offsetF;
            this.put(p);
        }
        ++numOfLine;
        line = br.readLine();
        if (line == null) {
            return this;
        }
        parts = CsvSpliter.split(line);
        try {
            l = Integer.parseInt(parts[0]);
        }
        catch (NumberFormatException e) {
            throw new MmdFormatException("Illegal number for camera lines: " + e.getMessage() + " at line:" + numOfLine);
        }
        for (i = 0; i < l; ++i) {
            ++numOfLine;
            line = br.readLine();
            try {
                p = CameraPose.fromCSV(line);
            }
            catch (NumberFormatException e) {
                throw new MmdFormatException("Illegal number for camera line: " + e.getMessage() + " at line:" + numOfLine);
            }
            if (p == null) continue;
            p.frame += offsetF;
            this.put(p);
        }
        ++numOfLine;
        line = br.readLine();
        if (line == null) {
            return this;
        }
        parts = CsvSpliter.split(line);
        try {
            l = Integer.parseInt(parts[0]);
        }
        catch (NumberFormatException e) {
            throw new MmdFormatException("Illegal number for light lines: " + e.getMessage() + " at line:" + numOfLine);
        }
        for (i = 0; i < l; ++i) {
            ++numOfLine;
            line = br.readLine();
            try {
                p = LightPose.fromCSV(line);
            }
            catch (NumberFormatException e) {
                throw new MmdFormatException("Illegal number for light line: " + e.getMessage() + " at line:" + numOfLine);
            }
            if (p == null) continue;
            p.frame += offsetF;
            this.put(p);
        }
        ++numOfLine;
        line = br.readLine();
        if (line == null) {
            return this;
        }
        parts = CsvSpliter.split(line);
        try {
            l = Integer.parseInt(parts[0]);
        }
        catch (NumberFormatException e) {
            throw new MmdFormatException("Illegal number for shadow lines: " + e.getMessage() + " at line:" + numOfLine);
        }
        for (i = 0; i < l; ++i) {
            ++numOfLine;
            line = br.readLine();
            try {
                p = ShadowPose.fromCSV(line);
            }
            catch (NumberFormatException e) {
                throw new MmdFormatException("Illegal number for shadow line: " + e.getMessage() + " at line:" + numOfLine);
            }
            if (p == null) continue;
            p.frame += offsetF;
            this.put(p);
        }
        ++numOfLine;
        line = br.readLine();
        if (line == null) {
            return this;
        }
        parts = CsvSpliter.split(line);
        try {
            l = Integer.parseInt(parts[0]);
        }
        catch (NumberFormatException e) {
            throw new MmdFormatException("Illegal number for boolean lines: " + e.getMessage() + " at line:" + numOfLine);
        }
        for (i = 0; i < l; ++i) {
            ++numOfLine;
            line = br.readLine();
            try {
                p = BooleanPose.fromCSV(line);
            }
            catch (NumberFormatException e) {
                throw new MmdFormatException("Illegal number for boolean line: " + e.getMessage() + " at line:" + numOfLine);
            }
            if (p == null) continue;
            p.frame += offsetF;
            this.put(p);
        }
        return this;
    }

    public Motion fromVMD(InputStream is) throws IOException, MmdFormatException {
        return this.fromVMD(is, 0);
    }

    public Motion fromVMD(InputStream is, int frame) throws IOException, MmdFormatException {
        VmdParser vmdp = new VmdParser(is);
        VMDMotionHander parser = new VMDMotionHander(this, frame);
        vmdp.setBasicHandler((VmdBasicHandler)parser);
        vmdp.setCameraHandler((VmdCameraHandler)parser);
        vmdp.setLightingHandler((VmdLightingHandler)parser);
        vmdp.setBoolHandler((VmdBoolHandler)parser);
        vmdp.parseVmd();
        return this;
    }

    public String getModelName() {
        return this.modelName;
    }

    public int getMaxFrame() {
        return this.max_frame;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public Set<String> listOfBone() {
        return this.bone_map.keySet();
    }
}

