/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.vmd.parser;

import java.io.IOException;
import jp.sfjp.mikutoga.bin.parser.BinParser;
import jp.sfjp.mikutoga.bin.parser.MmdFormatException;
import jp.sfjp.mikutoga.bin.parser.ProxyParser;
import jp.sfjp.mikutoga.bin.parser.TextDecoder;
import jp.sfjp.mikutoga.vmd.parser.VmdBasicParser;
import jp.sfjp.mikutoga.vmd.parser.VmdBoolHandler;
import jp.sfjp.mikutoga.vmd.parser.VmdUnifiedHandler;

class VmdBoolParser
extends ProxyParser {
    private final TextDecoder decoderWin31j = new TextDecoder(VmdBasicParser.CS_WIN31J);
    private VmdBoolHandler handler = VmdUnifiedHandler.EMPTY;

    VmdBoolParser(BinParser parser) {
        super(parser);
        this.decoderWin31j.setZeroChopMode(true);
    }

    void setBoolHandler(VmdBoolHandler boolHandler) {
        this.handler = boolHandler == null ? VmdUnifiedHandler.EMPTY : boolHandler;
    }

    void parse() throws IOException, MmdFormatException {
        if (!this.hasMore()) {
            return;
        }
        this.parseVmdModelSight();
    }

    private void parseVmdModelSight() throws IOException, MmdFormatException {
        int modelSightNo = this.parseLeInt();
        this.handler.loopStart(VmdBoolHandler.MODELSIGHT_LIST, modelSightNo);
        for (int ct = 0; ct < modelSightNo; ++ct) {
            int keyFrameNo = this.parseLeInt();
            boolean show = this.parseBoolean();
            this.handler.vmdModelSight(show, keyFrameNo);
            this.parseVmdIkSwitch(keyFrameNo);
            this.handler.loopNext(VmdBoolHandler.MODELSIGHT_LIST);
        }
        this.handler.loopEnd(VmdBoolHandler.MODELSIGHT_LIST);
    }

    private void parseVmdIkSwitch(int keyFrameNo) throws IOException, MmdFormatException {
        int ikSwitchNo = this.parseLeInt();
        this.handler.loopStart(VmdBoolHandler.IKSW_LIST, ikSwitchNo);
        for (int ct = 0; ct < ikSwitchNo; ++ct) {
            String boneName = this.parseString(this.decoderWin31j, 20);
            boolean valid = this.parseBoolean();
            this.handler.vmdIkSwitch(boneName, valid, keyFrameNo);
            this.handler.loopNext(VmdBoolHandler.IKSW_LIST);
        }
        this.handler.loopEnd(VmdBoolHandler.IKSW_LIST);
    }
}

