/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmd.motion;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import jp.sourceforge.mmd.motion.CsvSpliter;
import jp.sourceforge.mmd.motion.Pose;
import jp.sourceforge.mmd.motion.geo.Matrix;
import jp.sourceforge.mmd.motion.geo.Vector3D;

public class BonePose
extends Pose {
    public Vector3D v;
    public Matrix mr;
    public byte[] interpX = new byte[4];
    public byte[] interpY = new byte[4];
    public byte[] interpZ = new byte[4];
    public byte[] interpR = new byte[4];

    public BonePose() {
        this.v = new Vector3D();
        this.mr = new Matrix();
        this.interpX = new byte[]{20, 20, 107, 107};
        this.interpY = new byte[]{20, 20, 107, 107};
        this.interpZ = new byte[]{20, 20, 107, 107};
        this.interpR = new byte[]{20, 20, 107, 107};
    }

    public BonePose(BonePose other) {
        super(other);
        this.v = other.v.clone();
        this.mr = other.mr.clone();
        this.interpX = new byte[4];
        this.interpY = new byte[4];
        this.interpZ = new byte[4];
        this.interpR = new byte[4];
        for (int i = 0; i < 4; ++i) {
            this.interpX[i] = other.interpX[i];
            this.interpY[i] = other.interpY[i];
            this.interpZ[i] = other.interpZ[i];
            this.interpR[i] = other.interpR[i];
        }
    }

    public boolean equals(BonePose p) {
        return super.equals(p) && this.v.equals(p.v) && this.mr.equals(p.mr);
    }

    @Override
    public String toCSV() {
        byte[] unknown;
        StringBuilder line = new StringBuilder(512);
        line.append(this.nameOfBone).append(",").append(this.frame).append(",").append(this.v);
        double[] r = this.mr.angles();
        line.append(",").append(r[0]).append(",").append(-r[1]).append(",").append(-r[2]).append(",0x");
        for (byte b : unknown = this.unknown()) {
            line.append((b & 0xF0) == 0 ? "0" : "").append(Integer.toHexString(b).toUpperCase());
        }
        for (double d : r = this.mr.getQuotanions()) {
            line.append(",").append(d);
        }
        for (byte b : this.interpX) {
            line.append(",").append(b);
        }
        for (byte b : this.interpY) {
            line.append(",").append(b);
        }
        for (byte b : this.interpZ) {
            line.append(",").append(b);
        }
        for (byte b : this.interpR) {
            line.append(",").append(b);
        }
        return line.append("\n").toString();
    }

    public static BonePose fromCSV(String line) throws NumberFormatException {
        int i;
        String[] column = CsvSpliter.split(line);
        if (column.length < 9) {
            return null;
        }
        BonePose p = new BonePose();
        p.nameOfBone = column[0];
        p.frame = Integer.parseInt(column[1]);
        p.v = new Vector3D(Double.parseDouble(column[2]), Double.parseDouble(column[3]), Double.parseDouble(column[4]));
        double rx = Double.parseDouble(column[5]);
        double ry = -Double.parseDouble(column[6]);
        double rz = -Double.parseDouble(column[7]);
        block6: for (i = 0; i < 32; i += 2) {
            String hex = column[8].substring(i + 2, i + 4);
            byte t = Byte.parseByte(hex, 16);
            switch (i % 8) {
                case 0: {
                    p.interpX[i / 8] = t;
                    continue block6;
                }
                case 2: {
                    p.interpY[i / 8] = t;
                    continue block6;
                }
                case 4: {
                    p.interpZ[i / 8] = t;
                    continue block6;
                }
                case 6: {
                    p.interpR[i / 8] = t;
                }
            }
        }
        if (column.length > 12) {
            double[] q = new double[4];
            for (i = 0; i < 4; ++i) {
                q[i] = Double.parseDouble(column[9 + i]);
            }
            p.mr = Matrix.rotationQ(q[0], q[1], q[2], q[3]);
        } else {
            p.mr = Matrix.rotation(rx, ry, rz);
        }
        if (column.length > 16) {
            for (i = 0; i < 4; ++i) {
                p.interpX[i] = Byte.parseByte(column[13 + i]);
            }
            for (i = 0; i < 4; ++i) {
                p.interpY[i] = Byte.parseByte(column[17 + i]);
            }
            for (i = 0; i < 4; ++i) {
                p.interpZ[i] = Byte.parseByte(column[21 + i]);
            }
            for (i = 0; i < 4; ++i) {
                p.interpR[i] = Byte.parseByte(column[25 + i]);
            }
        }
        return p;
    }

    @Override
    protected byte[] toVMD() {
        ByteBuffer ret = ByteBuffer.allocate(111).order(ByteOrder.LITTLE_ENDIAN);
        try {
            byte[] a = this.nameOfBone.getBytes("MS932");
            ret.put(a);
            for (int i = a.length; i < 15; ++i) {
                ret.put((byte)0);
            }
        }
        catch (UnsupportedEncodingException ex) {
            System.err.println("Syntax error in Pose.toVMD.");
            System.exit(-1);
        }
        ret.putInt(this.frame);
        double[] rv = this.v.toDouble();
        ret.putFloat((float)rv[0]);
        ret.putFloat((float)rv[1]);
        ret.putFloat((float)rv[2]);
        double[] q = this.mr.getQuotanions();
        ret.putFloat((float)q[0]);
        ret.putFloat((float)q[1]);
        ret.putFloat((float)q[2]);
        ret.putFloat((float)q[3]);
        ret.put(this.unknown());
        return ret.array();
    }

    private byte[] unknown() {
        byte[] ret = new byte[64];
        int l = 0;
        for (int j = 0; j < 4; ++j) {
            int i;
            for (i = j; i < 16; ++i) {
                int flag = i % 4;
                ret[l] = flag == 0 ? this.interpX[i / 4] : (flag == 1 ? this.interpY[i / 4] : (flag == 2 ? this.interpZ[i / 4] : this.interpR[i / 4]));
                ++l;
            }
            for (i = 0; i < j; ++i) {
                ret[l] = 0;
                ++l;
            }
        }
        return ret;
    }

    @Override
    public BonePose clone() {
        BonePose p = new BonePose(this);
        return p;
    }
}

