/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmd.midiMotion.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import jp.sfjp.mikutoga.bin.parser.MmdFormatException;
import jp.sourceforge.mmd.midiMotion.BassMotionBuilder;
import jp.sourceforge.mmd.midiMotion.ProgressLisner;
import jp.sourceforge.mmd.midiMotion.gui.MotionPane;
import jp.sourceforge.mmd.midiMotion.midi.MidiResolver;
import jp.sourceforge.mmd.motion.Motion;
import jp.sourceforge.mmd.motion.swing.FileDropEvent;
import jp.sourceforge.mmd.motion.swing.FileDropListener;
import jp.sourceforge.mmd.motion.swing.FileDropTarget;
import jp.sourceforge.mmd.motion.swing.MmdDialog;

public class BassMotionPane
extends MotionPane
implements ProgressLisner,
FileDropListener {
    private static final String propertyHead = "midiMotion.bassMotion.";
    protected BassMotionBuilder bmb = new BassMotionBuilder();
    protected File convertTable = null;
    private Motion template;
    private JButton buttonDefine;
    private JButton buttonMotion;
    private JButton buttonProgress;
    private JProgressBar progressBar;
    private JTextField textConvert;
    private JTextField textMotion;

    public BassMotionPane() {
        super("bass");
        String s = System.getProperty("midiMotion.bassMotion.convertTable");
        if (s != null) {
            this.convertTable = new File(s);
            if (!this.convertTable.exists()) {
                this.log("\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u306a\u3044", "bass convet table\u8aad\u307f\u8fbc\u307f\u3002\nFile:" + s);
                this.convertTable = null;
            }
        }
        s = System.getProperty("midiMotion.bassMotion.template");
        this.template = null;
        if (s != null) {
            this.template = new Motion();
            try {
                FileInputStream fis = new FileInputStream(s);
                this.template.fromVMD((InputStream)fis);
                fis.close();
            }
            catch (IOException ex) {
                this.log("IO\u30a8\u30e9\u30fc", "bass\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u8aad\u307f\u8fbc\u307f\u3002\nFile:" + s + "\n" + ex);
            }
            catch (MmdFormatException ex) {
                this.log("MMD\u30e2\u30fc\u30b7\u30e7\u30f3\u3058\u3083\u3042\u308a\u307e\u305b\u3093", "bass\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u8aad\u307f\u8fbc\u307f\u3002\nFile:" + s + "\n" + (Object)((Object)ex));
            }
        }
        this.initComponents();
        this.textMotion.setDropTarget((DropTarget)new FileDropTarget((FileDropListener)this));
        this.textConvert.setDropTarget((DropTarget)new FileDropTarget((FileDropListener)this));
    }

    @Override
    public void setMidiResolver(MidiResolver midiR) {
        super.setMidiResolver(midiR);
        this.buttonProgress.setEnabled(true);
    }

    @Override
    void setFPS(float fps) {
        this.bmb.setFPS(fps);
    }

    @Override
    public void progressStart(int end) {
        this.progressBar.setEnabled(true);
        this.progressBar.setMaximum(end);
        this.progressBar.setValue(0);
    }

    @Override
    public void progressMid(int s) {
        this.progressBar.setValue(s);
        this.progressBar.setString(String.valueOf(s));
    }

    @Override
    public void progressEnd() {
        this.progressBar.setEnabled(false);
        this.progressBar.setMaximum(0);
        this.buttonProgress.setEnabled(true);
        Motion motion = this.bmb.getMotion();
        String s = System.getProperty("midiMotion.bassMotion.output");
        if (s == null) {
            s = ".";
        }
        JFileChooser jfc = new JFileChooser(s);
        jfc.setFileSelectionMode(0);
        jfc.setToolTipText("\u30d5\u30a1\u30a4\u30eb\u540d\u3092\u9078\u3076");
        jfc.setFileFilter(new FileNameExtensionFilter("MMD Motion File", "vmd", "csv"));
        if (jfc.showSaveDialog(this) != 0) {
            return;
        }
        File f = jfc.getSelectedFile();
        System.setProperty("midiMotion.bassMotion.output", f.getParent());
        try {
            if (f.getName().toLowerCase().endsWith(".vmd")) {
                FileOutputStream fos = new FileOutputStream(f);
                motion.toVMD((OutputStream)fos);
                fos.close();
            } else {
                FileOutputStream fos = new FileOutputStream(f);
                motion.toCSV((OutputStream)fos);
                fos.close();
            }
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(this, "\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\n" + ex);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "IO\u30a8\u30e9\u30fc\n" + ex);
        }
        this.bmb.resetMotion();
    }

    private void initComponents() {
        this.buttonProgress = new JButton();
        JLabel jLabel1 = new JLabel();
        this.buttonDefine = new JButton();
        this.progressBar = new JProgressBar();
        this.textConvert = new JTextField();
        JLabel jLabel2 = new JLabel();
        this.textMotion = new JTextField();
        this.buttonMotion = new JButton();
        this.setLayout(new GridBagLayout());
        this.buttonProgress.setText("do");
        this.buttonProgress.setEnabled(false);
        this.buttonProgress.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BassMotionPane.this.buttonProgressActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.add((Component)this.buttonProgress, gridBagConstraints);
        jLabel1.setText("\u63db\u7b97\u8868");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.add((Component)jLabel1, gridBagConstraints);
        this.buttonDefine.setText("open");
        this.buttonDefine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BassMotionPane.this.buttonDefineActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.buttonDefine, gridBagConstraints);
        this.progressBar.setString("0");
        this.progressBar.setStringPainted(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.2;
        this.add((Component)this.progressBar, gridBagConstraints);
        this.textConvert.setEditable(false);
        this.textConvert.setText(this.convertTable == null ? "\u307e\u3060" : this.convertTable.getName());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        this.add((Component)this.textConvert, gridBagConstraints);
        jLabel2.setText("\u30d9\u30fc\u30b7\u30b9\u30c8\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)jLabel2, gridBagConstraints);
        this.textMotion.setEditable(false);
        this.textMotion.setText(this.template == null ? "\u307e\u3060" : this.template.getModelName());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.textMotion, gridBagConstraints);
        this.buttonMotion.setText("open");
        this.buttonMotion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BassMotionPane.this.buttonMotionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.buttonMotion, gridBagConstraints);
    }

    private void buttonDefineActionPerformed(ActionEvent evt) {
        String s = System.getProperty("midiMotion.bassMotion.sampleTemplate");
        JFileChooser jfc = s == null ? new JFileChooser() : new JFileChooser(new File(s).getParentFile());
        jfc.setFileFilter(new FileNameExtensionFilter("CSV convert table", "csv"));
        if (jfc.showOpenDialog(this) != 0) {
            return;
        }
        this.openConvertTable(jfc.getSelectedFile());
    }

    private void openConvertTable(File f) {
        this.convertTable = f;
        this.textConvert.setText(this.convertTable.getName());
        System.setProperty("midiMotion.bassMotion.convertTable", this.convertTable.getAbsolutePath());
    }

    private void buttonProgressActionPerformed(ActionEvent evt) {
        try {
            FileInputStream fis = new FileInputStream(this.convertTable);
            this.bmb.loadFrameMap(fis);
            fis.close();
        }
        catch (FileNotFoundException ex) {
            this.log("\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093", "conver table:" + this.convertTable.getAbsolutePath());
            return;
        }
        catch (IOException ex) {
            this.log("IO\u30a8\u30e9\u30fc", "conver table:" + this.convertTable.getAbsolutePath() + "\n" + ex.getLocalizedMessage());
            return;
        }
        this.bmb.setTemplate(this.template);
        this.bmb.addProgressListener(this);
        this.buttonProgress.setEnabled(false);
        new Thread(new Runnable(){
            private ProgressLisner perent;

            public Runnable setP(ProgressLisner l) {
                this.perent = l;
                return this;
            }

            @Override
            public void run() {
                BassMotionPane.this.bmb.setMidiResolver(BassMotionPane.this.midiR);
                BassMotionPane.this.bmb.loadMessages();
                BassMotionPane.this.bmb.removeProgressListener(this.perent);
            }
        }.setP(this)).start();
    }

    private void buttonMotionActionPerformed(ActionEvent evt) {
        Motion m = MmdDialog.loadMotion((Component)this);
        if (m == null) {
            return;
        }
        this.openBassMotion(m);
        System.setProperty("midiMotion.bassMotion.sampleTemplate", MmdDialog.lastSelected.getAbsolutePath());
    }

    private void openBassMotion(Motion m) {
        this.template = m;
        this.textMotion.setText(m.getModelName());
    }

    public void fileDrop(FileDropEvent e) {
        Object src = e.getSource();
        File file = e.getFiles()[0];
        String name = file.getName().toLowerCase();
        if (src == this.textMotion) {
            Motion m = null;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                if (name.endsWith(".vmd")) {
                    m = new Motion().fromVMD((InputStream)fis);
                } else if (name.endsWith(".csv")) {
                    m = new Motion().fromVMD((InputStream)fis);
                }
                fis.close();
            }
            catch (FileNotFoundException ex) {
                JOptionPane.showMessageDialog(this, "\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093: " + ex.getLocalizedMessage());
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "\u30d5\u30a1\u30a4\u30eb\u304c\u8aad\u307f\u53d6\u308c\u307e\u305b\u3093: " + ex.getLocalizedMessage());
            }
            catch (MmdFormatException ex) {
                JOptionPane.showMessageDialog(this, "MMD\u306e\u30e2\u30fc\u30b7\u30e7\u30f3\u30d5\u30a1\u30a4\u30eb\u3067\u306f\u3042\u308a\u307e\u305b\u3093: " + ex.getLocalizedMessage());
                try {
                    fis.close();
                }
                catch (IOException ex2) {
                    JOptionPane.showMessageDialog(this, "\u30d5\u30a1\u30a4\u30eb\u304c\u8aad\u307f\u53d6\u308c\u307e\u305b\u3093: " + ex2.getLocalizedMessage());
                }
            }
            if (m == null) {
                return;
            }
            this.openBassMotion(m);
            System.setProperty("midiMotion.bassMotion.sampleTemplate", file.getPath());
        } else {
            if (!name.endsWith(".csv")) {
                return;
            }
            this.openConvertTable(file);
        }
    }
}

