/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmd.midiMotion.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import jp.sfjp.mikutoga.bin.parser.MmdFormatException;
import jp.sourceforge.mmd.midiMotion.KeyBoardMotionBuilder;
import jp.sourceforge.mmd.midiMotion.ProgressLisner;
import jp.sourceforge.mmd.midiMotion.gui.MotionPane;
import jp.sourceforge.mmd.midiMotion.midi.MidiResolver;
import jp.sourceforge.mmd.motion.Motion;
import jp.sourceforge.mmd.motion.geo.Vector3D;
import jp.sourceforge.mmd.motion.model.Model;
import jp.sourceforge.mmd.motion.swing.BoneComboBox;
import jp.sourceforge.mmd.motion.swing.FileDropEvent;
import jp.sourceforge.mmd.motion.swing.FileDropListener;
import jp.sourceforge.mmd.motion.swing.FileDropTarget;
import jp.sourceforge.mmd.motion.swing.MmdDialog;

public class KeyboardMotionPane
extends MotionPane
implements ProgressLisner,
FileDropListener {
    private static final String propertyHead = "midiMotion.keyboard.";
    protected Model keyModel;
    protected Motion keyMotion;
    protected Model playerModel;
    protected Motion playerMotion;
    protected KeyBoardMotionBuilder kbmb = new KeyBoardMotionBuilder();
    protected Vector3D offset = this.kbmb.getOffset();
    private JButton buttonProgress;
    private BoneComboBox comboDamper;
    private BoneComboBox comboProgram;
    private BoneComboBox comboWheel;
    private JButton keyModelOpenButton;
    private JButton keyMotionOpenButton;
    private JTextField keysModelText;
    private JTextField keysMotionText;
    private JButton playerModelOpenButton;
    private JTextField playerModelText;
    private JButton playerMotionOpenButton;
    private JTextField playerMotionText;
    private JProgressBar progressBar;
    private ButtonGroup radioGroupProto;
    private JRadioButton radioMidi2Vmd;
    private JRadioButton radioVornoi;
    private JTextField textAngle;
    private JTextField textCenter;
    private JTextField textOffsetX;
    private JTextField textOffsetY;
    private JTextField textOffsetZ;

    public KeyboardMotionPane() {
        super("keyboard");
        this.initComponents();
        this.keysModelText.setDropTarget((DropTarget)new FileDropTarget((FileDropListener)this));
        this.keysMotionText.setDropTarget((DropTarget)new FileDropTarget((FileDropListener)this));
        this.playerModelText.setDropTarget((DropTarget)new FileDropTarget((FileDropListener)this));
        this.playerMotionText.setDropTarget((DropTarget)new FileDropTarget((FileDropListener)this));
    }

    @Override
    public void setMidiResolver(MidiResolver midiR) {
        super.setMidiResolver(midiR);
        this.buttonProgress.setEnabled(true);
    }

    private void initComponents() {
        this.radioGroupProto = new ButtonGroup();
        this.buttonProgress = new JButton();
        this.progressBar = new JProgressBar();
        this.keysModelText = new JTextField();
        this.keyModelOpenButton = new JButton();
        this.playerModelText = new JTextField();
        this.playerModelOpenButton = new JButton();
        this.keysMotionText = new JTextField();
        this.keyMotionOpenButton = new JButton();
        this.playerMotionText = new JTextField();
        this.playerMotionOpenButton = new JButton();
        this.textOffsetX = new JTextField();
        this.textOffsetY = new JTextField();
        this.textOffsetZ = new JTextField();
        this.textAngle = new JTextField();
        this.textCenter = new JTextField();
        this.radioMidi2Vmd = new JRadioButton();
        this.radioVornoi = new JRadioButton();
        this.comboWheel = new BoneComboBox();
        this.comboProgram = new BoneComboBox();
        this.comboDamper = new BoneComboBox();
        JLabel jLabel1 = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        JLabel jLabel5 = new JLabel();
        JLabel jLabel6 = new JLabel();
        JLabel jLabel7 = new JLabel();
        JLabel jLabel8 = new JLabel();
        JLabel jLabel9 = new JLabel();
        JLabel jLabel10 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.buttonProgress.setText("do");
        this.buttonProgress.setEnabled(false);
        this.buttonProgress.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyboardMotionPane.this.buttonProgressActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        this.add((Component)this.buttonProgress, gridBagConstraints);
        this.progressBar.setEnabled(false);
        this.progressBar.setString("0");
        this.progressBar.setStringPainted(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        this.add((Component)this.progressBar, gridBagConstraints);
        this.keysModelText.setEditable(false);
        this.keysModelText.setText("\u307e\u3060");
        this.keysModelText.setToolTipText("\u30ad\u30fc\u30dc\u30fc\u30c9\u306e\u30e2\u30c7\u30eb.PMD,PMX\u3092\u30c9\u30ed\u30c3\u30d7\u53ef\u80fd.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        this.add((Component)this.keysModelText, gridBagConstraints);
        this.keyModelOpenButton.setText("open");
        this.keyModelOpenButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyboardMotionPane.this.keyModelOpenButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        this.add((Component)this.keyModelOpenButton, gridBagConstraints);
        this.playerModelText.setEditable(false);
        this.playerModelText.setText("\u307e\u3060");
        this.playerModelText.setToolTipText("\u30d7\u30ec\u30a4\u30e4\u30fc\u306e\u30e2\u30c7\u30eb.PMD,PMX\u3092\u30c9\u30ed\u30c3\u30d7\u53ef\u80fd.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        this.add((Component)this.playerModelText, gridBagConstraints);
        this.playerModelOpenButton.setText("open");
        this.playerModelOpenButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyboardMotionPane.this.playerModelOpenButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        this.add((Component)this.playerModelOpenButton, gridBagConstraints);
        this.keysMotionText.setEditable(false);
        this.keysMotionText.setText("\u307e\u3060");
        this.keysMotionText.setToolTipText("\u30ad\u30fc\u30dc\u30fc\u30c9\u306e\u30e2\u30fc\u30b7\u30e7\u30f3.VMD,CSV\u3092\u30c9\u30ed\u30c3\u30d7\u53ef\u80fd.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        this.add((Component)this.keysMotionText, gridBagConstraints);
        this.keyMotionOpenButton.setText("open");
        this.keyMotionOpenButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyboardMotionPane.this.keyMotionOpenButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        this.add((Component)this.keyMotionOpenButton, gridBagConstraints);
        this.playerMotionText.setEditable(false);
        this.playerMotionText.setText("\u307e\u3060");
        this.playerMotionText.setToolTipText("\u30d7\u30ec\u30a4\u30e4\u30fc\u306e\u30e2\u30fc\u30b7\u30e7\u30f3.VMD,CSV\u3092\u30c9\u30ed\u30c3\u30d7\u53ef\u80fd.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        this.add((Component)this.playerMotionText, gridBagConstraints);
        this.playerMotionOpenButton.setText("open");
        this.playerMotionOpenButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KeyboardMotionPane.this.playerMotionOpenButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        this.add((Component)this.playerMotionOpenButton, gridBagConstraints);
        this.textOffsetX.setText(String.valueOf(this.offset.toDouble()[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        this.add((Component)this.textOffsetX, gridBagConstraints);
        this.textOffsetY.setText(String.valueOf(this.offset.toDouble()[1]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.textOffsetY, gridBagConstraints);
        this.textOffsetZ.setText(String.valueOf(this.offset.toDouble()[2]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.textOffsetZ, gridBagConstraints);
        this.textAngle.setText("-4.0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.textAngle, gridBagConstraints);
        this.textCenter.setText("60");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        this.add((Component)this.textCenter, gridBagConstraints);
        this.radioGroupProto.add(this.radioMidi2Vmd);
        this.radioMidi2Vmd.setSelected(true);
        this.radioMidi2Vmd.setText("Midi2Vmd");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 21;
        this.add((Component)this.radioMidi2Vmd, gridBagConstraints);
        this.radioGroupProto.add(this.radioVornoi);
        this.radioVornoi.setText("voronoi\u5f0f");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 21;
        this.add((Component)this.radioVornoi, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        this.add((Component)this.comboWheel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        this.add((Component)this.comboProgram, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        this.add((Component)this.comboDamper, gridBagConstraints);
        jLabel1.setText("keys \u30e2\u30c7\u30eb");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 22;
        this.add((Component)jLabel1, gridBagConstraints);
        jLabel2.setText("keys \u30e2\u30fc\u30b7\u30e7\u30f3");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 22;
        this.add((Component)jLabel2, gridBagConstraints);
        jLabel3.setText("player \u30e2\u30c7\u30eb");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 22;
        this.add((Component)jLabel3, gridBagConstraints);
        jLabel4.setText("player \u30e2\u30fc\u30b7\u30e7\u30f3");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 22;
        this.add((Component)jLabel4, gridBagConstraints);
        jLabel5.setText("\u30bb\u30f3\u30bf\u30fc");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 22;
        this.add((Component)jLabel5, gridBagConstraints);
        jLabel6.setText("\u30db\u30a4\u30fc\u30eb");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 22;
        this.add((Component)jLabel6, gridBagConstraints);
        jLabel7.setText("Program Change");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 22;
        this.add((Component)jLabel7, gridBagConstraints);
        jLabel8.setText("\u30aa\u30d5\u30bb\u30c3\u30c8");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 22;
        this.add((Component)jLabel8, gridBagConstraints);
        jLabel9.setText("x \u89d2\u5ea6");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 22;
        this.add((Component)jLabel9, gridBagConstraints);
        jLabel10.setText("\u30c0\u30f3\u30d1\u30fc\u30da\u30c0\u30eb");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 22;
        this.add((Component)jLabel10, gridBagConstraints);
    }

    private void keyModelOpenButtonActionPerformed(ActionEvent evt) {
        Model m = MmdDialog.loadModel((Component)this);
        if (m == null) {
            return;
        }
        this.openKeysModel(m);
    }

    private void openKeysModel(Model m) {
        this.keyModel = m;
        this.keysModelText.setText(this.keyModel.getName());
        this.comboWheel.setMMDModel(m);
        this.comboProgram.setMMDModel(m);
        this.comboDamper.setMMDModel(m);
        String proper = System.getProperty(propertyHead + this.keyModel.getName() + ".wheel");
        if (proper != null) {
            this.comboWheel.setSelect(proper);
        }
        if ((proper = System.getProperty(propertyHead + this.keyModel.getName() + ".programChange")) != null) {
            this.comboProgram.setSelect(proper);
        }
        if ((proper = System.getProperty(propertyHead + this.keyModel.getName() + ".damper")) != null) {
            this.comboDamper.setSelect(proper);
        }
        if ((proper = System.getProperty(propertyHead + this.keyModel.getName() + ".center")) != null) {
            this.textCenter.setText(proper);
        }
        if ((proper = System.getProperty(propertyHead + this.keyModel.getName() + ".angle")) != null) {
            this.textAngle.setText(proper);
        }
        if ((proper = System.getProperty(propertyHead + this.keyModel.getName() + ".offset")) != null) {
            String[] sp = proper.split(",");
            this.textOffsetX.setText(sp[0]);
            this.textOffsetY.setText(sp[1]);
            this.textOffsetZ.setText(sp[2]);
        }
        if ((proper = System.getProperty(propertyHead + this.keyModel.getName() + ".protocol")) != null) {
            if ("vornoi".equalsIgnoreCase(proper)) {
                this.radioVornoi.setSelected(true);
            } else {
                this.radioMidi2Vmd.setSelected(true);
            }
        }
    }

    private void playerModelOpenButtonActionPerformed(ActionEvent evt) {
        Model m = MmdDialog.loadModel((Component)this);
        if (m == null) {
            return;
        }
        this.openPlayerModel(m);
    }

    private void openPlayerModel(Model m) {
        this.playerModel = m;
        this.playerModelText.setText(this.playerModel.getName());
    }

    private void keyMotionOpenButtonActionPerformed(ActionEvent evt) {
        Motion m = MmdDialog.loadMotion((Component)this);
        if (m == null) {
            return;
        }
        this.openKeysMotion(m);
    }

    private void openKeysMotion(Motion m) {
        this.keyMotion = m;
        this.keysMotionText.setText(this.keyMotion.getModelName());
    }

    private void playerMotionOpenButtonActionPerformed(ActionEvent evt) {
        Motion m = MmdDialog.loadMotion((Component)this);
        if (m == null) {
            return;
        }
        this.openPlayerMotion(m);
    }

    private void openPlayerMotion(Motion m) {
        this.playerMotion = m;
        this.playerMotionText.setText(this.playerMotion.getModelName());
    }

    private void buttonProgressActionPerformed(ActionEvent evt) {
        if (this.playerMotion != null && this.playerModel != null) {
            try {
                this.kbmb.setPlayer(this.playerMotion, this.playerModel);
            }
            catch (MmdFormatException ex) {
                this.log("\u30d7\u30ec\u30a4\u30e4\u30fc\u30e2\u30c7\u30eb\u3068\u3057\u3066\u4f7f\u3048\u307e\u305b\u3093", "\u30d7\u30ec\u30a4\u30e4\u30fc\u30e2\u30c7\u30eb\u3068\u3057\u3066\u30dc\u30fc\u30f3\u304c\u4e0d\u8db3\u3057\u3066\u3044\u307e\u3059\u3002" + (Object)((Object)ex));
                return;
            }
        }
        if (this.keyModel != null) {
            this.kbmb.setKeyboard(this.keyMotion, this.keyModel);
            try {
                this.kbmb.setCenter(Integer.parseInt(this.textCenter.getText()));
            }
            catch (NumberFormatException e) {
                this.log("\u6570\u5b57\u3058\u3083\u3042\u308a\u307e\u305b\u3093", "center\u304c\u6570\u5b57\u3058\u3083\u3042\u308a\u307e\u305b\u3093\u3002");
                return;
            }
            System.setProperty(propertyHead + this.keyModel.getName() + ".center", this.textCenter.getText());
            try {
                this.offset = new Vector3D(Double.parseDouble(this.textOffsetX.getText()), Double.parseDouble(this.textOffsetY.getText()), Double.parseDouble(this.textOffsetZ.getText()));
                this.kbmb.setOffset(this.offset);
            }
            catch (NumberFormatException e) {
                this.log("\u6570\u5b57\u3058\u3083\u3042\u308a\u307e\u305b\u3093", "offset \u304c\u6570\u5b57\u3058\u3083\u3042\u308a\u307e\u305b\u3093\u3002");
                return;
            }
            System.setProperty(propertyHead + this.keyModel.getName() + ".offset", this.offset.toString());
            try {
                this.kbmb.setAngle(Double.parseDouble(this.textAngle.getText()));
            }
            catch (NumberFormatException e) {
                this.log("\u6570\u5b57\u3058\u3083\u3042\u308a\u307e\u305b\u3093", "offset \u304c\u6570\u5b57\u3058\u3083\u3042\u308a\u307e\u305b\u3093\u3002");
                return;
            }
            System.setProperty(propertyHead + this.keyModel.getName() + ".angle", this.textAngle.getText());
            this.kbmb.setProtocol(this.radioMidi2Vmd.isSelected() ? 0 : 1);
            System.setProperty(propertyHead + this.keyModel.getName() + ".protocol", this.radioMidi2Vmd.isSelected() ? "Midi2Vmd" : "vornoi");
            String s = (String)this.comboWheel.getSelectedItem();
            if ("(\u306a\u3057)".equalsIgnoreCase(s)) {
                this.kbmb.setBendW(null);
                System.setProperty(propertyHead + this.keyModel.getName() + ".wheel", "(\u306a\u3057)");
            } else {
                this.kbmb.setBendW(s);
                System.setProperty(propertyHead + this.keyModel.getName() + ".wheel", s);
            }
            s = (String)this.comboProgram.getSelectedItem();
            if ("(\u306a\u3057)".equalsIgnoreCase(s)) {
                this.kbmb.setProgramChange(null);
                System.setProperty(propertyHead + this.keyModel.getName() + ".programChange", "(\u306a\u3057)");
            } else {
                this.kbmb.setProgramChange(s);
                System.setProperty(propertyHead + this.keyModel.getName() + ".programChange", s);
            }
            s = (String)this.comboDamper.getSelectedItem();
            if ("(\u306a\u3057)".equalsIgnoreCase(s)) {
                this.kbmb.setDamper(null);
                System.setProperty(propertyHead + this.keyModel.getName() + ".damper", "(\u306a\u3057)");
            } else {
                this.kbmb.setDamper(s);
                System.setProperty(propertyHead + this.keyModel.getName() + ".damper", s);
            }
        }
        this.kbmb.addProgressListener(this);
        this.buttonProgress.setEnabled(false);
        this.kbmb.setMidiResolver(this.midiR);
        new Thread(new Runnable(){
            private ProgressLisner perent;

            public Runnable setP(ProgressLisner l) {
                this.perent = l;
                return this;
            }

            @Override
            public void run() {
                KeyboardMotionPane.this.kbmb.loadMessages();
                KeyboardMotionPane.this.kbmb.removeProgressListener(this.perent);
            }
        }.setP(this)).start();
    }

    @Override
    public void progressStart(int end) {
        this.progressBar.setEnabled(true);
        this.progressBar.setMaximum(end);
        this.progressBar.setValue(0);
    }

    @Override
    public void progressMid(int s) {
        this.progressBar.setValue(s);
        this.progressBar.setString(String.valueOf(s));
    }

    @Override
    public void progressEnd() {
        this.progressBar.setEnabled(false);
        this.progressBar.setMaximum(0);
        this.buttonProgress.setEnabled(true);
        Motion keyboardOutputMotion = this.kbmb.getMotion();
        Motion playerOutputMotion = this.kbmb.getMotionPlayer();
        String s = System.getProperty("midiMotion.outputDir");
        if (s == null) {
            s = ".";
        }
        JFileChooser jfc = new JFileChooser(s);
        jfc.setFileSelectionMode(1);
        jfc.setToolTipText("\u30d5\u30a9\u30eb\u30c0\u30fc\u3092\u9078\u3076");
        if (jfc.showSaveDialog(this) != 0) {
            return;
        }
        File dir = jfc.getSelectedFile();
        try {
            FileOutputStream fos = new FileOutputStream(new File(dir, "keyboard.vmd"));
            keyboardOutputMotion.toVMD((OutputStream)fos);
            fos.close();
            if (playerOutputMotion != null) {
                fos = new FileOutputStream(new File(dir, "keysPlayer.vmd"));
                playerOutputMotion.toVMD((OutputStream)fos);
                fos.close();
            }
            System.setProperty("midiMotion.outputDir", dir.getParent());
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(this, "\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\n" + ex);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "IO\u30a8\u30e9\u30fc\n" + ex);
        }
        this.kbmb.resetMotion();
    }

    @Override
    void setFPS(float fps) {
        this.kbmb.setFPS(fps);
    }

    public void fileDrop(FileDropEvent e) {
        Object src = e.getSource();
        File file = e.getFiles()[0];
        String name = file.getName().toLowerCase();
        if (src == this.keysModelText || src == this.playerModelText) {
            Model m = null;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                if (name.endsWith(".pmx")) {
                    m = Model.fromPMX((InputStream)fis);
                } else if (name.endsWith(".pmd")) {
                    m = Model.fromPMD((InputStream)fis);
                } else if (name.endsWith(".csv")) {
                    m = Model.fromCSV((InputStream)fis);
                }
                fis.close();
            }
            catch (FileNotFoundException ex) {
                JOptionPane.showMessageDialog(this, "\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093: " + ex.getLocalizedMessage());
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "\u30d5\u30a1\u30a4\u30eb\u304c\u8aad\u307f\u53d6\u308c\u307e\u305b\u3093: " + ex.getLocalizedMessage());
            }
            catch (MmdFormatException ex) {
                JOptionPane.showMessageDialog(this, "MMD\u306e\u30e2\u30c7\u30eb\u30d5\u30a1\u30a4\u30eb\u3067\u306f\u3042\u308a\u307e\u305b\u3093: " + ex.getLocalizedMessage());
                try {
                    fis.close();
                }
                catch (IOException ex2) {
                    JOptionPane.showMessageDialog(this, "\u30d5\u30a1\u30a4\u30eb\u304c\u8aad\u307f\u53d6\u308c\u307e\u305b\u3093: " + ex2.getLocalizedMessage());
                }
            }
            if (m == null) {
                return;
            }
            if (src == this.keysModelText) {
                this.openKeysModel(m);
            } else {
                this.openPlayerModel(m);
            }
        } else if (src == this.keysMotionText || src == this.playerMotionText) {
            Motion m = null;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                if (name.endsWith(".vmd")) {
                    m = new Motion().fromVMD((InputStream)fis);
                } else if (name.endsWith(".csv")) {
                    m = new Motion().fromVMD((InputStream)fis);
                }
                fis.close();
            }
            catch (FileNotFoundException ex) {
                JOptionPane.showMessageDialog(this, "\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093: " + ex.getLocalizedMessage());
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "\u30d5\u30a1\u30a4\u30eb\u304c\u8aad\u307f\u53d6\u308c\u307e\u305b\u3093: " + ex.getLocalizedMessage());
            }
            catch (MmdFormatException ex) {
                JOptionPane.showMessageDialog(this, "MMD\u306e\u30e2\u30fc\u30b7\u30e7\u30f3\u30d5\u30a1\u30a4\u30eb\u3067\u306f\u3042\u308a\u307e\u305b\u3093: " + ex.getLocalizedMessage());
                try {
                    fis.close();
                }
                catch (IOException ex2) {
                    JOptionPane.showMessageDialog(this, "\u30d5\u30a1\u30a4\u30eb\u304c\u8aad\u307f\u53d6\u308c\u307e\u305b\u3093: " + ex2.getLocalizedMessage());
                }
            }
            if (m == null) {
                return;
            }
            if (src == this.keysMotionText) {
                this.openKeysMotion(m);
            } else {
                this.openPlayerMotion(m);
            }
        }
    }
}

