/*
 * The MIT License
 *
 * Copyright 2015 nazo.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package jp.sourceforge.mmd.midiMotion;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.TreeMap;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.ShortMessage;
import jp.sourceforge.mmd.motion.CsvSpliter;
import jp.sourceforge.mmd.motion.Motion;
import jp.sourceforge.mmd.motion.Pose;

/**
 * サンプルモーションをMIDIに合わせて出力するモーションビルダー.
 * 
 * @author nazo
 */
public class SampleMotionBuilder extends MotionBuilder{
    protected Motion template=null;
    protected Map<Integer,int[]> note2frames;

    public SampleMotionBuilder() {
        super();
        note2frames=new TreeMap<Integer, int[]>();
    }

    public void setTemplate(Motion player){
        template=player;
        motion.setModelName(player.getModelName());
    }

    public void loadFrameMap(InputStream is) throws IOException{
        BufferedReader br=new BufferedReader(new InputStreamReader(is,"MS932"));
        String line;
        String []p;
        while(br.ready()){
            line=br.readLine();
            if(line.charAt(0)==';')continue;
            p=CsvSpliter.split(line);
            note2frames.put(new Integer(p[1]),
                    new int []{
                        Integer.parseInt(p[2]), //from
                        Integer.parseInt(p[3]), //hit
                        Integer.parseInt(p[4]), //length
                        Integer.parseInt(p[5]), //extend?
                        Integer.parseInt(p[6]), //note off release
                        Integer.parseInt(p[7])  //note off off
                    });
        }
    }

    /**
     *
     */
    @Override
    public void loadMessages() {
        if(template==null||note2frames.isEmpty()){
            return;
        }

        ShortMessage sm;
        TreeMap<Integer,int []> extend= new TreeMap<Integer, int[]>();

        int i,j;
        int frame;
        int com,note,vel;
        double n=0;
        int [] list;

        Pose [] ps;
        MidiEvent [] mes=mm.getChannelMessage(0);

        for(i=0;i<9;i++){
            if(mes==null){
                mes=mm.getChannelMessage(i);
            }
        }

        reportProgressStart();
        for(MidiEvent me:mes){
            sm=(ShortMessage)me.getMessage();
            frame=ticsToframe(me.getTick());
            reportProgress(frame);
            if((com=sm.getCommand())==ShortMessage.NOTE_ON){
                note=sm.getData1();
                vel=sm.getData2();
                list=note2frames.get(note);
                if(list==null)continue;
                if(list[3]>0){ //extends
                    extend.put(note,new int[] {frame});
                } else {
                    j=list[0];
                    for(i=frame+list[0]-list[1];i<frame+list[0]-list[1]+list[2];i++){
                        ps = template.get(j);
                        motion.putAll(ps, ((i<0)?0:i));
                        j++;
                    }
                }
            } else if(com==ShortMessage.NOTE_OFF){
                note=sm.getData1();
                list=note2frames.get(note);
                if(list==null)continue;
                if(list[3]>0){ // note that list[2]==1 will cause a problem.
                    int [] aset=extend.get(note);
                    if(aset==null)continue;
                    double d=(double)(frame-aset[0])/(list[2]-1+list[0]-list[1]);// d tic=1 f
                    for(j=list[0];j<list[0]+list[2];j++){
                        ps = template.get(j);
                        i=aset[0]+(int)(d*(j-list[1]));
                        motion.putAll(ps, ((i<0)?0:i));
                    }
                } else if(list[4]>0){
                    j=list[4];
                    for(i=frame;i<=frame+list[5]-list[4];i++){
                        ps = template.get(j);
                        motion.putAll(ps, i);
                        j++;
                    }
                }
            }
        }
        reportProgressEnd();
    }
}
