/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmd.motion;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import jp.sourceforge.mmd.motion.BonePose;
import jp.sourceforge.mmd.motion.MorphPose;
import jp.sourceforge.mmd.motion.Pose;

class MoveOnFrame
implements Comparable {
    private int frame;
    protected TreeMap<String, BonePose> bonePoses;
    protected TreeMap<String, MorphPose> morphPoses;
    protected List<Pose> otherPoses;

    public MoveOnFrame(int frame) {
        this.frame = frame;
        this.bonePoses = new TreeMap();
        this.morphPoses = new TreeMap();
        this.otherPoses = new ArrayList<Pose>();
    }

    public int hashCode() {
        return this.frame;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MoveOnFrame other = (MoveOnFrame)obj;
        return this.frame == other.frame;
    }

    public void put(Pose p) {
        if (p instanceof BonePose) {
            this.bonePoses.put(p.nameOfBone, (BonePose)p);
        } else if (p instanceof MorphPose) {
            this.morphPoses.put(p.nameOfBone, (MorphPose)p);
        } else {
            this.otherPoses.add(p);
        }
    }

    public Pose get(String s) {
        Pose p = this.bonePoses.get(s);
        if (p == null) {
            p = this.morphPoses.get(s);
        }
        return p;
    }

    public void remove(String s) {
        this.bonePoses.remove(s);
    }

    public int size() {
        return this.bonePoses.size() + this.morphPoses.size() + this.otherPoses.size();
    }

    public Pose[] toArray() {
        Pose[] ps = new Pose[this.size()];
        Iterator<Pose> ip = this.bonePoses.values().iterator();
        int i = 0;
        while (ip.hasNext()) {
            Pose pose = ip.next();
            ps[i] = pose.clone();
            ++i;
        }
        for (Pose pose : this.morphPoses.values()) {
            ps[i] = pose.clone();
            ++i;
        }
        for (Pose pose : this.otherPoses) {
            ps[i] = pose.clone();
            ++i;
        }
        return ps;
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        if (o.getClass() != this.getClass()) {
            return 1;
        }
        MoveOnFrame other = (MoveOnFrame)o;
        return this.frame - other.frame;
    }
}

