/*
 * The MIT License
 *
 * Copyright 2015 nazo.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package jp.sourceforge.mmd.ik_solver;

/**
 * IKなどに頻繁に使われる手足のパーツ名.
 * @author nazo
 * @since 1.5
 */
public class PartName {
    /** {左, 右, 上, 下} */
    static public String[] LR = new String[]{"左","右","上","下"};
    /** {つま先, 足首, ひざ, 足} */
    static public String[] legs = new String[]{"つま先","足首","ひざ","足"};
    /** {手首, ひじ, 腕, 肩} */
    static public String[] arms = new String[]{"手首","ひじ","腕","肩"};
    /** {親指, 人指, 中指, 薬指, 小指, 人差指} */
    static public String[] fingers = new String[]{"親指","人指","中指","薬指","小指","人差指"};
    /** {先,１, ２, ３, ３先} */
    static public String[] suffix = new String[]{"先","１","２","３","３先"};
    /** {０, ＩＫ, 捩, 半身} */
    static public String[] special = new String[]{"０","ＩＫ","捩","半身"};

    /**
     * 指のボーン名を作る.
     * @param lr 0:左, 1:右
     * @param finger 0:親, 4:小
     * @param index 0:"先", 1:"１", 4:"３先"
     * @return ボーン名
     * @since 1.5
     */
    static public String makeFinger(int lr,int finger,int index){
        return LR[lr]+fingers[finger]+suffix[index];
    }

    /**
     * 腕のボーン名を作る.
     * @param lr 0:左, 1:右
     * @param arm "手首","ひじ","腕","肩"
     * @return ボーン名
     * @since 1.5
     */
    static public String makeArm(int lr,int arm){
        return LR[lr]+arms[arm];
    }
}
