/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmd.motion;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import jp.sourceforge.mmd.motion.CsvSpliter;
import jp.sourceforge.mmd.motion.Pose;
import jp.sourceforge.mmd.motion.geo.Vector3D;

public class LightPose
extends Pose<LightPose> {
    public float[] rgb;
    public Vector3D v;

    public LightPose() {
        this.nameOfBone = "\u7167\u660e";
        this.rgb = new float[]{0.5f, 0.5f, 0.5f};
        this.v = new Vector3D(-0.5, -1.0, 0.5);
    }

    public LightPose(LightPose p) {
        super(p);
        this.rgb = new float[3];
        this.rgb[0] = p.rgb[0];
        this.rgb[1] = p.rgb[1];
        this.rgb[2] = p.rgb[2];
        this.v = p.v.clone();
    }

    @Override
    public boolean equals(LightPose p) {
        return super.equals2(p) && this.v.equals(p.v) && this.rgb[0] == p.rgb[0] && this.rgb[1] == p.rgb[1] && this.rgb[2] == p.rgb[2];
    }

    public static LightPose fromCSV(String line) throws NumberFormatException {
        String[] column = CsvSpliter.split(line);
        if (column.length < 7) {
            return null;
        }
        LightPose p = new LightPose();
        p.frame = Integer.parseInt(column[0]);
        p.rgb = new float[]{Float.parseFloat(column[1]), Float.parseFloat(column[2]), Float.parseFloat(column[3])};
        p.v = new Vector3D(Double.parseDouble(column[4]), Double.parseDouble(column[5]), Double.parseDouble(column[6]));
        return p;
    }

    @Override
    public String toCSV() {
        return this.frame + "," + this.rgb[0] + "," + this.rgb[1] + "," + this.rgb[2] + "," + this.v + "\n";
    }

    @Override
    protected byte[] toVMD() {
        ByteBuffer ret = ByteBuffer.allocate(28).order(ByteOrder.LITTLE_ENDIAN);
        ret.putInt(this.frame);
        ret.putFloat(this.rgb[0]);
        ret.putFloat(this.rgb[1]);
        ret.putFloat(this.rgb[2]);
        double[] x = this.v.toDouble();
        ret.putFloat((float)x[0]);
        ret.putFloat((float)x[1]);
        ret.putFloat((float)x[2]);
        return ret.array();
    }

    @Override
    public LightPose clone() {
        return new LightPose(this);
    }
}

