/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmd.motion.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import jp.sfjp.mikutoga.bin.parser.MmdFormatException;
import jp.sourceforge.mmd.motion.BonePose;
import jp.sourceforge.mmd.motion.CsvSpliter;
import jp.sourceforge.mmd.motion.MorphPose;
import jp.sourceforge.mmd.motion.geo.Matrix;
import jp.sourceforge.mmd.motion.geo.Vector3D;
import jp.sourceforge.mmd.motion.model.Bone;
import jp.sourceforge.mmd.motion.model.Model;

public class Morph {
    protected Model model;
    protected String name = null;
    protected int id;
    protected Map<Morph, Float> morphChildren = null;
    protected Map<Bone, BonePose> boneChildren = null;
    protected double factor = 0.0;
    protected double groupFactor = 0.0;
    protected boolean changed = false;

    public Morph(Model m) {
        this.model = m;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public int hashCode() {
        if (this.model == null) {
            return 0;
        }
        if (this.name == null) {
            return 0;
        }
        return (this.model.getName() + "/" + this.name).hashCode() + 1;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Morph other = (Morph)obj;
        if (this.model != other.model && (this.model == null || this.model.getName().compareTo(other.model.getName()) != 0)) {
            return false;
        }
        return !(this.name != null ? this.name.compareTo(other.name) == 0 : other.name != null);
    }

    public Morph addChild(Morph child, float factor) {
        if (this.morphChildren == null) {
            this.morphChildren = new HashMap<Morph, Float>();
        }
        this.morphChildren.put(child, Float.valueOf(factor));
        return this;
    }

    public Morph addChild(Bone child, BonePose pose) {
        if (this.boneChildren == null) {
            this.boneChildren = new HashMap<Bone, BonePose>();
        }
        this.boneChildren.put(child, pose);
        return this;
    }

    public void setFactor(double factor) {
        if (this.factor == factor) {
            return;
        }
        if (this.morphChildren != null) {
            for (Map.Entry<Morph, Float> e : this.morphChildren.entrySet()) {
                e.getKey().setFactorG(factor * (double)e.getValue().floatValue());
            }
        } else if (this.boneChildren != null) {
            for (Map.Entry<Bone, BonePose> e : this.boneChildren.entrySet()) {
                Bone b = e.getKey();
                BonePose p = e.getValue();
                b.moveMorph(p.v.times(factor - this.factor), p.mr.power(factor - this.factor));
            }
        }
        this.factor = factor;
        this.changed = true;
    }

    private void setFactorG(double factor) {
        if (this.morphChildren != null) {
            for (Map.Entry<Morph, Float> e : this.morphChildren.entrySet()) {
                e.getKey().setFactorG(factor * (double)e.getValue().floatValue());
            }
        } else if (this.boneChildren != null) {
            for (Map.Entry<Bone, BonePose> e : this.boneChildren.entrySet()) {
                Bone b = e.getKey();
                BonePose p = e.getValue();
                b.moveMorph(p.v.times(factor - this.groupFactor), p.mr.power(factor - this.groupFactor));
            }
        }
        this.groupFactor = factor;
    }

    public boolean getChanged() {
        return this.changed;
    }

    public void resetChanged() {
        this.changed = false;
    }

    public boolean isGroupMorph() {
        return this.morphChildren != null;
    }

    public boolean isBoneMorph() {
        return this.boneChildren != null;
    }

    public Set<Map.Entry<Morph, Float>> getGroupSet() {
        if (this.morphChildren == null) {
            return null;
        }
        return this.morphChildren.entrySet();
    }

    public Set<Bone> getBoneSet() {
        if (this.boneChildren == null) {
            return null;
        }
        return this.boneChildren.keySet();
    }

    public void setPose(MorphPose p) {
        if (p.nameOfBone.compareTo(this.name) != 0) {
            return;
        }
        if (this.factor != (double)p.factor) {
            this.setFactor(p.factor);
        }
    }

    public MorphPose getPose() {
        MorphPose p = new MorphPose();
        p.nameOfBone = this.name;
        p.factor = (float)this.factor;
        return p;
    }

    public String toString() {
        return this.name + ":" + this.factor;
    }

    public static Morph fromCSV(Model m, String line) throws MmdFormatException {
        String[] p = CsvSpliter.split(line);
        if (p.length < 4) {
            return null;
        }
        if (p[0].compareTo("Morph") != 0) {
            throw new MmdFormatException("not Morph line");
        }
        Morph ret = new Morph(m);
        ret.name = p[1];
        return ret;
    }

    public static void fromCSVList(Model m, String line) throws MmdFormatException {
        String[] p = CsvSpliter.split(line);
        if (p.length < 4) {
            return;
        }
        try {
            if (p[0].startsWith("GroupMorph")) {
                m.getMorph(p[1]).addChild(m.getMorph(p[2]), Float.parseFloat(p[3]));
            } else if (p[1].startsWith("BoneMorph")) {
                BonePose bp = new BonePose();
                bp.v = new Vector3D(Double.parseDouble(p[3]), Double.parseDouble(p[4]), Double.parseDouble(p[5]));
                bp.mr = Matrix.rotationQ(Double.parseDouble(p[6]), Double.parseDouble(p[7]), Double.parseDouble(p[8]), Double.parseDouble(p[9]));
                bp.nameOfBone = p[2];
                m.getMorph(p[1]).addChild(m.get(p[2]), bp);
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new MmdFormatException("\u5217\u304c\u8db3\u308a\u307e\u305b\u3093");
        }
        catch (NumberFormatException e) {
            throw new MmdFormatException("\u6570\u5b57\u3058\u3083\u3042\u308a\u307e\u305b\u3093");
        }
    }
}

