/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmd.midiMotion;

import java.util.ArrayList;
import jp.sourceforge.mmd.midiMotion.ProgressLisner;
import jp.sourceforge.mmd.midiMotion.midi.MidiResolver;
import jp.sourceforge.mmd.motion.Motion;

public abstract class MotionBuilder {
    protected float fps = 30.0f;
    protected Motion motion;
    protected ArrayList<ProgressLisner> pl;
    protected MidiResolver mm;

    protected MotionBuilder() {
        this.motion = new Motion();
        this.pl = new ArrayList();
    }

    protected MotionBuilder(Motion init) {
        this.motion = init;
    }

    public void setFPS(float fps) {
        this.fps = fps;
    }

    public float getFPS() {
        return this.fps;
    }

    public Motion getMotion() {
        return this.motion;
    }

    public void resetMotion() {
        this.motion = new Motion(this.motion.getModelName());
    }

    public void addProgressListener(ProgressLisner l) {
        this.pl.add(l);
    }

    public void removeProgressListener(ProgressLisner l) {
        this.pl.remove(l);
    }

    protected void reportProgress(int frame) {
        for (ProgressLisner l : this.pl) {
            l.progressMid(frame);
        }
    }

    protected void reportProgressStart() {
        for (ProgressLisner l : this.pl) {
            l.progressStart((int)((double)this.mm.getMidiSeq().getMicrosecondLength() * (double)this.fps / 1000000.0));
        }
    }

    protected void reportProgressEnd() {
        for (ProgressLisner l : this.pl) {
            l.progressEnd();
        }
    }

    protected int ticsToFrame(long tics) {
        return (int)((double)tics * (double)this.mm.getTemp() * (double)this.fps / (double)(this.mm.getReso() * 1000000));
    }

    public void setMidiResolver(MidiResolver midiR) {
        this.mm = midiR;
    }

    public abstract void loadMessages();
}

