/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmd.midiMotion.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import javax.sound.midi.InvalidMidiDataException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;
import jp.sourceforge.mmd.midiMotion.midi.MidiResolver;

public class MidiConcat
extends JFrame {
    private MidiResolver mir;
    private File midiDir;
    private JButton buttonAdd;
    private JButton buttonDo;
    private JButton buttonDown;
    private JButton buttonEmpty;
    private JButton buttonRemove;
    private JButton buttonUp;
    private JScrollPane jScrollPane2;
    private JTable midiTable;

    public MidiConcat() {
        super("Midi Concatnate");
        String s = System.getProperty("midiMotion.midiDir");
        if (s != null) {
            this.midiDir = new File(s);
        }
        this.initComponents();
        this.setDropTarget(new HteDropTarget(this));
    }

    private void initComponents() {
        this.jScrollPane2 = new JScrollPane();
        this.midiTable = new JTable();
        this.buttonAdd = new JButton();
        this.buttonDo = new JButton();
        this.buttonRemove = new JButton();
        this.buttonUp = new JButton();
        this.buttonDown = new JButton();
        this.buttonEmpty = new JButton();
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.midiTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"\u30d5\u30a1\u30a4\u30eb\u540d", "\u958b\u59cb\u70b9(beat)", "\u9577\u3055(beat)"}));
        this.midiTable.setToolTipText("mid \u30d5\u30a1\u30a4\u30eb\u3092\u30c9\u30ed\u30c3\u30d7\u3057\u3066\u8ffd\u52a0\u3067\u304d\u308b");
        this.midiTable.setSelectionMode(0);
        this.jScrollPane2.setViewportView(this.midiTable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.getContentPane().add((Component)this.jScrollPane2, gridBagConstraints);
        this.buttonAdd.setText("add");
        this.buttonAdd.setToolTipText("\u9078\u629e\u3057\u305f mid \u306e\u4e0b\u306b\u3001mid \u30d5\u30a1\u30a4\u30eb\u3092\u8ffd\u52a0");
        this.buttonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MidiConcat.this.buttonAddActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.getContentPane().add((Component)this.buttonAdd, gridBagConstraints);
        this.buttonDo.setText("do");
        this.buttonDo.setToolTipText("\u7e4b\u3044\u3067\u4fdd\u5b58\u3059\u308b");
        this.buttonDo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MidiConcat.this.buttonDoActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        this.getContentPane().add((Component)this.buttonDo, gridBagConstraints);
        this.buttonRemove.setText("remove");
        this.buttonRemove.setToolTipText("\u9078\u629e\u3057\u305f mid \u3092\u30ea\u30b9\u30c8\u304b\u3089\u9664\u304f");
        this.buttonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MidiConcat.this.buttonRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        this.getContentPane().add((Component)this.buttonRemove, gridBagConstraints);
        this.buttonUp.setText("\u2191");
        this.buttonUp.setToolTipText("\u9078\u629e\u3057\u3066\u3044\u308b mid \u3092\u4e0a\u306b");
        this.buttonUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MidiConcat.this.buttonUpActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        this.getContentPane().add((Component)this.buttonUp, gridBagConstraints);
        this.buttonDown.setText("\u2193");
        this.buttonDown.setToolTipText("\u9078\u629e\u3057\u3066\u3044\u308b mid \u3092\u4e0b\u306b");
        this.buttonDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MidiConcat.this.buttonDownActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        this.getContentPane().add((Component)this.buttonDown, gridBagConstraints);
        this.buttonEmpty.setText("empty");
        this.buttonEmpty.setToolTipText("\u9078\u629e\u3055\u308c\u3066\u308bmid\u306e\u4e0b\u306b\u7a7a\u306emid\u3092\u8ffd\u52a0");
        this.buttonEmpty.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MidiConcat.this.buttonEmptyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        this.getContentPane().add((Component)this.buttonEmpty, gridBagConstraints);
        this.pack();
    }

    private void buttonAddActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser(this.midiDir);
        jfc.setFileFilter(new FileNameExtensionFilter("MIDI File", "mid"));
        jfc.setMultiSelectionEnabled(true);
        if (jfc.showOpenDialog(this) != 0) {
            return;
        }
        this.add(jfc.getSelectedFiles());
        int i = this.midiTable.getSelectedRow();
        if (i < 0) {
            return;
        }
        DefaultTableModel dtm = (DefaultTableModel)this.midiTable.getModel();
        int n = dtm.getRowCount();
        int offset = (Integer)dtm.getValueAt(i, 1);
        dtm.moveRow(n - 1, n - 1, i + 1);
        for (int j = i + 1; j < n; ++j) {
            dtm.setValueAt(offset += ((Integer)dtm.getValueAt(j - 1, 2)).intValue(), j, 1);
        }
    }

    private void add(File[] fs) {
        DefaultTableModel m = (DefaultTableModel)this.midiTable.getModel();
        int offset = 0;
        int n = m.getRowCount();
        for (int i = 0; i < n; ++i) {
            offset += ((Integer)m.getValueAt(i, 2)).intValue();
        }
        for (File f : fs) {
            try {
                MidiResolver midiR = new MidiResolver(f);
                int l = (int)(midiR.getMidiSeq().getTickLength() / (long)midiR.getReso());
                m.addRow(new Object[]{midiR, offset, l});
                offset += l;
            }
            catch (InvalidMidiDataException ex) {
                JOptionPane.showConfirmDialog(this, "\u7570\u5e38\u306aMIDI\u30c7\u30fc\u30bf\nfile: " + f.toString() + "\nerr: " + ex.getMessage());
            }
            catch (IOException ex) {
                JOptionPane.showConfirmDialog(this, "\u8aad\u307f\u8fbc\u307fIO\u30a8\u30e9\u30fc\nfile: " + f.toString() + "\nerr: " + ex.getMessage());
            }
        }
    }

    private void buttonDoActionPerformed(ActionEvent evt) {
        DefaultTableModel dtm = (DefaultTableModel)this.midiTable.getModel();
        int l = dtm.getRowCount();
        MidiResolver mr = (MidiResolver)dtm.getValueAt(0, 0);
        for (int i = 1; i < l; ++i) {
            MidiResolver added = (MidiResolver)dtm.getValueAt(i, 0);
            mr.add(added);
        }
        JFileChooser jfc = new JFileChooser(this.midiDir);
        jfc.setFileFilter(new FileNameExtensionFilter("MIDI File", "mid"));
        if (jfc.showSaveDialog(this) != 0) {
            return;
        }
        File f = jfc.getSelectedFile();
        if (!f.getName().toLowerCase().endsWith(".mid")) {
            f = new File(f.getParentFile(), f.getName() + ".mid");
        }
        try {
            FileOutputStream fos = new FileOutputStream(f);
            mr.write(fos);
            fos.close();
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "IO \u30a8\u30e9\u30fc:" + ex.getLocalizedMessage());
        }
    }

    private void buttonRemoveActionPerformed(ActionEvent evt) {
        DefaultTableModel dtm = (DefaultTableModel)this.midiTable.getModel();
        int i = this.midiTable.getSelectedRow();
        if (i < 0) {
            return;
        }
        int offset = (Integer)dtm.getValueAt(i, 1);
        int n = dtm.getRowCount();
        for (int j = i + i; j < n; ++j) {
            dtm.setValueAt(offset, j, 1);
            offset += ((Integer)dtm.getValueAt(j, 2)).intValue();
        }
        dtm.removeRow(i);
    }

    private void buttonUpActionPerformed(ActionEvent evt) {
        int i = this.midiTable.getSelectedRow();
        if (i < 1) {
            return;
        }
        DefaultTableModel dtm = (DefaultTableModel)this.midiTable.getModel();
        int n = dtm.getRowCount();
        int offset = (Integer)dtm.getValueAt(i - 1, 1);
        dtm.moveRow(i, i, i - 1);
        for (int j = i - 1; j < n; ++j) {
            dtm.setValueAt(offset, j, 1);
            offset += ((Integer)dtm.getValueAt(j, 2)).intValue();
        }
        this.midiTable.getSelectionModel().setLeadSelectionIndex(i - 1);
    }

    private void buttonDownActionPerformed(ActionEvent evt) {
        int i = this.midiTable.getSelectedRow();
        if (i < 0) {
            return;
        }
        DefaultTableModel dtm = (DefaultTableModel)this.midiTable.getModel();
        int n = dtm.getRowCount();
        if (i == n - 1) {
            return;
        }
        int offset = (Integer)dtm.getValueAt(i, 1);
        dtm.moveRow(i, i, i + 1);
        for (int j = i; j < n; ++j) {
            dtm.setValueAt(offset, j, 1);
            offset += ((Integer)dtm.getValueAt(j, 2)).intValue();
        }
        this.midiTable.getSelectionModel().setLeadSelectionIndex(i + 1);
    }

    private void buttonEmptyActionPerformed(ActionEvent evt) {
        int beat;
        String s = JOptionPane.showInputDialog(this, "\u4f55 beats \u7a7a\u3051\u308b?", "Empty midi", 3);
        try {
            beat = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return;
        }
        MidiResolver mr = new MidiResolver(beat);
        DefaultTableModel dtm = (DefaultTableModel)this.midiTable.getModel();
        int n = dtm.getRowCount();
        int i = this.midiTable.getSelectedRow();
        if (i < 0) {
            i = n - 1;
        }
        int offset = (Integer)dtm.getValueAt(i, 2);
        dtm.addRow(new Object[]{mr, offset, beat});
        dtm.moveRow(n, n, i + 1);
        for (int j = i + 2; j <= n; ++j) {
            dtm.setValueAt(offset += ((Integer)dtm.getValueAt(j - 1, 2)).intValue(), j, 1);
        }
    }

    public static void main(String[] args) {
        MidiResolver midiR1 = null;
        if (args.length < 2) {
            String[] e = System.err;
            e.println("Usage:");
            e.println("\t$ java -cp MID2Motion.jar jp.sourceforge.mmd.midiMotion.gui.MidiConcat (Output MIDI) (MIDI file) (MIDI file) ...\n");
            e.println("concatted .mid will be outputed.");
            System.exit(1);
        }
        try {
            for (String s : args) {
                FileInputStream fis = new FileInputStream(s);
                if (midiR1 == null) {
                    midiR1 = new MidiResolver(new File(s));
                    continue;
                }
                MidiResolver midiRA = new MidiResolver(new File(s));
                midiR1.add(midiRA);
            }
            midiR1.write(new FileOutputStream("catted.mid"));
        }
        catch (InvalidMidiDataException ex) {
            System.err.println(ex);
        }
        catch (FileNotFoundException ex) {
            System.err.println(ex);
        }
        catch (IOException ex) {
            System.err.println(ex);
        }
    }

    private class HteDropTarget
    extends DropTarget {
        private MidiConcat parent;

        HteDropTarget(MidiConcat midiC) {
            this.parent = midiC;
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            Transferable t = dtde.getTransferable();
            if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dtde.acceptDrop(0x40000000);
                try {
                    List list = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                    MidiConcat.this.add(list.toArray(new File[list.size()]));
                }
                catch (UnsupportedFlavorException list) {
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(this.parent, "IO \u30a8\u30e9\u30fc:" + ex.getLocalizedMessage());
                }
            }
        }
    }
}

