/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmd.motion;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;
import java.util.TreeMap;
import jp.sourceforge.mmd.motion.CsvSpliter;
import jp.sourceforge.mmd.motion.Pose;

public class BooleanPose
extends Pose<BooleanPose>
implements Comparable<BooleanPose> {
    public boolean show;
    public TreeMap<String, Boolean> iks;

    public BooleanPose() {
        this.nameOfBone = "\u8868\u793a";
        this.show = true;
        this.iks = new TreeMap();
    }

    public BooleanPose(BooleanPose p) {
        super(p);
        this.show = p.show;
        this.iks = new TreeMap();
        this.iks.putAll(p.iks);
    }

    @Override
    public boolean equals(BooleanPose p) {
        return super.equals2(p) && this.show == p.show && this.iks.equals(p.iks);
    }

    public static BooleanPose fromCSV(String line) throws NumberFormatException {
        String[] column = CsvSpliter.split(line);
        if (column.length < 3) {
            return null;
        }
        BooleanPose p = new BooleanPose();
        p.frame = Integer.parseInt(column[0]);
        p.show = column[1].equalsIgnoreCase("TRUE");
        p.iks = new TreeMap();
        int l = Integer.parseInt(column[2]);
        for (int i = 0; i < l; ++i) {
            p.iks.put(column[3 + i * 2], column[4 + i * 2].equalsIgnoreCase("TRUE"));
        }
        return p;
    }

    @Override
    public String toCSV() {
        String ret = this.frame + "," + this.show + "," + this.iks.size();
        for (Map.Entry<String, Boolean> e : this.iks.entrySet()) {
            ret = ret + "," + e.getKey() + "," + e.getValue();
        }
        return ret + "\n";
    }

    @Override
    protected byte[] toVMD() {
        int l = this.iks.size();
        ByteBuffer ret = ByteBuffer.allocate(9 + l * 21).order(ByteOrder.LITTLE_ENDIAN);
        ret.putInt(this.frame);
        ret.put((byte)(this.show ? 1 : 0));
        ret.putInt(l);
        try {
            for (Map.Entry<String, Boolean> e : this.iks.entrySet()) {
                byte[] a = e.getKey().getBytes("MS932");
                ret.put(a);
                for (int i = a.length; i < 20; ++i) {
                    ret.put((byte)0);
                }
                ret.put((byte)(e.getValue() != false ? 1 : 0));
            }
        }
        catch (UnsupportedEncodingException ex) {
            System.err.println("Syntax error in Pose.toVMD.");
            System.exit(-1);
        }
        return ret.array();
    }

    @Override
    public BooleanPose clone() {
        return new BooleanPose(this);
    }

    @Override
    public int compareTo(BooleanPose o) {
        int ret = this.frame - o.frame;
        if (ret != 0) {
            return ret;
        }
        if (this.show != o.show) {
            return this.show ? -1 : 1;
        }
        return this.iks.equals(o.iks) ? 0 : 1;
    }
}

