/*
 * The MIT License
 *
 * Copyright 2015 nazo.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package jp.sourceforge.mmd.motion;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

/**
 *
 * @author nazo
 */
public class ShadowPose extends Pose<ShadowPose> {

    /**
     * 影が届く距離. 初期値 8875.
     */
    public float distance;
    /**
     * セルフ影モード. 0:なし, 1:モード1(初期値), 2:モード2.
     */
    public byte mode;

    public ShadowPose(){
        super();
        nameOfBone="セルフ影";
        distance = 8875f;
        mode=1;
    }

    public ShadowPose(ShadowPose p){
        super(p);
        distance=p.distance;
        mode=p.mode;
    }

    /**
     * 等しいかを比較する. {@link Pose#equals(Pose)} 同様フレーム番の
     * 違いは無視される.
     * @param p 比較対象.
     * @return 等しければ true.
     */
    @Override
    public boolean equals(ShadowPose p){
        return super.equals2(p) && distance==p.distance && mode==p.mode;
    }
    
    static public ShadowPose fromCSV(String line) throws NumberFormatException{
        String [] column=CsvSpliter.split(line);
        if(column.length<3)return null;
        ShadowPose p=new ShadowPose();

        p.frame=Integer.parseInt(column[0]);
        p.mode=Byte.parseByte(column[1]);
        p.distance=Float.parseFloat(column[2]);
        return p;
    }

    @Override
    public String toCSV() {
        return frame+","+mode+","+distance+"\n";
    }

    @Override
    protected byte[] toVMD() {
        int i;
        byte [] a;
        ByteBuffer ret=ByteBuffer.allocate(9).order(ByteOrder.LITTLE_ENDIAN);
        ret.putInt(frame);
        ret.put(mode);
        ret.putFloat(distance);
        return ret.array();
    }

    @Override
    @SuppressWarnings({"CloneDoesntCallSuperClone", "CloneDeclaresCloneNotSupported"})
    public ShadowPose clone() {
        return new ShadowPose(this);
    }
}
