/*
 * The MIT License
 *
 * Copyright 2015 nazo.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package jp.sourceforge.mmd.motion.swing;

import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import jp.sourceforge.mmd.motion.model.Model;
import jp.sourceforge.mmd.motion.Motion;

/**
 * ボーン名のリストを表示するコンボボックス.
 * @author nazo
 */
public class BoneComboBox extends JComboBox<String>{
//    protected BoneListModel list;

    /**
     * ボックスを作る. 最初は空で、使えない.
     */
    public BoneComboBox(){
        setEnabled(false);
    }

    /**
     * MMDモデル内のボーン名列を設定する.
     * @param m MMDモデル
     */
    public void setMMDModel(Model m){
        removeAllItems();
        addItem("(なし)");
        for(String b:m.keys()){
            addItem(b);
        }
        setEnabled(true);
    }

    /**
     * MMDモーション内のボーン名列を設定する.
     * @param m MMDモーション
     */
    public void setMMDMotion(Motion m){
        removeAllItems();
        addItem("(なし)");
        for(String s:m.listOfBone()){
            addItem(s);
        }
        setEnabled(true);
    }

    /**
     * 選択子を設定する.
     * @param boneName ボーン名. {@code null} を設定すると"(なし)"になる.
     */
    public void setSelect(String boneName) {
        ComboBoxModel<String> cbm=getModel();
        int l=cbm.getSize();
        int i;
        if(boneName==null){
            setSelectedIndex(0);
            return;
        }
        for(i=0;i<l;i++){
            if(boneName.equalsIgnoreCase(cbm.getElementAt(i))){
                setSelectedIndex(i);
                return;
            }
        }
    }
}
