/*
 * in public domain.
 */
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import jp.sfjp.mikutoga.bin.parser.MmdFormatException;
import jp.sourceforge.mmd.motion.Motion;
import jp.sourceforge.mmd.motion.Pose;
import jp.sourceforge.mmd.motion.geo.Vector3D;
import jp.sourceforge.mmd.motion.model.Bone;
import jp.sourceforge.mmd.motion.model.Model;

/**
 * MMDMotion のサンプルプログラム
 */
public class MMDMotionSample {
    static public void main(String [] s){
        Model model=null;
        try {
            FileInputStream fis=new FileInputStream("test/初音ミク.pmd");
            model=Model.fromPMD(fis);
            fis.close();
        }catch (MmdFormatException ex){
            System.err.println(ex.getMessage()); // MMD関連ファイルじゃない            
        } catch (FileNotFoundException ex) {
            System.err.println(ex.getMessage()); // ファイルが見つからない
        } catch (IOException ex) {
            System.err.println(ex.getMessage()); // IOエラー
        }

        Motion motion=null;
        try {
            FileInputStream fis=new FileInputStream("test/motion.vmd");
            motion=new Motion().fromVMD(fis);
            fis.close();
            model.setPoses(motion.get(0)); // 0 frame のキーポーズを取得してモデルに適用
            model.resetChanged(); // 変更フラグをリセット
        } catch (FileNotFoundException ex) {
            System.err.println(ex.getMessage()); // ファイルが見つからない
        } catch (IOException ex) {
            System.err.println(ex.getMessage()); // IOエラー
        }catch (MmdFormatException ex) {
            System.err.println(ex.getMessage()); // MMDのファイルじゃない
        }
 
        Bone rhand=model.get("右手首");
        Bone rfoot=model.get("右足ＩＫ");

        rfoot.translationToG(
                rhand.getPos().add(new Vector3D(0,-10,0))
        );        
        Pose [] ps=model.getChanged();
        motion.putAll(ps,0);

        try {
            FileOutputStream fos;
            motion.toVMD(fos=new FileOutputStream("test/newMotion.vmd"));
            fos.close();
        } catch (IOException ex) {
            System.err.println("IOエラーです。"+ex);
        }
    }
}
