/*
 * The MIT License
 *
 * Copyright 2015 nazo.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package jp.sourceforge.mmd.motion.geo;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 *
 * @author nazo
 */
public class MatrixTest {
    
    public MatrixTest() {}
    
    @BeforeClass
    public static void setUpClass() {}
    
    @AfterClass
    public static void tearDownClass() {}
    
    @Before
    public void setUp() {}
    
    @After
    public void tearDown() {}

    /**
     * Test of static methods, of class Matrix.
     */
    @Test
    public void staticAndConstructorTest() {
        assertTrue(new Matrix().equals(new Matrix(new double[]{
            1.0,0.0,0.0,
            0.0,1.0,0.0,
            0.0,0.0,1.0})));
    }

    @Test
    public void singleCalculationTest(){
        Matrix instance = new Matrix(new double[]{
            0.5,Math.sqrt(0.75),0,
            -Math.sqrt(0.75),0.5,0,
            0.0, 0.0, 1
        });

        assertEquals(1.0,instance.det(),1e-9);
        assertEquals(2.0,instance.trace(),1e-9);
        Matrix inverse=instance.inverse();
        assertEquals(1.0,inverse.det(),1e-9);
        assertEquals(2.0,inverse.trace(),1e-9);
        assertArrayEquals("equals the transpose",instance.transpose().toDouble(),inverse.toDouble(),1e-9);

        assertEquals(1.0,inverse.times(instance).det(),1e-9);
        assertEquals(3.0,inverse.times(instance).trace(),1e-9);
    }

    @Test
    public void doubleCalculationTest(){
        Matrix instance = new Matrix(new double[]{
            0.5,Math.sqrt(0.75),0,
            -Math.sqrt(0.75),0.5,0,
            0.0, 0.0, 1
        });

        /** times with Matrix */
        assertArrayEquals("times_Matrix",new double[]{
            -0.5,Math.sqrt(0.75),0,
            -Math.sqrt(0.75),-0.5,0,
            0.0, 0.0, 1
        },instance.times(instance).toDouble(),1e-9);
        assertArrayEquals(new Matrix().toDouble(),
                instance.inverse().times(instance).toDouble(),1e-9);

        /** times with Vector3D */
        assertArrayEquals("times_Vector3D",new double[]{
            0.5, Math.sqrt(0.75), 0.0
        },instance.times(Vector3D.unitX).toDouble(),1e-9);
        assertArrayEquals("times_Vector3D",new double[]{
            -Math.sqrt(0.75), 0.5, 0.0
        },instance.times(Vector3D.unitY).toDouble(),1e-9);
        assertArrayEquals("times_Vector3D",
                new double[]{
                    1.0, 0.0, 0.0,
                    0.0, 1.0, 0.0,
                    0.0, 0.0, 1.0},
                instance.rotate(Vector3D.unitZ.times(
                        Math.sin(-Math.PI/3)),Math.cos(-Math.PI/3)
                ).toDouble(),
                1e-9);

        /** power to scalar */
        assertArrayEquals(new double[]{
             0.0, 1.0,0,
            -1.0, 0.0,0,
            0.0, 0.0, 1
        },instance.power(1.5).toDouble(),1e-9);
    }

    @Test
    public void angleTest(){
        Matrix instance = new Matrix(new double[]{
            0.5,Math.sqrt(0.75),0,
            -Math.sqrt(0.75),0.5,0,
            0.0, 0.0, 1
        });
        double [] results=instance.angles();
        assertArrayEquals(new double [] {0.0, 0.0, -60.0}, results, 1e-9);
        assertArrayEquals(instance.toDouble(),Matrix.rotation(
                results[0], results[1], results[2]
        ).toDouble(),1e-9);
    }

    /**
     * Test of rotationQ method, of class Matrix.
     */
    @Test
    public void quotanionTest() {
        Matrix m = Matrix.rotationQ(0.0, 1.0, 0.0, 0.0);
        assertArrayEquals("rotaionQ",new double []{
             -1.0, 0.0, 0.0,
             0.0, 1.0, 0.0,
             0.0, 0.0, -1.0
        },m.toDouble(),1e-9);
        assertArrayEquals("getQuotanios",new double []{0.0, 1.0, 0.0, 0.0},m.getQuotanions(), 1e-9);
    }

    /**
     * Test of conversion method, of class Matrix.
     */
    @Test
    public void conversionTest() {
        Matrix instance = new Matrix(new double []{1,2,3,4,5,6,7,8,9});
        System.out.println("conversionTest on Matrix\n"+instance);

        assertTrue("getLx",new Vector3D(1,2,3).equals(instance.getLx()));
        assertTrue("getLy",new Vector3D(4,5,6).equals(instance.getLy()));
        assertTrue("getLz",new Vector3D(7,8,9).equals(instance.getLz()));
        assertArrayEquals("transpose",new double[]{
            1,4,7,
            2,5,8,
            3,6,9},instance.transpose().toDouble(),1e-9);
    }
}
