/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmd.motion;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import jp.sfjp.mikutoga.bin.parser.MmdFormatException;
import jp.sfjp.mikutoga.vmd.parser.VmdParser;
import jp.sourceforge.mmd.motion.BonePose;
import jp.sourceforge.mmd.motion.BooleanPose;
import jp.sourceforge.mmd.motion.CameraPose;
import jp.sourceforge.mmd.motion.CsvSpliter;
import jp.sourceforge.mmd.motion.LightPose;
import jp.sourceforge.mmd.motion.MorphPose;
import jp.sourceforge.mmd.motion.MoveOnBone;
import jp.sourceforge.mmd.motion.MoveOnFrame;
import jp.sourceforge.mmd.motion.Pose;
import jp.sourceforge.mmd.motion.ShadowPose;
import jp.sourceforge.mmd.motion.VMDMotionHander;

public class Motion {
    private String modelName = "";
    private int max_frame = 0;
    private TreeMap<Integer, MoveOnFrame> frame_map = new TreeMap();
    private TreeMap<String, MoveOnBone<BonePose>> bone_map = new TreeMap();
    private TreeMap<String, MoveOnBone<MorphPose>> morph_map = new TreeMap();
    private MoveOnBone<CameraPose> cameraArray = new MoveOnBone("\u30ab\u30e1\u30e9");
    private MoveOnBone<LightPose> lightArray = new MoveOnBone("\u7167\u660e");
    private MoveOnBone<ShadowPose> shadowArray = new MoveOnBone("\u30bb\u30eb\u30d5\u5f71");
    private TreeSet<BooleanPose> booleanArray = new TreeSet();

    public Motion() {
    }

    public Motion(String model_name) {
        this();
        this.modelName = model_name;
    }

    public void put(Pose<?> pose) {
        MoveOnBone<Pose> mob;
        Object p = pose.clone();
        if (p instanceof BonePose) {
            mob = this.bone_map.get(((Pose)p).nameOfBone);
            if (mob == null) {
                mob = new MoveOnBone(((Pose)p).nameOfBone);
                this.bone_map.put(((Pose)p).nameOfBone, mob);
            }
            mob.put((BonePose)p);
        } else if (p instanceof MorphPose) {
            mob = this.morph_map.get(((Pose)p).nameOfBone);
            if (mob == null) {
                mob = new MoveOnBone(((Pose)p).nameOfBone);
                this.morph_map.put(((Pose)p).nameOfBone, mob);
            }
            mob.put((BonePose)((Object)((MorphPose)p)));
        } else if (p instanceof CameraPose) {
            this.cameraArray.put((CameraPose)p);
        } else if (p instanceof LightPose) {
            this.lightArray.put((LightPose)p);
        } else if (p instanceof ShadowPose) {
            this.shadowArray.put((ShadowPose)p);
        } else if (p instanceof BooleanPose) {
            this.booleanArray.add((BooleanPose)p);
        }
        MoveOnFrame mof = this.frame_map.get(((Pose)p).frame);
        if (mof == null) {
            mof = new MoveOnFrame(((Pose)p).frame);
            this.frame_map.put(((Pose)p).frame, mof);
            if (((Pose)p).frame > this.max_frame) {
                this.max_frame = ((Pose)p).frame;
            }
        }
        mof.put((Pose<?>)p);
    }

    public void putAll(Pose<?>[] ps, int frame) {
        if (ps == null) {
            return;
        }
        if (frame < 0) {
            frame = 0;
        }
        for (Pose<?> p : ps) {
            p.frame = frame;
            this.put(p);
        }
    }

    public BonePose[] get(String bone) {
        if (bone == null) {
            return null;
        }
        MoveOnBone<BonePose> mob = this.bone_map.get(bone);
        if (mob == null) {
            return null;
        }
        return (BonePose[])mob.toArray(new BonePose[mob.size()]);
    }

    public BonePose get(int frame, String bone) {
        if (bone == null) {
            return null;
        }
        MoveOnBone<BonePose> mob = this.bone_map.get(bone);
        if (mob == null) {
            return null;
        }
        BonePose bp = mob.get(frame);
        if (bp != null) {
            bp = new BonePose(bp);
        }
        return bp;
    }

    public BonePose remove(int frame, String bone) {
        MoveOnFrame mof;
        if (bone == null) {
            return null;
        }
        MoveOnBone<BonePose> mob = this.bone_map.get(bone);
        if (mob == null) {
            return null;
        }
        BonePose bp = mob.remove(frame);
        if (bp == null) {
            return null;
        }
        if (mob.size() == 0) {
            this.bone_map.remove(bone);
        }
        if ((mof = this.frame_map.get(frame)) == null) {
            return bp;
        }
        BonePose bp2 = mof.remove(bone);
        if (bp2 == null) {
            return bp;
        }
        if (mof.size() == 0) {
            this.frame_map.remove(frame);
        }
        return bp;
    }

    public MorphPose[] getMorph(String morph) {
        if (morph == null) {
            return null;
        }
        MoveOnBone<MorphPose> mob = this.morph_map.get(morph);
        if (mob == null) {
            return null;
        }
        return (MorphPose[])mob.toArray(new MorphPose[mob.size()]);
    }

    public MorphPose getMorph(int frame, String morph) {
        if (morph == null) {
            return null;
        }
        MoveOnBone<MorphPose> mob = this.morph_map.get(morph);
        if (mob == null) {
            return null;
        }
        MorphPose mp = mob.get(frame);
        if (mp != null) {
            mp = new MorphPose(mp);
        }
        return mp;
    }

    public MorphPose removeMorph(int frame, String morph) {
        MoveOnFrame mof;
        if (morph == null) {
            return null;
        }
        MoveOnBone<MorphPose> mob = this.morph_map.get(morph);
        if (mob == null) {
            return null;
        }
        MorphPose bp = mob.remove(frame);
        if (bp == null) {
            return null;
        }
        if (mob.size() == 0) {
            this.morph_map.remove(morph);
        }
        if ((mof = this.frame_map.get(frame)) == null) {
            return bp;
        }
        MorphPose bp2 = mof.removeMorph(morph);
        if (bp2 == null) {
            return bp;
        }
        if (mof.size() == 0) {
            this.frame_map.remove(frame);
        }
        return bp;
    }

    public Pose<?>[] get(int frame) {
        MoveOnFrame mof = this.frame_map.get(frame);
        if (mof == null) {
            return null;
        }
        return mof.toArray();
    }

    public Pose<?>[] getInterporate(int frame) {
        int i = 0;
        Pose[] ret = new Pose[this.bone_map.size() + this.morph_map.size()];
        for (MoveOnBone<BonePose> moveOnBone : this.bone_map.values()) {
            ret[i] = moveOnBone.getInterporate(frame);
            ++i;
        }
        for (MoveOnBone<Pose> moveOnBone : this.morph_map.values()) {
            ret[i] = moveOnBone.getInterporate(frame);
            ++i;
        }
        return ret;
    }

    public BonePose getInterporateBone(int frame, String boneName) {
        BonePose ret;
        MoveOnBone<BonePose> e = this.bone_map.get(boneName);
        if (e == null) {
            ret = new BonePose();
            ret.frame = frame;
            ret.nameOfBone = boneName;
        } else {
            ret = e.getInterporate(frame);
        }
        return ret;
    }

    public MorphPose getInterporateMorph(int frame, String morphName) {
        MorphPose ret;
        MoveOnBone<MorphPose> e = this.morph_map.get(morphName);
        if (e == null) {
            ret = new MorphPose();
            ret.frame = frame;
            ret.nameOfBone = morphName;
        } else {
            ret = e.getInterporate(frame);
        }
        return ret;
    }

    public void gc() {
        MoveOnFrame mof;
        Integer[] list;
        for (Map.Entry<String, MoveOnBone<BonePose>> entry : this.bone_map.entrySet()) {
            for (Integer i : list = entry.getValue().gc()) {
                mof = this.frame_map.get(i);
                mof.remove(entry.getKey());
                if (mof.size() != 0) continue;
                this.frame_map.remove(i);
            }
        }
        for (Map.Entry<String, MoveOnBone<Pose>> entry : this.morph_map.entrySet()) {
            for (Integer i : list = entry.getValue().gc()) {
                mof = this.frame_map.get(i);
                mof.removeMorph(entry.getKey());
                if (mof.size() != 0) continue;
                this.frame_map.remove(i);
            }
        }
    }

    public void toCSV(OutputStream os) throws IOException {
        MoveOnBone<Pose> mob;
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter(os, "MS932");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        osw.write("Vocaloid Motion Data 0002,0\n" + this.modelName + "\n");
        int num_bone = 0;
        StringBuilder list = new StringBuilder(4096);
        for (Map.Entry<String, MoveOnBone<BonePose>> entry : this.bone_map.entrySet()) {
            mob = entry.getValue();
            num_bone += mob.size();
            list.append(mob.toCSV());
        }
        osw.write(num_bone + "\n" + list);
        num_bone = 0;
        list = new StringBuilder(4096);
        for (Map.Entry<String, MoveOnBone<Pose>> entry : this.morph_map.entrySet()) {
            mob = entry.getValue();
            num_bone += mob.size();
            list.append(mob.toCSV());
        }
        osw.write(num_bone + "\n" + list);
        osw.write(this.cameraArray.size() + "\n" + this.cameraArray.toCSV());
        osw.write(this.lightArray.size() + "\n" + this.lightArray.toCSV());
        osw.write(this.shadowArray.size() + "\n" + this.shadowArray.toCSV());
        osw.write(this.booleanArray.size() + "\n");
        for (BooleanPose booleanPose : this.booleanArray) {
            osw.write(booleanPose.toCSV());
        }
        osw.flush();
        os.flush();
    }

    public void toVMD(OutputStream os) throws IOException {
        MoveOnBone<Pose> mob;
        int i;
        ByteBuffer bbInt = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        try {
            os.write("Vocaloid Motion Data 0002".getBytes("MS932"));
        }
        catch (UnsupportedEncodingException ex) {
            System.err.println("Syntax error in toVMD in Motion class.");
            System.exit(-1);
        }
        os.write(0);
        os.write(bbInt.putInt(0).array());
        byte[] temp = this.modelName.getBytes("MS932");
        for (i = 0; i < temp.length && i < 20; ++i) {
            os.write(temp[i]);
        }
        while (i < 20) {
            os.write(0);
            ++i;
        }
        int number = 0;
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        for (Map.Entry<String, MoveOnBone<BonePose>> entry : this.bone_map.entrySet()) {
            mob = entry.getValue();
            number += mob.size();
            list.add(mob.toVMD());
        }
        os.write(bbInt.putInt(0, number).array());
        for (byte[] byArray : list) {
            os.write(byArray);
        }
        number = 0;
        list.clear();
        for (Map.Entry<String, MoveOnBone<Pose>> entry : this.morph_map.entrySet()) {
            mob = entry.getValue();
            number += mob.size();
            list.add(mob.toVMD());
        }
        os.write(bbInt.putInt(0, number).array());
        for (byte[] byArray : list) {
            os.write(byArray);
        }
        os.write(bbInt.putInt(0, this.cameraArray.size()).array());
        os.write(this.cameraArray.toVMD());
        os.write(bbInt.putInt(0, this.lightArray.size()).array());
        os.write(this.lightArray.toVMD());
        os.write(bbInt.putInt(0, this.shadowArray.size()).array());
        os.write(this.shadowArray.toVMD());
        os.write(bbInt.putInt(0, this.booleanArray.size()).array());
        for (BooleanPose booleanPose : this.booleanArray) {
            os.write(booleanPose.toVMD());
        }
        os.flush();
    }

    public Motion fromCSV(InputStream is) throws IOException, MmdFormatException {
        return this.fromCSV(is, 0);
    }

    public Motion fromCSV(InputStream is, int offsetF) throws IOException, MmdFormatException {
        Pose p;
        int i;
        int l;
        BufferedReader br = null;
        int numOfLine = 1;
        try {
            br = new BufferedReader(new InputStreamReader(is, "MS932"));
        }
        catch (UnsupportedEncodingException ex) {
            System.err.println("Syntax err in class Motion.fromCSV.");
            System.exit(-1);
        }
        String line = br.readLine();
        if (!line.startsWith("Vocaloid Motion Data")) {
            throw new MmdFormatException("Header error at line " + numOfLine, 0L);
        }
        ++numOfLine;
        line = br.readLine();
        String[] parts = CsvSpliter.split(line);
        if (this.modelName.length() == 0) {
            this.modelName = parts[0];
        } else if (this.modelName.compareTo(parts[0]) != 0) {
            throw new MmdFormatException("Not the same model. memory:" + this.modelName + ", file:" + parts[0]);
        }
        ++numOfLine;
        line = br.readLine();
        parts = CsvSpliter.split(line);
        try {
            l = Integer.parseInt(parts[0]);
        }
        catch (NumberFormatException e) {
            throw new MmdFormatException("Illegal number for bone lines: " + e.getMessage() + " at line:" + numOfLine);
        }
        for (i = 0; i < l; ++i) {
            ++numOfLine;
            line = br.readLine();
            try {
                p = BonePose.fromCSV(line);
            }
            catch (NumberFormatException e) {
                throw new MmdFormatException("Illegal number for bone line: " + e.getMessage() + " at line:" + numOfLine);
            }
            if (p == null) continue;
            p.frame += offsetF;
            this.put(p);
        }
        ++numOfLine;
        line = br.readLine();
        if (line == null) {
            return this;
        }
        parts = CsvSpliter.split(line);
        try {
            l = Integer.parseInt(parts[0]);
        }
        catch (NumberFormatException e) {
            throw new MmdFormatException("Illegal number for morph lines: " + e.getMessage() + " at line:" + numOfLine);
        }
        for (i = 0; i < l; ++i) {
            ++numOfLine;
            line = br.readLine();
            try {
                p = MorphPose.fromCSV(line);
            }
            catch (NumberFormatException e) {
                throw new MmdFormatException("Illegal number for morph line: " + e.getMessage() + " at line:" + numOfLine);
            }
            if (p == null) continue;
            p.frame += offsetF;
            this.put(p);
        }
        ++numOfLine;
        line = br.readLine();
        if (line == null) {
            return this;
        }
        parts = CsvSpliter.split(line);
        try {
            l = Integer.parseInt(parts[0]);
        }
        catch (NumberFormatException e) {
            throw new MmdFormatException("Illegal number for camera lines: " + e.getMessage() + " at line:" + numOfLine);
        }
        for (i = 0; i < l; ++i) {
            ++numOfLine;
            line = br.readLine();
            try {
                p = CameraPose.fromCSV(line);
            }
            catch (NumberFormatException e) {
                throw new MmdFormatException("Illegal number for camera line: " + e.getMessage() + " at line:" + numOfLine);
            }
            if (p == null) continue;
            p.frame += offsetF;
            this.put(p);
        }
        ++numOfLine;
        line = br.readLine();
        if (line == null) {
            return this;
        }
        parts = CsvSpliter.split(line);
        try {
            l = Integer.parseInt(parts[0]);
        }
        catch (NumberFormatException e) {
            throw new MmdFormatException("Illegal number for light lines: " + e.getMessage() + " at line:" + numOfLine);
        }
        for (i = 0; i < l; ++i) {
            ++numOfLine;
            line = br.readLine();
            try {
                p = LightPose.fromCSV(line);
            }
            catch (NumberFormatException e) {
                throw new MmdFormatException("Illegal number for light line: " + e.getMessage() + " at line:" + numOfLine);
            }
            if (p == null) continue;
            p.frame += offsetF;
            this.put(p);
        }
        ++numOfLine;
        line = br.readLine();
        if (line == null) {
            return this;
        }
        parts = CsvSpliter.split(line);
        try {
            l = Integer.parseInt(parts[0]);
        }
        catch (NumberFormatException e) {
            throw new MmdFormatException("Illegal number for shadow lines: " + e.getMessage() + " at line:" + numOfLine);
        }
        for (i = 0; i < l; ++i) {
            ++numOfLine;
            line = br.readLine();
            try {
                p = ShadowPose.fromCSV(line);
            }
            catch (NumberFormatException e) {
                throw new MmdFormatException("Illegal number for shadow line: " + e.getMessage() + " at line:" + numOfLine);
            }
            if (p == null) continue;
            p.frame += offsetF;
            this.put(p);
        }
        ++numOfLine;
        line = br.readLine();
        if (line == null) {
            return this;
        }
        parts = CsvSpliter.split(line);
        try {
            l = Integer.parseInt(parts[0]);
        }
        catch (NumberFormatException e) {
            throw new MmdFormatException("Illegal number for boolean lines: " + e.getMessage() + " at line:" + numOfLine);
        }
        for (i = 0; i < l; ++i) {
            ++numOfLine;
            line = br.readLine();
            try {
                p = BooleanPose.fromCSV(line);
            }
            catch (NumberFormatException e) {
                throw new MmdFormatException("Illegal number for boolean line: " + e.getMessage() + " at line:" + numOfLine);
            }
            if (p == null) continue;
            p.frame += offsetF;
            this.put(p);
        }
        return this;
    }

    public Motion fromVMD(InputStream is) throws IOException, MmdFormatException {
        return this.fromVMD(is, 0);
    }

    public Motion fromVMD(InputStream is, int frame) throws IOException, MmdFormatException {
        VmdParser vmdp = new VmdParser(is);
        VMDMotionHander parser = new VMDMotionHander(this, frame);
        vmdp.setBasicHandler(parser);
        vmdp.setCameraHandler(parser);
        vmdp.setLightingHandler(parser);
        vmdp.setBoolHandler(parser);
        vmdp.parseVmd();
        return this;
    }

    public String getModelName() {
        return this.modelName;
    }

    public int getMaxFrame() {
        return this.max_frame;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public Set<String> listOfBone() {
        return this.bone_map.keySet();
    }
}

