/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.pmd;

import java.util.regex.Pattern;

public final class ShadingUtil {
    public static final String EXT_SPH = ".sph";
    public static final String EXT_SPA = ".spa";
    private static final String SEPARATOR = Pattern.quote("*");
    private static final Pattern SPLITTER = Pattern.compile(SEPARATOR);

    private ShadingUtil() {
        assert (false);
        throw new AssertionError();
    }

    public static boolean isSpheremapFile(String fname) {
        if (fname.endsWith(EXT_SPH)) {
            return true;
        }
        return fname.endsWith(EXT_SPA);
    }

    public static String[] splitShadingFileInfo(String shadingFile) {
        String[] result = SPLITTER.split(shadingFile, 2);
        assert (result.length == 1 || result.length == 2);
        if (result.length == 1) {
            String onlyFile = result[0];
            result = ShadingUtil.isSpheremapFile(onlyFile) ? new String[]{"", onlyFile} : new String[]{onlyFile, ""};
        }
        assert (result.length == 2);
        return result;
    }
}

