/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmd.midiMotion.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.sound.midi.InvalidMidiDataException;
import javax.swing.Box;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileNameExtensionFilter;
import jp.sourceforge.mmd.midiMotion.gui.MidiConcat;
import jp.sourceforge.mmd.midiMotion.gui.MotionPane;
import jp.sourceforge.mmd.midiMotion.midi.MidiResolver;
import jp.sourceforge.mmd.motion.swing.AboutDialog;
import jp.sourceforge.mmd.motion.swing.FileDropEvent;
import jp.sourceforge.mmd.motion.swing.FileDropListener;
import jp.sourceforge.mmd.motion.swing.FileDropTarget;
import jp.sourceforge.mmd.motion.swing.MmdDialog;
import jp.sourceforge.mmd.motion.swing.VMD2CSV;

public class MidiMotionFrame
extends JFrame
implements FileDropListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    protected MidiResolver midiR;
    protected File midiDir;
    protected Properties prop;
    protected ArrayList<MotionPane> mps;
    protected float fps;
    private HashMap<JMenuItem, String> pluginReadme;
    private JMenuItem menuAbout;
    private JCheckBoxMenuItem menuAlwaysOnTop;
    private JMenuBar menuBar;
    private JMenuItem menuClose;
    private JMenuItem menuConcat;
    private JMenu menuFile;
    private JMenu menuHelp;
    private JMenuItem menuOpen;
    private JMenu menuPlugins;
    private JMenu menuTools;
    private JMenuItem menuVMD2CSV;
    private JMenu menuVisual;
    private JTabbedPane tabPane;
    private JTextField textBeat;
    private JTextField textFPB;
    private JTextField textFPS;
    private JTextField textLength;
    private JTextField textMidiFile;
    private JTextField textTemp;

    public MidiMotionFrame() {
        File[] list;
        try {
            FileInputStream fis = new FileInputStream("./midiMotion.properties");
            this.prop = new Properties();
            this.prop.load(fis);
            fis.close();
            for (String s : this.prop.stringPropertyNames()) {
                System.setProperty(s, this.prop.getProperty(s));
            }
            String s = this.prop.getProperty("midiMotion.midiDir");
            if (s == null) {
                s = "./";
            }
            this.midiDir = new File(s);
            MmdDialog.loadDefault();
        }
        catch (FileNotFoundException ex) {
            this.midiDir = new File("./");
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "IO\u30a8\u30e9\u30fc:\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\n" + ex.getLocalizedMessage());
        }
        this.initComponents();
        this.pluginReadme = new HashMap();
        this.mps = new ArrayList();
        MotionPane mp = null;
        File plugins = new File("plugin/");
        for (File f : list = plugins.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String lower = name.toLowerCase();
                return lower.endsWith(".zip");
            }
        })) {
            try {
                JarEntry je;
                URLClassLoader loader = URLClassLoader.newInstance(new URL[]{f.toURI().toURL()});
                JarFile jf = new JarFile(f);
                Enumeration<JarEntry> e = jf.entries();
                String name = null;
                String readme = null;
                while (e.hasMoreElements()) {
                    je = e.nextElement();
                    name = je.getName();
                    if (name.endsWith("MotionPane.class")) {
                        name = name.substring(0, name.lastIndexOf(46));
                        name = name.replace('/', '.');
                        break;
                    }
                    if (name.equalsIgnoreCase("readme.txt")) {
                        readme = name;
                    }
                    name = null;
                }
                if (name != null) {
                    mp = (MotionPane)loader.loadClass(name).newInstance();
                    this.tabPane.add((Component)mp, mp.getName());
                    this.mps.add(mp);
                }
                while (mp != null && readme == null && e.hasMoreElements()) {
                    je = e.nextElement();
                    name = je.getName();
                    if (name == null) continue;
                    readme = name;
                    break;
                }
                jf.close();
                if (mp == null || readme == null) continue;
                JMenu menuFolder = new JMenu(mp.getName());
                JMenuItem item = new JMenuItem("README.txt");
                this.pluginReadme.put(item, f.getName() + "/" + readme);
                menuFolder.add(item);
                this.menuPlugins.add(menuFolder);
                item.addActionListener(this);
            }
            catch (ClassNotFoundException ex) {
                JOptionPane.showMessageDialog(this, "plugin \u30a8\u30e9\u30fc: \u30af\u30e9\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\nfile:" + f + "\n" + ex.getLocalizedMessage());
            }
            catch (IllegalAccessException ex) {
                JOptionPane.showMessageDialog(this, "\u8aad\u307f\u8fbc\u307f\u6a29\u9650\u304c\u3042\u308a\u307e\u305b\u3093\u3002Web start \u304b Applet \u3067\u3059\u304b?\n\u304a\u305d\u3089\u304f\u7f72\u540d\u3055\u308c\u3066\u306a\u3044\u304b\u3001\u30bb\u30ad\u30e5\u30ea\u30c6\u30a3\u30fc\u7684\u306a\u3053\u3068\u3067\u5f3e\u304b\u308c\u3066\u307e\u3059\u3002\n" + ex.getLocalizedMessage());
            }
            catch (InstantiationException ex) {
                JOptionPane.showMessageDialog(this, "plugin \u30a8\u30e9\u30fc: \u30a4\u30f3\u30b9\u30bf\u30f3\u30b9\u304c\u4f5c\u308c\u307e\u305b\u3093\u3002\u58ca\u308c\u3066\u308b?\nfile:" + f + "\n" + ex.getLocalizedMessage());
            }
            catch (MalformedURLException ex) {
                JOptionPane.showMessageDialog(this, "URL\u7570\u5e38:" + ex.getLocalizedMessage());
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "IO\u7570\u5e38:" + ex.getLocalizedMessage());
            }
        }
        this.textMidiFile.setDropTarget(new FileDropTarget(this));
        this.setSize(this.getPreferredSize());
    }

    private void setFPS() {
        this.fps = Float.parseFloat(this.textFPS.getText());
        if (this.midiR != null) {
            this.textFPB.setText(String.valueOf(this.fps * (float)this.midiR.getTemp() / 1000000.0f) + " frames/beat");
        }
    }

    private void initComponents() {
        this.tabPane = new JTabbedPane();
        JLabel jLabel1 = new JLabel();
        this.textMidiFile = new JTextField();
        JLabel jLabel2 = new JLabel();
        this.textFPS = new JTextField();
        this.textLength = new JTextField();
        this.textTemp = new JTextField();
        this.textBeat = new JTextField();
        this.textFPB = new JTextField();
        this.menuBar = new JMenuBar();
        this.menuFile = new JMenu();
        this.menuOpen = new JMenuItem();
        this.menuClose = new JMenuItem();
        this.menuVisual = new JMenu();
        this.menuAlwaysOnTop = new JCheckBoxMenuItem();
        this.menuTools = new JMenu();
        this.menuVMD2CSV = new JMenuItem();
        this.menuConcat = new JMenuItem();
        this.menuPlugins = new JMenu();
        this.menuHelp = new JMenu();
        this.menuAbout = new JMenuItem();
        this.setDefaultCloseOperation(0);
        this.setTitle("MIDI 2 Motion");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                MidiMotionFrame.this.formWindowClosing(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.tabPane.setEnabled(false);
        this.tabPane.setMinimumSize(new Dimension(200, 140));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.getContentPane().add((Component)this.tabPane, gridBagConstraints);
        jLabel1.setText("midi");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.getContentPane().add((Component)jLabel1, gridBagConstraints);
        this.textMidiFile.setEditable(false);
        this.textMidiFile.setText("\u307e\u3060");
        this.textMidiFile.setToolTipText(".mid \u3092\u30c9\u30ed\u30c3\u30d7\u3059\u308b\u3068\u8aad\u307f\u8fbc\u307f\u307e\u3059.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        this.getContentPane().add((Component)this.textMidiFile, gridBagConstraints);
        jLabel2.setText("fps");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.getContentPane().add((Component)jLabel2, gridBagConstraints);
        this.textFPS.setText("30");
        this.textFPS.setToolTipText("\u66f8\u304d\u63db\u3048\u3089\u308c\u307e\u3059");
        this.textFPS.setMinimumSize(new Dimension(28, 28));
        this.textFPS.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MidiMotionFrame.this.textFPSFocusLost(evt);
            }
        });
        this.textFPS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MidiMotionFrame.this.textFPSActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        this.getContentPane().add((Component)this.textFPS, gridBagConstraints);
        this.textLength.setEditable(false);
        this.textLength.setText("\u79d2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        this.getContentPane().add((Component)this.textLength, gridBagConstraints);
        this.textTemp.setEditable(false);
        this.textTemp.setText("bpm");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.textTemp, gridBagConstraints);
        this.textBeat.setEditable(false);
        this.textBeat.setText("beat");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.textBeat, gridBagConstraints);
        this.textFPB.setEditable(false);
        this.textFPB.setText("frame/beat");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.textFPB, gridBagConstraints);
        this.menuFile.setMnemonic(70);
        this.menuFile.setText("\u30d5\u30a1\u30a4\u30eb(F)");
        this.menuOpen.setMnemonic(79);
        this.menuOpen.setText("MIDI\u3092\u958b\u304f(O)");
        this.menuOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MidiMotionFrame.this.menuOpenActionPerformed(evt);
            }
        });
        this.menuFile.add(this.menuOpen);
        this.menuClose.setMnemonic(88);
        this.menuClose.setText("\u9589\u3058\u308b(X)");
        this.menuClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MidiMotionFrame.this.menuCloseActionPerformed(evt);
            }
        });
        this.menuFile.add(this.menuClose);
        this.menuBar.add(this.menuFile);
        this.menuVisual.setText("\u8868\u793a(V)");
        this.menuAlwaysOnTop.setText("\u5e38\u306b\u624b\u524d\u306b\u8868\u793a(L)");
        this.menuAlwaysOnTop.setToolTipText("\u5e38\u306b\u3069\u306e\u30a6\u30a3\u30f3\u30c9\u30a6\u3088\u308a\u3082\u4e0a");
        this.menuAlwaysOnTop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MidiMotionFrame.this.menuAlwaysOnTopActionPerformed(evt);
            }
        });
        this.menuVisual.add(this.menuAlwaysOnTop);
        this.menuBar.add(this.menuVisual);
        this.menuTools.setMnemonic(84);
        this.menuTools.setText("\u30c4\u30fc\u30eb(T)");
        this.menuVMD2CSV.setMnemonic(86);
        this.menuVMD2CSV.setText("VMD2CSV(V)");
        this.menuVMD2CSV.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MidiMotionFrame.this.menuVMD2CSVActionPerformed(evt);
            }
        });
        this.menuTools.add(this.menuVMD2CSV);
        this.menuConcat.setMnemonic(67);
        this.menuConcat.setText("MIDI Concatenate(C)");
        this.menuConcat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MidiMotionFrame.this.menuConcatActionPerformed(evt);
            }
        });
        this.menuTools.add(this.menuConcat);
        this.menuBar.add(this.menuTools);
        this.menuPlugins.setText("\u30d7\u30e9\u30b0\u30a4\u30f3(P)");
        this.menuBar.add(this.menuPlugins);
        this.menuHelp.setMnemonic(72);
        this.menuHelp.setText("\u30d8\u30eb\u30d7(H)");
        this.menuAbout.setMnemonic(65);
        this.menuAbout.setText("MID2Motion \u306b\u3064\u3044\u3066(A)");
        this.menuAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MidiMotionFrame.this.menuAboutActionPerformed(evt);
            }
        });
        this.menuHelp.add(this.menuAbout);
        this.menuBar.add(Box.createHorizontalGlue());
        this.menuBar.add(this.menuHelp);
        this.setJMenuBar(this.menuBar);
        this.pack();
    }

    private void menuOpenActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser(this.midiDir);
        jfc.setFileFilter(new FileNameExtensionFilter("MIDI", "mid"));
        if (jfc.showOpenDialog(this) != 0) {
            return;
        }
        File f = jfc.getSelectedFile();
        this.openMidiFile(f);
    }

    private void openMidiFile(File midiFile) {
        this.midiDir = midiFile.getParentFile();
        try {
            this.midiR = new MidiResolver(midiFile);
            if (this.midiR != null) {
                this.textMidiFile.setText(midiFile.getName());
                this.textLength.setText((double)this.midiR.getMidiSeq().getMicrosecondLength() / 1000000.0 + "\u79d2");
                this.textTemp.setText(6.0E7 / (double)this.midiR.getTemp() + " bpm");
                this.textBeat.setText((double)this.midiR.getMidiSeq().getTickLength() / (double)this.midiR.getReso() + " beats");
                this.setFPS();
                this.tabPane.setEnabled(true);
                for (MotionPane mp : this.mps) {
                    mp.setMidiResolver(this.midiR);
                }
            }
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "\u8aad\u307f\u8fbc\u307fIO\u30a8\u30e9\u30fc\nfile: " + midiFile.toString() + "\nerr: " + ex.getMessage());
        }
        catch (InvalidMidiDataException ex) {
            JOptionPane.showMessageDialog(this, "\u7570\u5e38\u306aMIDI\u30c7\u30fc\u30bf\nfile: " + midiFile.toString() + "\nerr: " + ex.getMessage());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String fname = this.pluginReadme.get((JMenuItem)e.getSource());
        String zipName = fname.substring(0, fname.indexOf(47));
        String readme = fname.substring(fname.indexOf(47) + 1);
        JDialog dialog = new JDialog(this);
        dialog.setTitle(readme + " in " + zipName);
        ScrollPane sp = new ScrollPane();
        dialog.add(sp);
        JTextArea jtext = new JTextArea();
        sp.setSize(450, 200);
        sp.add(jtext);
        try {
            ZipFile zip = new ZipFile("plugin/" + zipName);
            ZipEntry ze = zip.getEntry(readme);
            InputStream is = zip.getInputStream(ze);
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "MS932"));
            while (br.ready()) {
                jtext.append(br.readLine() + "\n");
            }
            is.close();
            zip.close();
            dialog.setSize(dialog.getPreferredSize());
            dialog.setVisible(true);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "Zip\u30d5\u30a1\u30a4\u30eb" + zipName + "\u304c\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093: " + ex);
        }
    }

    private void menuCloseActionPerformed(ActionEvent evt) {
        this.confirmClose();
    }

    private void confirmClose() {
        int i = JOptionPane.showConfirmDialog(this, "\u7d42\u4e86\u3057\u3066\u3044\u3044\u3067\u3059\u304b", "MIDI2Motion", 0);
        if (i != 0) {
            return;
        }
        Properties p = new Properties();
        MmdDialog.saveDefault();
        for (Map.Entry<Object, Object> e : System.getProperties().entrySet()) {
            String key = (String)e.getKey();
            if (!key.startsWith("midiMotion.") && !key.startsWith("MMDMotion.")) continue;
            p.setProperty(key, (String)e.getValue());
        }
        try {
            p.setProperty("midiMotion.midiDir", this.midiDir.getCanonicalPath());
            FileOutputStream fos = new FileOutputStream("midiMotion.properties");
            p.store(fos, "MidiMotion Setting File");
            fos.close();
        }
        catch (FileNotFoundException ex) {
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "IO\u30a8\u30e9\u30fc:\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e\u66f8\u304d\u8fbc\u307f\u306b\u5931\u6557\n" + ex.getLocalizedMessage());
        }
        this.setVisible(false);
        this.dispose();
    }

    private void menuVMD2CSVActionPerformed(ActionEvent evt) {
        VMD2CSV v2c = new VMD2CSV();
        v2c.setVisible(true);
    }

    private void textFPSActionPerformed(ActionEvent evt) {
        this.setFPS();
    }

    private void textFPSFocusLost(FocusEvent evt) {
        this.setFPS();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.confirmClose();
    }

    private void menuAboutActionPerformed(ActionEvent evt) {
        new AboutDialog((Frame)this, true, this.getClass(), "MIDI to Motion \u306f Standard MIDI File (.mid) \u304b\u3089 MMD\u30e2\u30fc\u30b7\u30e7\u30f3\u3092\u751f\u6210\u3059\u308b Java\u30e9\u30a4\u30d6\u30e9\u30ea\u30fc\u306eGUI\u3067\u3059\u3002").show("MIDI to Motion");
    }

    private void menuConcatActionPerformed(ActionEvent evt) {
        new MidiConcat().setVisible(true);
    }

    private void menuAlwaysOnTopActionPerformed(ActionEvent evt) {
        this.setAlwaysOnTop(this.menuAlwaysOnTop.isSelected());
    }

    @Override
    public void fileDrop(FileDropEvent e) {
        Object src = e.getSource();
        File file = e.getFiles()[0];
        if (src == this.textMidiFile) {
            this.openMidiFile(file);
        }
    }

    public static void main(final String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(MidiMotionFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(MidiMotionFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(MidiMotionFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(MidiMotionFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                File f;
                MidiMotionFrame mmf = new MidiMotionFrame();
                if (args.length >= 1 && (f = new File(args[0])).exists()) {
                    mmf.openMidiFile(f);
                }
                mmf.setVisible(true);
            }
        });
    }
}

