/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mmd.midiMotion.gui;

import java.awt.Color;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.TransferHandler;
import jp.sfjp.mikutoga.bin.parser.MmdFormatException;
import jp.sourceforge.mmd.midiMotion.gui.FileTransferable;
import jp.sourceforge.mmd.motion.model.Model;
import jp.sourceforge.mmd.motion.swing.FileDropEvent;
import jp.sourceforge.mmd.motion.swing.FileDropListener;
import jp.sourceforge.mmd.motion.swing.FileDropTarget;
import jp.sourceforge.mmd.motion.swing.MmdDialog;

public class ModelTextBox
extends JTextField
implements FileDropListener,
MouseListener {
    private Model model = null;
    protected File orgFile = null;

    public ModelTextBox() {
        this.setEditable(false);
        this.setBackground(Color.PINK);
        this.setText("(\u307e\u3060)");
        this.setToolTipText("MMD\u30e2\u30c7\u30eb.PMD, PMX\u3092\u30c9\u30ed\u30c3\u30d7\u53ef\u80fd.");
        this.setDropTarget(new FileDropTarget(this));
        this.addMouseListener(this);
        this.setDragEnabled(false);
        this.setTransferHandler(new FileTransferHandler());
    }

    public void setModel(Model m) {
        this.model = m;
        if (m == null) {
            this.setDragEnabled(false);
            this.orgFile = null;
            this.setText("(\u307e\u3060)");
            this.setToolTipText("MMD\u30e2\u30c7\u30eb.PMD, PMX\u3092\u30c9\u30ed\u30c3\u30d7\u53ef\u80fd.");
        } else {
            this.setText(m.getName());
            this.setToolTipText("<html>" + m.getName() + ":<br>file:" + (this.orgFile == null ? "\u306a\u3057" : this.orgFile.getPath()) + "</html>");
        }
    }

    public void setModel(File file) {
        if (file == null) {
            this.setModel((Model)null);
            return;
        }
        String name = file.getName().toLowerCase();
        Model m = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            if (name.endsWith(".pmx")) {
                m = Model.fromPMX(fis);
            } else if (name.endsWith(".pmd")) {
                m = Model.fromPMD(fis);
            } else if (name.endsWith(".csv")) {
                m = Model.fromCSV(fis);
            } else {
                JOptionPane.showMessageDialog(this, "\u30d5\u30a1\u30a4\u30eb\u5f62\u5f0f\u306b\u5bfe\u5fdc\u3057\u3066\u307e\u305b\u3093:\n" + file.toString());
            }
            fis.close();
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(this, "\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093: " + ex.getLocalizedMessage());
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "\u30d5\u30a1\u30a4\u30eb\u304c\u8aad\u307f\u53d6\u308c\u307e\u305b\u3093: " + ex.getLocalizedMessage());
        }
        catch (MmdFormatException ex) {
            JOptionPane.showMessageDialog(this, "MMD\u306e\u30e2\u30c7\u30eb\u30d5\u30a1\u30a4\u30eb\u3067\u306f\u3042\u308a\u307e\u305b\u3093: " + ex.getLocalizedMessage());
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException ex2) {
                JOptionPane.showMessageDialog(this, "\u30d5\u30a1\u30a4\u30eb\u304c\u8aad\u307f\u53d6\u308c\u307e\u305b\u3093: " + ex2.getLocalizedMessage());
            }
        }
        if (m == null) {
            return;
        }
        this.orgFile = file;
        this.setDragEnabled(true);
        this.setModel(m);
    }

    public Model getModel() {
        return this.model;
    }

    public File getFile() {
        return this.orgFile;
    }

    public void openDialog() {
        Model m = MmdDialog.loadModel(this.getParent());
        if (m == null) {
            return;
        }
        this.orgFile = MmdDialog.lastSelected;
        this.setDragEnabled(true);
        this.setModel(m);
    }

    @Override
    public void fileDrop(FileDropEvent e) {
        File file = e.getFiles()[0];
        this.setModel(file);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() > 1) {
            if (e.getButton() == 3) {
                this.setModel((Model)null);
            } else if (e.getButton() == 1) {
                this.openDialog();
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.selectAll();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private class FileTransferHandler
    extends TransferHandler {
        private FileTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            return new FileTransferable(ModelTextBox.this.orgFile);
        }
    }
}

