/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.mikutoga.typical;

import java.text.Normalizer;
import java.util.HashMap;
import java.util.Map;
import jp.sfjp.mikutoga.typical.I18nAlias;

class AliasMap<T extends I18nAlias> {
    private final Map<String, T> primaryAliasMap = new HashMap<String, T>();
    private final Map<String, T> globalAliasMap = new HashMap<String, T>();

    AliasMap() {
    }

    static String normalize(CharSequence name) {
        String result = Normalizer.normalize(name, Normalizer.Form.NFKC);
        return result;
    }

    void addAlias(T alias) {
        this.addPrimary(alias);
        this.addGlobal(alias);
    }

    private void addPrimary(T alias) {
        for (String primaryName : ((I18nAlias)alias).getPrimaryNameList()) {
            String normalized = AliasMap.normalize(primaryName);
            normalized = normalized.intern();
            this.primaryAliasMap.put(normalized, alias);
        }
    }

    private void addGlobal(T alias) {
        for (String globalName : ((I18nAlias)alias).getGlobalNameList()) {
            String normalized = AliasMap.normalize(globalName);
            normalized = normalized.intern();
            this.globalAliasMap.put(normalized, alias);
        }
    }

    T getAlias(String name) {
        T result = this.getAliasByPrimary(name);
        if (result == null) {
            result = this.getAliasByGlobal(name);
        }
        return result;
    }

    T getAliasByPrimary(String primaryName) {
        String normalized = AliasMap.normalize(primaryName);
        I18nAlias result = (I18nAlias)this.primaryAliasMap.get(normalized);
        return (T)result;
    }

    T getAliasByGlobal(String globalName) {
        String normalized = AliasMap.normalize(globalName);
        I18nAlias result = (I18nAlias)this.globalAliasMap.get(normalized);
        return (T)result;
    }

    String primary2global(String primaryName) {
        T alias = this.getAliasByPrimary(primaryName);
        if (alias == null) {
            return null;
        }
        String globalName = ((I18nAlias)alias).getTopGlobalName();
        return globalName;
    }

    String global2primary(String globalName) {
        T alias = this.getAliasByGlobal(globalName);
        if (alias == null) {
            return null;
        }
        String primary = ((I18nAlias)alias).getTopPrimaryName();
        return primary;
    }
}

