using System.Collections.Generic;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Content.Pipeline;
using Microsoft.Xna.Framework.Content.Pipeline.Graphics;
using Microsoft.Xna.Framework.Content.Pipeline.Processors;
using MikuMikuDance.XNA.Model.ModelData;
using System.ComponentModel;

// TODO: replace these with the processor input and output types.
using TInput = MikuMikuDance.XNA.Model.MMDModelIntermediate;
using TOutput = MikuMikuDance.XNA.Model.MMDModelContext;

namespace MikuMikuDance.XNA.Model
{
    /// <summary>
    /// MikuMikuDancẽff[^XNAɃC|[g邽߂̃vZbT
    /// </summary>
    [ContentProcessor(DisplayName = "MikuMikuDancef : MikuMikuDance for XNA")]
    public class MMDProcessor : ContentProcessor<TInput, TOutput>
    {
        // _H
        // ̃vZbTł͒_eNX`ĝōő{[256ɂȂ
        //const int MaxBones = 256;
        /// <summary>
        /// JX^GtFNggptO
        /// </summary>
        [DefaultValue(false)]
        [DisplayName("JX^GtFNg̎gp")]
        [Description("MikuMikuDanceModelpGtFNgӊÕGtFNggƂtruew")]
        public bool UseCustomEffect { get; set; }

        /// <summary>
        /// JX^GtFNgt@C
        /// </summary>
        [DefaultValue("")]
        [DisplayName("JX^GtFNgt@C")]
        [Description("MikuMikuDanceModelpGtFNgӊÕGtFNggƂɃt@Cw")]
        public string CustomEffectName { get; set; }

        /// <summary>
        /// Recϊ
        /// </summary>
        /// <param name="input">MMDf for XNAԃNX</param>
        /// <param name="context">RegvZbT</param>
        /// <returns>MMDf for XNARec</returns>
        public override TOutput Process(TInput input, ContentProcessorContext context)
        {
            //ԋp
            TOutput result = new MMDModelContext();

            //ЂɂXNA̒_eNX`ŃXLAj[VQl
            //ЂɂXNA̎@ł̓{[255EȂ̂ŁA65535Ɋgł悤ɉǂKv

            //Ô߃XLAj[VɌ̂ǂ`FbN
            ValidateMesh(input.RootNode, context, null);
            //XPgT
            BoneContent skeleton = MeshHelper.FindSkeleton(input.RootNode);
            if (skeleton == null)
                throw new InvalidContentException("XPg܂");
            // f̃bVꂼႤ[JWĂƈ
            // ʓ|Ȃ̂ŁASĂႤ(bV̕ϊW炩ߒ_
            // f[^ɓKp邱)
            FlattenTransforms(input.RootNode, skeleton);

            // oChE|[YƃXPg\ǂݍ
            IList<BoneContent> bones = MeshHelper.FlattenSkeleton(skeleton);

            /*if (bones.Count > MaxBones)
            {
                throw new InvalidContentException(string.Format(
                    "̃XPgɂ{0}̃{[܂Bő{[{1}łB",
                    bones.Count, MaxBones));
            }*/

            List<MMDBoneData> BoneDataProcessed = new List<MMDBoneData>();
            Dictionary<string, int> NamePosDictionary = new Dictionary<string, int>();
            int Pos = 0;
            foreach (BoneContent bone in bones)
            {
                //XLAj[Vpf[^擾
                MMDBoneData mmdbone = new MMDBoneData();
                mmdbone.BindPose = QuatTransform.FromMatrix(bone.Transform);
                mmdbone.InverseBindPose = QuatTransform.FromMatrix(Matrix.Invert(bone.AbsoluteTransform));
                mmdbone.SkeletonHierarchy = bones.IndexOf(bone.Parent as BoneContent);//eo^(ꍇ-1)
                if (!NamePosDictionary.ContainsKey(bone.Name) && bone.Name != "")
                    NamePosDictionary.Add(bone.Name, Pos);
                BoneDataProcessed.Add(mmdbone);
                Pos++;
            }
            //̃{[𓝍
            foreach (var i in input.Bones)
            {
                //{[̐VȈʒu擾
                Pos = NamePosDictionary[i.Name];
                //XLAj[Vf[^Ɠ
                BoneDataProcessed[Pos].BoneType = i.BoneType;
                if (i.IKParentBoneIndex == 0)
                    BoneDataProcessed[Pos].IKParentBoneIndex = 0;
                else
                    BoneDataProcessed[Pos].IKParentBoneIndex = (ushort)NamePosDictionary[input.Bones[i.IKParentBoneIndex].Name];
                BoneDataProcessed[Pos].Name = i.Name;
                if (i.IK != null)
                {//IKf[^Ȃ炻Rs[
                    BoneDataProcessed[Pos].IK = new MMDIKData();
                    BoneDataProcessed[Pos].IK.ControlWeight = i.IK.ControlWeight;
                    BoneDataProcessed[Pos].IK.IKBoneIndex = (ushort)NamePosDictionary[input.Bones[i.IK.IKBoneIndex].Name];
                    BoneDataProcessed[Pos].IK.IKChildBones = new List<ushort>();
                    foreach (var j in i.IK.IKChildBones)
                        BoneDataProcessed[Pos].IK.IKChildBones.Add((ushort)NamePosDictionary[input.Bones[j].Name]);
                    BoneDataProcessed[Pos].IK.IKTargetBoneIndex = (ushort)NamePosDictionary[input.Bones[i.IK.IKTargetBoneIndex].Name];
                    BoneDataProcessed[Pos].IK.Iteration = i.IK.Iteration;
                }
            }
            //x[X{[ݒ
            BoneDataProcessed[0].Name = "base";
            BoneDataProcessed[0].BoneType = MMDBoneType.RotateAndMove;
            BoneDataProcessed[0].IKParentBoneIndex = 0;

            //MMDɂ̓Aj[V͖̂ŁA͔΂
            //// Aj[Vf[^^CptH[}bgɕϊ
            //Dictionary<string, AnimationClip> animationClips;
            //animationClips = ProcessAnimations(skeleton.Animations, bones);

            //fvZbT[ɂ
            OpaqueDataDictionary param = new OpaqueDataDictionary();
            if (UseCustomEffect && CustomEffectName != null)
                param.Add("EffectFile", CustomEffectName);
            else
                param.Add("EffectFile", "");
            result.ModelData = context.Convert<NodeContent, ModelContent>(input.RootNode, "SkinnedModelProcessor", param);
            //result.ModelData = context.Convert<NodeContent, ModelContent>(input.RootNode, "ModelProcessor");
            
            // MMDModelDataɃvZXς݂̃{[i[
            result.Bones = BoneDataProcessed;
            
            //̃fRs[
            //result.IKs = input.IKs;
            result.Skins = input.Skins;
            result.NumVertexForFace = input.NumVertexForFace;
            result.Rigids = input.Rigids;
            result.Joints = input.Joints;
            //̂̏C
            for (int i = 0; i < result.Rigids.Count; i++)
            {
                if (result.Rigids[i].RelatedBoneIndex != 0xffff)
                    result.Rigids[i].RelatedBoneIndex = (ushort)NamePosDictionary[input.Bones[result.Rigids[i].RelatedBoneIndex].Name];
            }
            //ԋp
            return result;
        }

        /// <summary>
        /// ̃bV̓XLAj[VɌ̂`FbN
        /// </summary>
        static void ValidateMesh(NodeContent node, ContentProcessorContext context,
                                 string parentBoneName)
        {
            MeshContent mesh = node as MeshContent;

            if (mesh != null)
            {
                // bV̐𒲂ׂ
                if (parentBoneName != null)
                {
                    context.Logger.LogWarning(null, null,
                        "{0}bV{1}{[̎qłB" +
                        "SkinnedModelProcessor̓bV{[̎qłP[X" +
                        "ΉĂ܂B",
                        mesh.Name, parentBoneName);
                }

                if (!MeshHasSkinning(mesh))
                {
                    context.Logger.LogWarning(null, null,
                        "{0}bV̓XLjO񂪂Ȃ̂ŕϊ܂",
                        mesh.Name);

                    mesh.Parent.Children.Remove(mesh);
                    return;
                }
            }
            else if (node is BoneContent)
            {
                // ̃m[h{[ȂA{[𒲍ł邱ƂoĂ
                parentBoneName = node.Name;
            }

            // ċAI(Ƀm[ĥŁA
            // qB̃Rs[𑖍)
            foreach (NodeContent child in new List<NodeContent>(node.Children))
                ValidateMesh(child, context, parentBoneName);
        }
        /// <summary>
        /// bVXLjOĂ邩ׂ
        /// </summary>
        static bool MeshHasSkinning(MeshContent mesh)
        {
            foreach (GeometryContent geometry in mesh.Geometry)
            {
                if (!geometry.Vertices.Channels.Contains(VertexChannelNames.Weights()))
                    return false;
            }

            return true;
        }
        /// <summary>
        /// SĂWԂɂȂ悤ɁAsKvȕϊs
        /// fEWIgɏĂt
        /// </summary>
        static void FlattenTransforms(NodeContent node, BoneContent skeleton)
        {
            foreach (NodeContent child in node.Children)
            {
                // XPg͏Ȃ
                if (child == skeleton)
                    continue;

                // [JϊsWIgɏĂ
                MeshHelper.TransformScene(child, child.Transform);

                // Ăt̂ŁA[JWϊs
                // Pʍs(Matrix.Identity)ɂȂ
                child.Transform = Matrix.Identity;

                // ċAĂяo
                FlattenTransforms(child, skeleton);
            }
        }
    }
}