using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Content.Pipeline;
using MikuMikuDance.XNA.Motion.MotionData;
// TODO: replace these with the processor input and output types.
using TInput = MikuMikuDance.Motion.Motion2.MMDMotion2;
using TOutput = MikuMikuDance.XNA.Motion.MotionData.MMDMotionData;
using System;

namespace MikuMikuDance.XNA.Motion
{
    /// <summary>
    /// MikuMikuDancẽ[Vf[^f[^XNAɃC|[g邽߂̃vZbT
    /// </summary>
    [ContentProcessor(DisplayName = "MikuMikuDance[V : MikuMikuDance for XNA")]
    public class MMDMotionProcessor : ContentProcessor<TInput, TOutput>
    {
        /// <summary>
        /// Recϊ
        /// </summary>
        /// <param name="input">MMD[Vf[^</param>
        /// <param name="context">RegvZbT</param>
        /// <returns>MMD[Vf[^ for XNA</returns>
        public override TOutput Process(TInput input, ContentProcessorContext context)
        {
            TOutput result = new TOutput();
            //{[[Vf[^̕ϊ
            result.BoneMotions = new MMDBoneMotion[input.Motions.LongLength];
            if (result.BoneMotions.LongLength > int.MaxValue)
                throw new InvalidContentException("{[[V܂BMikuMikuDanceXNA32bittől܂ł[VT|[gĂ܂");
            for (long i = 0; i < result.BoneMotions.LongLength; i++)
            {
                result.BoneMotions[i] = new MMDBoneMotion();
                result.BoneMotions[i].BoneName = input.Motions[i].BoneName;
                result.BoneMotions[i].FrameNo = input.Motions[i].FrameNo;

                result.BoneMotions[i].Curve = new BezierCurve[4];
                for (int j = 0; j < 3; j++)
                {
                    BezierCurve curve = new BezierCurve();
                    curve.v1 = new Vector2((float)input.Motions[i].Interpolation[0][0][j] / 128f, (float)input.Motions[i].Interpolation[0][1][j] / 128f);
                    curve.v2 = new Vector2((float)input.Motions[i].Interpolation[0][2][j] / 128f, (float)input.Motions[i].Interpolation[0][3][j] / 128f);
                    result.BoneMotions[i].Curve[j] = curve;
                }

                //for (int j1 = 0; j1 < input.Motions[i].Interpolation.Length; j1++)
                //    for (int j2 = 0; j2 < input.Motions[i].Interpolation[j1].Length; j2++)
                //        for (int j3 = 0; j3 < input.Motions[i].Interpolation[j1][j2].Length; j3++)
                //            result.BoneMotions[i].Interpolation[j1][j2][j3] = input.Motions[i].Interpolation[j1][j2][j3];
                result.BoneMotions[i].Location = new Vector3(input.Motions[i].Location[0], input.Motions[i].Location[1], input.Motions[i].Location[2]);
                result.BoneMotions[i].Quatanion = new Quaternion(input.Motions[i].Quatanion[0], input.Motions[i].Quatanion[1], input.Motions[i].Quatanion[2], input.Motions[i].Quatanion[3]);
            }
            //\[V̕ϊ
            result.FaceMotions = new MMDFaceMotion[input.FaceMotions.LongLength];
            if (result.FaceMotions.LongLength > int.MaxValue)
                throw new InvalidContentException("\[V܂BMikuMikuDanceXNA32bittől܂ł[VT|[gĂ܂");
            for (long i = 0; i < input.FaceMotions.Length; i++)
            {
                result.FaceMotions[i] = new MMDFaceMotion();
                result.FaceMotions[i].Rate = input.FaceMotions[i].Rate;
                result.FaceMotions[i].FaceName = input.FaceMotions[i].FaceName;
                result.FaceMotions[i].FrameNo = input.FaceMotions[i].FrameNo;
                float temp = input.FaceMotions[i].FrameNo;
            }
            //CgAJ[V͌Ŏ

            //XNApɕϊf[^ԋp
            return result;
        }
    }
}