﻿using System.Collections.Generic;
using Microsoft.Xna.Framework;

namespace MikuMikuDance.XNA.Model
{
    /// <summary>
    /// フェイスマネージャクラス
    /// </summary>
    public class MMDFaceManager
    {
        MMDModel model;
        Vector4[] FaceTranslations;//頂点番号ごとの移動量
        Dictionary<string, float> FaceRates;//適応中の表情リスト
        Dictionary<string, int> FaceDictionary;//表情辞書
        int baseIndex;
        //中からのみ
        internal MMDFaceManager(MMDModel mmdmodel)
        {
            model = mmdmodel;
            FaceTranslations = new Vector4[model.ModelData.NumVertexForFace];
            for (int i = 0; i < FaceTranslations.Length; i++)
            {
                FaceTranslations[i] = new Vector4(0, 0, 0, 0);
            }
            FaceRates = new Dictionary<string, float>();
            //表情辞書を作っておく
            FaceDictionary = new Dictionary<string, int>();
            baseIndex = 0;
            for (int i = 0; i < model.ModelData.Skins.Count; i++)
            {
                if (model.ModelData.Skins[i].SkinType == 0)
                    baseIndex = i;
                else
                    FaceDictionary.Add(model.ModelData.Skins[i].Name, i);
            }
            
        }
        /// <summary>
        /// 表情のリセット
        /// </summary>
        public void ResetFace()
        {
            FaceRates.Clear();
            ResetTranslations();
        }
        private void ResetTranslations()
        {
            for (int i = 0; i < FaceTranslations.Length; i++)
            {
                FaceTranslations[i].X = 0;
                FaceTranslations[i].Y = 0;
                FaceTranslations[i].Z = 0;
                FaceTranslations[i].W = 0;
            }
        }
        /// <summary>
        /// 表情のセット
        /// </summary>
        /// <param name="facename">表情名</param>
        /// <param name="rate">表情適用率(0-1)</param>
        /// <remarks>ベース表情に戻したい際にはResetFaceを呼び出すこと</remarks>
        public void SetFace(string facename, float rate)
        {
            if (facename == "base")
                return;//baseは何もしない……
            //表情情報リストに登録しておく
            if (FaceRates.ContainsKey(facename))
                FaceRates[facename] = rate;
            else
                FaceRates.Add(facename, rate);
        }

        internal Vector4[] GetFaceTranslation()
        {
            ResetTranslations();//まずは表情をリセットしておく
            //次に表情名に合わせて頂点とその移動量を合算する
            foreach (var face in FaceRates)
            {//各表情ごとに頂点移動量の合成処理
                if (!FaceDictionary.ContainsKey(face.Key))
                    continue;//対象表情が無いのでパス
                float temp;
                if (face.Key == "あ")
                    temp=face.Value;
                foreach (var vert in model.ModelData.Skins[FaceDictionary[face.Key]].SkinVerts)
                {
                    FaceTranslations[vert.VertIndex] += (new Vector4(vert.Pos[0], vert.Pos[1], vert.Pos[2], 0) * face.Value);
                }
            }
            return FaceTranslations;
        }
    }
}
