﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework.Content.Pipeline.Graphics;
using Microsoft.Xna.Framework.Content;
using System.IO;
using Microsoft.Xna.Framework.Content.Pipeline;

namespace MikuMikuDance.XNA.Model
{
    /// <summary>
    /// ToonTexture管理クラス
    /// </summary>
    [ContentSerializerRuntimeType("MikuMikuDance.XNA.Model.ModelData.ToonTextures, MikuMikuDanceXNA")]
    public class ToonTexturesContent
    {
        /// <summary>
        /// トゥーンテクスチャ
        /// </summary>
        public Texture2DContent[] Toons;

        static Texture2DContent[] s_Toons = null;

        static bool IsInitialized { get { return s_Toons != null; } }
        /// <summary>
        /// トゥーンテクスチャの読み込み
        /// </summary>
        /// <param name="context">ContentProcessorContext</param>
        public void Initialize(ContentProcessorContext context)
        {
            if (!IsInitialized)
            {//staticにして、多重読み込みを回避
                //トゥーンテクスチャの読み込み処理
                s_Toons = new Texture2DContent[10];
                //リソースからファイルを作成して読み込むという超セコイ方法……
                if (!Directory.Exists("ext"))
                    Directory.CreateDirectory("ext");
                //toonを1～10まで保存
                Resource1.toon01.Save(Path.Combine("ext", "toon01.bmp"));
                Resource1.toon02.Save(Path.Combine("ext", "toon02.bmp"));
                Resource1.toon03.Save(Path.Combine("ext", "toon03.bmp"));
                Resource1.toon04.Save(Path.Combine("ext", "toon04.bmp"));
                Resource1.toon05.Save(Path.Combine("ext", "toon05.bmp"));
                Resource1.toon06.Save(Path.Combine("ext", "toon06.bmp"));
                Resource1.toon07.Save(Path.Combine("ext", "toon07.bmp"));
                Resource1.toon08.Save(Path.Combine("ext", "toon08.bmp"));
                Resource1.toon09.Save(Path.Combine("ext", "toon09.bmp"));
                Resource1.toon10.Save(Path.Combine("ext", "toon10.bmp"));
                //toonの読み込み
                for (int i = 1; i <= 10; i++)
                {
                    string toonFileName = Path.Combine("ext", "toon");
                    if (i == 10)
                        toonFileName += "10.bmp";
                    else
                        toonFileName += "0" + i.ToString().Trim() + ".bmp";
                    s_Toons[i - 1]
                        = (Texture2DContent)context.BuildAndLoadAsset<TextureContent, TextureContent>(
                        new ExternalReference<TextureContent>(toonFileName), "TextureProcessor");
                }
            }
            Toons = s_Toons;

        }

    }
}
