﻿//-----------------------------------------------------------------------------
// MMDModel.fx
//
// MikuMikuDance for XNA
// Copyright (C) Wilfrem and Microsoft.
//
// このソースコードはひにけにXNAの「頂点テクスチャでスキンアニメーション」の
// SkinnedModel.fxのソースと
// http://blogs.msdn.com/ito/archive/2009/05/07/more-bones-07.aspx
// XNAクリエイターズオンラインにあったBasicEffect.fxを混ぜた上で
// エフェクトMMDに合わせて変更したもの
// 他、表情、トゥーンやらいろいろいじってる
// 
//-----------------------------------------------------------------------------

//既知の問題
//XBox用にfxファイルをコンパイルする際に、
//ピクセルシェーダの構造体内に未使用のデータがあると、コンパイルエラーを起こす
//http://forums.xna.com/forums/t/42630.aspx

//-----------------------------------------------------------------------------
// 定数レジスタ宣言
//=============================================================================

uniform const float3	EyePosition		: register(c0);		// in world space

//-----------------------------------------------------------------------------
// ライト設定用レジスタ。
// All directions and positions are in world space and must be unit vectors
//-----------------------------------------------------------------------------

uniform shared const float3	AmbientLightColor		: register(c1);

uniform shared const float3	DirLight0Direction		: register(c2);
uniform shared const float3	DirLight0DiffuseColor	: register(c3);

//-----------------------------------------------------------------------------
// マトリックス
//-----------------------------------------------------------------------------
// オブジェクトのワールド座標
uniform const float4x4	World		: register(vs, c4);	// 4 - 7
// ビューのトランスフォーム
uniform shared const float4x4	View		: register(vs, c8);	// 8 - 11
// プロジェクションのトランスフォーム
uniform shared const float4x4	Projection	: register(vs, c12);	// 12 - 15

//-----------------------------------------------------------------------------
// マテリアルパレット設定用レジスタ
//-----------------------------------------------------------------------------
//レジスタ120個使用。付属モデルはリンモデルの材質が27なので40とれば十分
#define MaxPalette 40
uniform const float4 DiffuseColorPalette[MaxPalette];//wはAlpha
uniform const float4 EmissiveColorPalette[MaxPalette];//wはToonIndex
uniform const float4 SpecularColorPalette[MaxPalette];//wはSpecularPower

//-----------------------------------------------------------------------------
// トゥーン処理
//-----------------------------------------------------------------------------
// トゥーン(アホっぽいけど、これしか手がないみたいで……)
uniform const bool UseToon					: register(b0);
uniform shared const texture ToonTexture1;
uniform shared const texture ToonTexture2;
uniform shared const texture ToonTexture3;
uniform shared const texture ToonTexture4;
uniform shared const texture ToonTexture5;
uniform shared const texture ToonTexture6;
uniform shared const texture ToonTexture7;
uniform shared const texture ToonTexture8;
uniform shared const texture ToonTexture9;
uniform shared const texture ToonTexture10;
//テクスチャのサンプラー
sampler ToonSampler1 = sampler_state
{
    Texture = (ToonTexture1);

    MinFilter = Linear;
    MagFilter = Linear;
    MipFilter = Linear;
};
sampler ToonSampler2 = sampler_state
{
    Texture = (ToonTexture2);

    MinFilter = Linear;
    MagFilter = Linear;
    MipFilter = Linear;
};
sampler ToonSampler3 = sampler_state
{
    Texture = (ToonTexture3);

    MinFilter = Linear;
    MagFilter = Linear;
    MipFilter = Linear;
};
sampler ToonSampler4 = sampler_state
{
    Texture = (ToonTexture4);

    MinFilter = Linear;
    MagFilter = Linear;
    MipFilter = Linear;
};
sampler ToonSampler5 = sampler_state
{
    Texture = (ToonTexture5);

    MinFilter = Linear;
    MagFilter = Linear;
    MipFilter = Linear;
};
sampler ToonSampler6 = sampler_state
{
    Texture = (ToonTexture6);

    MinFilter = Linear;
    MagFilter = Linear;
    MipFilter = Linear;
};
sampler ToonSampler7 = sampler_state
{
    Texture = (ToonTexture7);

    MinFilter = Linear;
    MagFilter = Linear;
    MipFilter = Linear;
};
sampler ToonSampler8 = sampler_state
{
    Texture = (ToonTexture8);

    MinFilter = Linear;
    MagFilter = Linear;
    MipFilter = Linear;
};
sampler ToonSampler9 = sampler_state
{
    Texture = (ToonTexture9);

    MinFilter = Linear;
    MagFilter = Linear;
    MipFilter = Linear;
};
sampler ToonSampler10 = sampler_state
{
    Texture = (ToonTexture10);

    MinFilter = Linear;
    MagFilter = Linear;
    MipFilter = Linear;
};
//-----------------------------------------------------------------------------
// スフィア処理
//-----------------------------------------------------------------------------
// スフィアビットマップ
float  UseSphere;

//-----------------------------------------------------------------------------
// 構造体宣言
//-----------------------------------------------------------------------------

struct ColorPair
{
	float3 Diffuse;
	float3 Specular;
	float2 ToonTex;
};

//-----------------------------------------------------------------------------
// テスクチャ
//-----------------------------------------------------------------------------

texture Texture;		// テクスチャ

//テクスチャのサンプラー
sampler Sampler = sampler_state
{
    Texture = (Texture);

    MinFilter = Linear;
    MagFilter = Linear;
    MipFilter = Linear;
};

//-----------------------------------------------------------------------------
// 頂点テクスチャ用の定数レジスタ宣言
//=============================================================================
float2 BoneTextureSize;	// ボーン用頂点テクスチャのサイズ

// ボーン用頂点テクスチャサンプラー宣言
texture BoneRotationTexture;

sampler BoneRotationSampler : register(vs,s0) = sampler_state
{
	Texture = (BoneRotationTexture);
	// 殆どのGPUでは以下のようなステート設定にしないと
	// 頂点テクスチャのフェッチがうまくいかない
	MinFilter = Point;
	MagFilter = Point;
	MipFilter = None;
	AddressU = Clamp;
	AddressV = Clamp;
};

texture BoneTranslationTexture;

sampler BoneTranslationSampler : register(vs,s1) = sampler_state
{
	Texture = (BoneTranslationTexture);
	// 殆どのGPUでは以下のようなステート設定にしないと
	// 頂点テクスチャのフェッチがうまくいかない
	MinFilter = Point;
	MagFilter = Point;
	MipFilter = None;
	AddressU = Clamp;
	AddressV = Clamp;
};

//表情の適応割合をセットする頂点テクスチャ
//フォーマット：表情番号-割合がfloat配列で格納されている
//毎フレーム転送される
float2 FaceRateTextureSize;//フェイス割合用の頂点テクスチャのサイズ
texture FaceRateTexture;

sampler FaceRateSampler : register(vs,s2) = sampler_state
{
	Texture = (FaceRateTexture);
	// 殆どのGPUでは以下のようなステート設定にしないと
	// 頂点テクスチャのフェッチがうまくいかない
	MinFilter = Point;
	MagFilter = Point;
	MipFilter = None;
	AddressU = Clamp;
	AddressV = Clamp;
};

bool UseGPUAnime;//GPU表情アニメーションフラグ

//表情のbase頂点番号から移動量が格納されているテクスチャ(CPUアニメーション時)
//表情のbase頂点番号から移動量を計算するまでに必要なデータが格納されているテクスチャ(GPUアニメーション時)
//フォーマット：
//頂点表情セクタのヘッダ(Vector4に割り当て)
//struct VertToFace{
//	float start;//base頂点→表情番号が書かれたフィールドの開始点(Vector4個数単位)
//	float count;//base頂点→表情番号が書かれたフィールドの個数(表情数ではなくVector4の個数)
//  float vstart;//base頂点→表情ごとの移動量が書かれたフィールドの開始点
//  float vcount;//base頂点→表情ごとの移動量が書かれたフィールドの個数(count*4-αと同じになるはずだが)
//};
//頂点→表情番号フィールド(float:Vector4に4個づつ割り当て)
//base頂点→表情ごとの移動量(Vector4。wは0)。indexは頂点→表情番号フィールドと一致

float2 FaceVertTextureSize;//フェイス頂点データ用の頂点テクスチャのサイズ
float2 FaceVertTextureColLines;//フェイス頂点データ用の頂点テクスチャの行数
texture FaceVertTexture;

sampler FaceVertSampler : register(vs,s3) = sampler_state
{
	Texture = (FaceVertTexture);
	// 殆どのGPUでは以下のようなステート設定にしないと
	// 頂点テクスチャのフェッチがうまくいかない
	MinFilter = Point;
	MagFilter = Point;
	MipFilter = None;
	AddressU = Clamp;
	AddressV = Clamp;
};
//-----------------------------------------------------------------------------
// 構造体宣言
//=============================================================================
// 頂点シェーダー入力構造体
struct VS_INPUT_Tx
{
    float4 Position : POSITION0;
    float3 Normal	: NORMAL0;
    float2 TexCoord : TEXCOORD0;
    float4 BoneIndices : BLENDINDICES0;//ボーン
    float4 BoneWeights : BLENDWEIGHT0;//ボーン
    float2 VectorIndex : TEXCOORD1;//(頂点番号,パレット番号)
};

// 頂点シェーダー出力構造体
struct VertexLightingVSOutputTx
{
	float4	Position	: POSITION;		// Position in projection space
	float4	Diffuse		: COLOR0;
	float4	Specular	: COLOR1;
	float2	TexCoord	: TEXCOORD0;
	float3	ToonTexCoord: TEXCOORD1;
};

//-----------------------------------------------------------------------------
// クォータニオンヘルパーメソッド
//=============================================================================
// 2つクォータニオンと平行移動から行列に変換する
// ひにけにさんのサンプルをMMD用に調整したもの
float4x4 CreateTransformFromQuaternionTransforms(
		float4 q1, float3 t1,
		float4 q2, float3 t2,
		float4 weights )
{
	float ww = q1.w * q1.w - 0.5f;
	float3 row10 = float3( ww         , q1.x * q1.y, q1.x * q1.z ) +
				   float3( q1.x * q1.x, q1.w * q1.z,-q1.w * q1.y );
	float3 row11 = float3( q1.x * q1.y, ww,          q1.y * q1.z ) +
	               float3(-q1.w * q1.z, q1.y * q1.y, q1.w * q1.x );
	float3 row12 = float3( q1.x * q1.z, q1.y * q1.z, ww          ) +
	               float3( q1.w * q1.y,-q1.w * q1.x, q1.z * q1.z );
	
	ww = q2.w * q2.w - 0.5f;
	float3 row20 = float3( ww,          q2.x * q2.y, q2.x * q2.z ) +
	               float3( q2.x * q2.x, q2.w * q2.z,-q2.w * q2.y );
	float3 row21 = float3( q2.x * q2.y, ww,          q2.y * q2.z ) +
	               float3(-q2.w * q2.z, q2.y * q2.y, q2.w * q2.x );
	float3 row22 = float3( q2.x * q2.z, q2.y * q2.z, ww          ) +
	               float3( q2.w * q2.y,-q2.w * q2.x, q2.z * q2.z );
	              
	float4 w2 = 2.0f * weights;
	
	return float4x4(
		row10 * w2.x + row20 * w2.y/* + row30 * w2.z + row40 * w2.w*/, 0,
		row11 * w2.x + row21 * w2.y/* + row31 * w2.z + row41 * w2.w*/, 0,
		row12 * w2.x + row22 * w2.y/* + row32 * w2.z + row42 * w2.w*/, 0, 
		t1 * weights.x + t2 * weights.y/* + t3 * weights.z + t4 * weights.w*/, 1
	);
	
}

//-----------------------------------------------------------------------------
// 頂点テクスチャからボーン情報のフェッチ(MMDの影響ボーンは2つまで)
//=============================================================================
float4x4 CreateTransformFromBoneTexture( float4 boneIndices, float4 boneWeights )
{
	float2 uv = 1.0f / BoneTextureSize;
	uv.y *= 0.5f;
	float4 texCoord0 = float4( ( 0.5f + boneIndices.x ) * uv.x, uv.y, 0, 1 );
	float4 texCoord1 = float4( ( 0.5f + boneIndices.y ) * uv.x, uv.y, 0, 1 );
	
	// 回転部分のフェッチ
	float4 q1 = tex2Dlod( BoneRotationSampler, texCoord0 );
	float4 q2 = tex2Dlod( BoneRotationSampler, texCoord1 );
	
	// 平行移動部分のフェッチ
	float4 t1 = tex2Dlod( BoneTranslationSampler, texCoord0 );
	float4 t2 = tex2Dlod( BoneTranslationSampler, texCoord1 );
	
	return CreateTransformFromQuaternionTransforms(
					q1, t1,
					q2, t2,
					boneWeights );
}

//-----------------------------------------------------------------------------
// 頂点テクスチャから表情情報のフェッチ及び計算
//=============================================================================
float4 GetFVTexCoord(float pos,float2 uv)
{
	return float4(fmod(pos+0.5f,FaceVertTextureColLines.x)* uv.x,(0.5f+floor(pos*FaceVertTextureColLines.y))* uv.y, 0, 1 );
}
float4 InnerCalcFace(int faceNum,float vertPos,float2 uv,float2 uv2)
{
	float4 result=0;
	if(faceNum>=0)
	{//余り部分には-1が入っている
		//faceNumに表情番号が入っている
		//ここから表情量を取得
		float4 texCoord2=float4((0.5f+faceNum) * uv2.x, uv2.y, 0, 1 );
		float4 faceRate=tex2Dlod(FaceRateSampler,texCoord2);
		if(faceRate.x>0)
		{
			//次に対応する頂点の移動量をフェッチ
			//vertPosの位置に来るようになっている
			float4 texCoord3=GetFVTexCoord(vertPos,uv);
			float4 faceMove=tex2Dlod( FaceVertSampler, texCoord3 );
			//表情の適応量を掛け合わせて加える
			result+=faceMove*faceRate.x;
		}
	}
	
	return result;
}
float4 CalcFace( float2 VectorIndex)
{
	//FaceVertTextureのVector4 1データの目盛取得(複数行形式)
	float2 uv = 1.0f / FaceVertTextureSize;
	//頂点番号から(表情が書かれたエリア/表情頂点位置)の取得
	//Vector4ごとにに2つ含まれている(GPU)
	float4 texCoord0=GetFVTexCoord(VectorIndex.x,uv);
	// 関連表情データエリア部分/頂点位置のフェッチ
	float4 fa = tex2Dlod( FaceVertSampler, texCoord0 );
	float4 result=float4(0,0,0,0);
	if(UseGPUAnime==true)
	{//GPU処理時はシェーダ内で計算する
		//FaceRateTextureのfloat 1データの目盛取得
		float2 uv2=1.0f/FaceRateTextureSize;
		uv2.y*=0.5f;
		
		//表情ごとに処理
		for(int i=0;i<fa.y;i++)
		{
			float4 texCoord1=GetFVTexCoord(i+fa.x,uv);
			//表情番号データエリア部分のフェッチ
			float4 faces=tex2Dlod( FaceVertSampler, texCoord1 );
			result+=InnerCalcFace(faces.x,fa.z+i*4.0f,uv,uv2);
			result+=InnerCalcFace(faces.y,fa.z+i*4.0f+1,uv,uv2);
			result+=InnerCalcFace(faces.z,fa.z+i*4.0f+2,uv,uv2);
			result+=InnerCalcFace(faces.w,fa.z+i*4.0f+3,uv,uv2);
			
		}
	}
	else
	{//CPU処理時は処理済みデータが格納されている
		result=fa;
	}
	return result;
}



//-----------------------------------------------------------------------------
// Compute lighting
// E: Eye-Vector
// N: Unit vector normal in world space
//-----------------------------------------------------------------------------
ColorPair ComputeLights(float3 E, float3 N,VS_INPUT_Tx input)
{
	ColorPair result;
	
	result.Diffuse = AmbientLightColor;
	result.Specular = 0;
	
	// Directional Light 0
	float3 L = -DirLight0Direction;
	float3 H = normalize(E + L);
	float2 ret = lit(dot(N, L), dot(N, H), SpecularColorPalette[input.VectorIndex.y].w).yz;//VectorIndex.y=パレット番号
	result.Diffuse += DirLight0DiffuseColor * ret.x;
	
	result.Diffuse *= float4(DiffuseColorPalette[input.VectorIndex.y].xyz,0);
	result.Diffuse	+= float4(EmissiveColorPalette[input.VectorIndex.y].xyz,0);
	result.Specular	*= float4(SpecularColorPalette[input.VectorIndex.y].xyz,0);
	
	//トゥーンテクスチャ用のサンプル位置を計算
	result.ToonTex.x=clamp(0.5f-dot(normalize(N),normalize(E))*0.5f,0,1);
	result.ToonTex.y=clamp(0.5f-dot(normalize(N),normalize(L))*0.5f,0,1);
	
	return result;
}

//-----------------------------------------------------------------------------
// 頂点シェーダー
//=============================================================================
VertexLightingVSOutputTx VSBasicNmTxVc(VS_INPUT_Tx input)
{
    VertexLightingVSOutputTx output;
    
    // スキン変換行列の取得
    float4x4 skinTransform =
				CreateTransformFromBoneTexture( input.BoneIndices, input.BoneWeights );
	//スキン変換
	skinTransform = mul( skinTransform, World );
	
	//表情移動分の取得
	float4 faceTransform=float4(0,0,0,0);
	if(input.VectorIndex.x>=0)
		faceTransform=CalcFace(input.VectorIndex);
	
	//表情による頂点移動を合算
	float4 facePos=input.Position+faceTransform;
	
    // 頂点変換
    float4 position = mul(facePos, skinTransform);
    output.Position = mul(mul(position, View), Projection);
	
    // 法線変換
    float3 normal = normalize( mul( input.Normal, skinTransform));
    //視線ベクトル取得
    float3 posToEye = EyePosition - position;
    float3 E = normalize(posToEye);
    //視線ベクトルと法線を元にライトを計算
    ColorPair lightResult = ComputeLights(E, normal,input);
    
    //ディフューズ色計算
    output.Diffuse = float4(lightResult.Diffuse.rgb, DiffuseColorPalette[input.VectorIndex.y].w);//DColor.w=Alpha
    output.Specular = float4(lightResult.Specular,0);
    
	if(UseSphere>0)
		output.TexCoord=float2(normal.x/2+0.5,normal.y/2+0.5);
	else
		output.TexCoord=input.TexCoord;
	
	//トゥーンテクスチャ取得位置をコピー
	output.ToonTexCoord=float3(lightResult.ToonTex.x,lightResult.ToonTex.y,EmissiveColorPalette[input.VectorIndex.y].w);
	
	return output;
}
//-----------------------------------------------------------------------------
// ピクセルシェーダー
//=============================================================================
// ピクセルシェーダー入力構造体
struct VertexLightingPSInputTx
{
	float4	Diffuse		: COLOR0;
	float4	Specular	: COLOR1;
    float2	TexCoord : TEXCOORD0;
    float3	ToonTexCoord: TEXCOORD1;
    //float4	OtherColor	: COLOR2;
};

float4 PSBasicTx(VertexLightingPSInputTx pin) : COLOR
{
	
	float4 color;
	if(all(pin.TexCoord))
	{
		color=tex2D(Sampler, pin.TexCoord) * pin.Diffuse + float4(pin.Specular.rgb, 0);
	}
	else
	{
		color = pin.Diffuse + float4(pin.Specular.rgb, 0);
	}
	//トゥーンテクスチャの適応
	if(UseToon)
	{
		if(pin.ToonTexCoord.z==0)
			color*=tex2D(ToonSampler1,pin.ToonTexCoord.xy);
		else if(pin.ToonTexCoord.z==1)
			color*=tex2D(ToonSampler2,pin.ToonTexCoord.xy);
		else if(pin.ToonTexCoord.z==2)
			color*=tex2D(ToonSampler3,pin.ToonTexCoord.xy);
		else if(pin.ToonTexCoord.z==3)
			color*=tex2D(ToonSampler4,pin.ToonTexCoord.xy);
		else if(pin.ToonTexCoord.z==4)
			color*=tex2D(ToonSampler5,pin.ToonTexCoord.xy);
		else if(pin.ToonTexCoord.z==5)
			color*=tex2D(ToonSampler6,pin.ToonTexCoord.xy);
		else if(pin.ToonTexCoord.z==6)
			color*=tex2D(ToonSampler7,pin.ToonTexCoord.xy);
		else if(pin.ToonTexCoord.z==7)
			color*=tex2D(ToonSampler8,pin.ToonTexCoord.xy);
		else if(pin.ToonTexCoord.z==8)
			color*=tex2D(ToonSampler9,pin.ToonTexCoord.xy);
		else if(pin.ToonTexCoord.z==9)
			color*=tex2D(ToonSampler10,pin.ToonTexCoord.xy);
	}
	color.rgb=color.rgb;
	return color;
}

//-----------------------------------------------------------------------------
// 描画手法の宣言
//=============================================================================
//修正前
//int ShaderIndex = 0;

//VertexShader VSArray[1] =
//{
//	compile vs_3_0 VSBasicNmTxVc(),
//};

//PixelShader PSArray[1] =
//{
//	compile ps_3_0 PSBasicTx(),
//};


//Technique MMDBasicEffect
//{
//	Pass
//	{
//		VertexShader = (VSArray[ShaderIndex]);
//		PixelShader	 = (PSArray[ShaderIndex]);
//	}
//}

//修正後
//上のように書くと、エラーや警告が出たときにXBoxだとエフェクトコンパイラが落ちて謎エラーとなる。
//http://forums.xna.com/forums/t/42630.aspx

Technique MMDBasicEffect
{
	Pass
	{
		VertexShader = (compile vs_3_0 VSBasicNmTxVc());
		PixelShader	 = (compile ps_3_0 PSBasicTx());
	}
}