using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Content.Pipeline;
using Microsoft.Xna.Framework.Content.Pipeline.Graphics;
using Microsoft.Xna.Framework.Content.Pipeline.Processors;
using System.IO;
using System.Drawing;
using System.ComponentModel;

namespace MikuMikuDance.XNA.Accessory
{
    /// <summary>
    /// MikuMikuDanceANZTpvZbT
    /// </summary>
    /// <remarks>ʂ̃fvZbTgƂł邪ȀꍇAXtBA}bvƃXN[@\͎gȂ</remarks>
    [ContentProcessor(DisplayName = "MikuMikuDanceANZT : MikuMikuDance for XNA")]
    public class AccessoryProcessor : ModelProcessor
    {
        float m_Scale = MMDImporterGlobal.ScaleFactor;
        /// <summary>
        /// f̃XP[
        /// </summary>
        /// <remarks>MMD̊Ⴄ߁AgĒĂ</remarks>
        [DefaultValue(MMDImporterGlobal.ScaleFactor)]
        [DisplayName("XP[")]
        [Description("3ɉăf̃TCYψɕύX܂")]
        public override float Scale
        {
            get
            {
                return m_Scale;
            }
            set
            {
                m_Scale = value;
            }
        }

        /// <summary>
        /// ANZT̏
        /// </summary>
        /// <param name="input">ANZTf[^</param>
        /// <param name="context">vZbTReLXg</param>
        /// <returns>ς݃ANZTf[^</returns>
        public override ModelContent Process(NodeContent input, ContentProcessorContext context)
        {
            return base.Process(input, context);
        }
        /// <summary>
        /// eNX`̏
        /// </summary>
        /// <param name="material">}eA</param>
        /// <param name="context">vZbTReLXg</param>
        /// <returns>ς݃}eAf[^</returns>
        protected override MaterialContent ConvertMaterial(MaterialContent material, ContentProcessorContext context)
        {
            BasicMaterialContent basicMaterial = material as BasicMaterialContent;
            if (basicMaterial != null)
            {
                EffectMaterialContent effectMaterial = new EffectMaterialContent();
                //extfBNg쐬
                string IntDir = "ext";
                if (!Directory.Exists(IntDir))
                    Directory.CreateDirectory(IntDir);
                //GtFNg\[X쐬
                FileStream fs = new FileStream(Path.Combine(IntDir, "AccessoryEffect.fx"), FileMode.Create);
                BinaryWriter bw = new BinaryWriter(fs);
                bw.Write(Resource1.AccessoryEffect);
                bw.Close();
                effectMaterial.Effect = new ExternalReference<EffectContent>(Path.Combine(IntDir, "AccessoryEffect.fx"));
                //f[^̃Rs[
                string Spheremap = "";
                foreach (var i in basicMaterial.OpaqueData)
                {
                    if (i.Key == "SphereTexture")
                        Spheremap = (string)i.Value;
                    else
                        effectMaterial.OpaqueData.Add(i.Key, i.Value);
                }
                //XtBA}bv
                if (Spheremap != "")
                {
                    string spherePath = Path.GetFullPath(Spheremap);
                    if (!File.Exists(spherePath))
                        throw new InvalidContentException(
                            "Cannot find sphere file:" + spherePath);
                    //XtBA}bv̊gq
                    string intFilePath = Path.Combine(IntDir, Path.GetFileName(spherePath));
                    Image sphere = null;
                    try
                    {
                        sphere = new Bitmap(spherePath);
                    }
                    catch (OutOfMemoryException)
                    {
                        //œǂ߂Ȃ̂tga^
                        intFilePath += ".tga";
                        File.Copy(spherePath, intFilePath, true);//㏑ŃRs[
                    }
                    //^
                    if (sphere != null)
                    {
                        string Extention;
                        ImageExtAnalyzer.Analyze(sphere, out Extention);
                        intFilePath += Extention;
                        File.Copy(spherePath, intFilePath, true);
                    }
                    //XtBA}bv̓\t
                    effectMaterial.Textures.Add("SphereTexture", new ExternalReference<TextureContent>(intFilePath));
                }
                effectMaterial.Name = basicMaterial.Name;
                effectMaterial.Identity = basicMaterial.Identity;
                foreach (var i in basicMaterial.Textures)
                {
                    effectMaterial.Textures.Add(i.Key, i.Value);
                }
                return base.ConvertMaterial(effectMaterial, context);
            }
            else
            {//EffectMaterialContentꍇẮH
                throw new InvalidContentException(string.Format(
                    "AccessoryProcessorBasicMaterialContent݂̂T|[g܂" +
                    "̓bV{0}gpĂ܂B", material.GetType()));
                
            }
            
        }
        /// <summary>
        /// eNX`WݒT{΍pɌp
        /// </summary>
        /// <param name="material">}eA</param>
        /// <param name="geometryCollection">WIgRNV</param>
        /// <param name="context">ReLXg</param>
        protected override void ProcessGeometryUsingMaterial(MaterialContent material, IEnumerable<GeometryContent> geometryCollection, ContentProcessorContext context)
        {
            //ǂ̃GtFNgĝ̎ʔ
            foreach (var i in geometryCollection)
            {
                bool Color = false;
                bool UseTexture = false;
                bool Normal = false;
                int Special = 0;
                foreach (var channel in i.Vertices.Channels)
                {
                    if (channel.Name == VertexChannelNames.TextureCoordinate(0)
                        && i.Material.Textures.Count > 0)
                    {
                        UseTexture = true;
                        foreach (var j in i.Material.Textures)
                        {
                            if (Path.GetFileName(j.Value.Filename) == "screen.bmp" &&
                                !File.Exists(j.Value.Filename))
                            {
                                if (Special == 0)
                                    Special = 1;
                                else
                                    throw new InvalidContentException("eNX`1}eA2ވȏ\t邱Ƃ͂ł܂");
                            }
                        }
                    }
                    else if (channel.Name == VertexChannelNames.Color(0))
                        Color = true;
                    else if (channel.Name == VertexChannelNames.Normal(0))
                    {
                        Normal = true;
                        foreach (var j in i.Material.Textures)
                        {
                            if (Path.GetExtension(j.Value.Filename) == ".sph")
                            {
                                if (Special == 0)
                                    Special = 2;
                                else
                                    throw new InvalidContentException("eNX`1}eA2ވȏ\t邱Ƃ͂ł܂");
                            }
                            else if (Path.GetExtension(j.Value.Filename) == ".spa")
                            {
                                if (Special == 0)
                                    Special = 3;
                                else
                                    throw new InvalidContentException("eNX`1}eA2ވȏ\t邱Ƃ͂ł܂");
                            }
                        }
                    }
                }
                int ShaderIndex=0;
                switch (Special)
                {
                    case 0:
                        {//ʏ핔
                            if (Normal)
                                ShaderIndex += 4;
                            if (Color)
                                ++ShaderIndex;
                            if (UseTexture)
                                ShaderIndex += 2;
                        }
                        break;
                    case 1:
                        {//XN[
                            //XN[̓eNX`Ă
                            if(i.Material.Textures.Count>1)
                                throw new InvalidContentException(string.Format(
                                        "AccessoryProcessor̓XtBA}bvw肳Ă}eAɂčveNX`[2܂ŁA" +
                                        "ȊÕ}eAɂăeNX`v2܂ŃT|[g܂" +
                                        "̓bV̓eNX`[{0}gpĂ܂B", i.Material.Textures.Count));
                            i.Material.Textures.Clear();
                            ShaderIndex = 20;
                            if (Normal)
                                ShaderIndex += 2;
                            if (Color)
                                ++ShaderIndex;
                        }
                        break;
                    case 2:
                    case 3:
                        {//XtBA}bv
                            if (i.Material.Textures.Count > 2)
                                throw new InvalidContentException(string.Format(
                                        "AccessoryProcessor̓XtBA}bvw肳Ă}eAɂčveNX`[2܂ŁA" +
                                        "ȊÕ}eAɂăeNX`v2܂ŃT|[g܂" +
                                        "̓bV̓eNX`[{0}gpĂ܂B", i.Material.Textures.Count));
                            //XtBA}bvsf[^ɑޔ
                            string SphKey = "";
                            foreach (var j in i.Material.Textures)
                            {
                                if (Path.GetExtension(j.Value.Filename) == ".sph" ||
                                    Path.GetExtension(j.Value.Filename) == ".spa")
                                {
                                    i.Material.OpaqueData.Add("SphereTexture", j.Value.Filename);
                                    if (SphKey != "")
                                        throw new InvalidContentException("XtBA}bv1̃}eAɓȏw肷邱Ƃ͂ł܂");
                                    SphKey = j.Key;
                                }
                            }
                            //XtBA}bv폜
                            i.Material.Textures.Remove(SphKey);
                            //XtBA}bv̎ʂo^
                            i.Material.OpaqueData.Add("SphereType", Special - 1);
                            ShaderIndex = 12;
                            if (Color)
                                ++ShaderIndex;
                            if (UseTexture)
                                ShaderIndex += 2;

                        }
                        break;
                    default:
                        throw new NotImplementedException();
                }
                //XtBA}bv̏c̃`FbN
                foreach (var j in i.Material.Textures)
                {
                    if (Path.GetExtension(j.Value.Filename) == ".sph" ||
                        Path.GetExtension(j.Value.Filename) == ".spa")
                        throw new InvalidContentException("XtBA}bvł܂łBANZTɖ@\܂");
                }
                i.Material.OpaqueData.Add("ShaderIndex", ShaderIndex);
            }
            
            base.ProcessGeometryUsingMaterial(material, geometryCollection, context);
        }
        
    }
}