using System.Collections.Generic;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Content.Pipeline;
using Microsoft.Xna.Framework.Content.Pipeline.Graphics;
using Microsoft.Xna.Framework.Content.Pipeline.Processors;
using MikuMikuDance.XNA.Model.ModelData;
using System.ComponentModel;

using TInput = MikuMikuDance.XNA.Model.MMDModelIntermediate;
using TOutput = MikuMikuDance.XNA.Model.MMDModelContent;
using System;
using System.IO;

namespace MikuMikuDance.XNA.Model
{
    class VertSet
    {
        //_ԍ
        public uint VertNumber;
        //_ړ
        public Vector4 vert;
        //\ԍ
        public int FaceNumber;
    }
    /// <summary>
    /// MikuMikuDancẽff[^XNAɃC|[g邽߂̃vZbT
    /// </summary>
    [ContentProcessor(DisplayName = "MikuMikuDancef : MikuMikuDance for XNA")]
    public class MMDProcessor : ContentProcessor<TInput, TOutput>
    {

        bool useCustomEffect = false;
        /// <summary>
        /// JX^GtFNggptO
        /// </summary>
        [DefaultValue(false)]
        [DisplayName("JX^GtFNg̎gp")]
        [Description("MikuMikuDanceModelpGtFNgӊÕGtFNggƂtruew")]
        public bool UseCustomEffect { get { return useCustomEffect; } set { useCustomEffect = value; } }

        string customEffectName = "";
        /// <summary>
        /// JX^GtFNgt@C
        /// </summary>
        [DefaultValue("")]
        [DisplayName("JX^GtFNgt@C")]
        [Description("MikuMikuDanceModelpGtFNgӊÕGtFNggƂɃt@Cw")]
        public string CustomEffectName { get { return customEffectName; } set { customEffectName = value; } }

        bool generateMipmaps = true;
        /// <summary>
        /// ~bv}bv̐
        /// </summary>
        [DefaultValue(true)]
        [DisplayName("~bv}bv̐")]
        [Description("LȏꍇAf̃eNX`[ɑ΂ĊSȃ~bv}bv `F[܂B̃~bv}bv͒u܂B")]
        public virtual bool GenerateMipmaps { get { return generateMipmaps; } set { generateMipmaps = value; } }

        bool resizeTexturesToPowerOfTwo = true;
        /// <summary>
        /// eNX`TCY2̗ݏɃTCY
        /// </summary>
        [DefaultValue(true)]
        [DisplayName("eNX`[ TCY2̗ݏɃTCY")]
        [Description("LȏꍇAf̃eNX`[͎ɑ傫2̗ݏ̃TCYɕύXA\Ȍ̌݊ۂ܂B̃OtBbN J[h́ATCY2̗ݏłȂeNX`[ɑΉĂ܂B")]
        public virtual bool ResizeTexturesToPowerOfTwo { get { return resizeTexturesToPowerOfTwo; } set { resizeTexturesToPowerOfTwo = value; } }

        TextureProcessorOutputFormat textureFormat = TextureProcessorOutputFormat.DxtCompressed;
        /// <summary>
        /// eNX`[tH[}bg
        /// </summary>
        [DefaultValue(TextureProcessorOutputFormat.DxtCompressed)]
        [DisplayName("eNX`[ tH[}bg")]
        [Description("eNX`[ SurfaceFormat ^w肵܂BeNX`[̃tH[}bǵAϊAColor (32 rbg RGBA)A܂DXTk`ɕϊ܂B")]
        public virtual TextureProcessorOutputFormat TextureFormat { get { return textureFormat; } set { textureFormat = value; } }

        /// <summary>
        /// Recϊ
        /// </summary>
        /// <param name="input">MMDf for XNAԃNX</param>
        /// <param name="context">RegvZbT</param>
        /// <returns>MMDf for XNARec</returns>
        public override TOutput Process(TInput input, ContentProcessorContext context)
        {
            //ԋp
            TOutput result = new MMDModelContent();

            //ЂɂXNA̒_eNX`ŃXLAj[VQl
            //ЂɂXNA̎@ł̓{[255EȂ̂ŁA65535Ɋgł悤ɉǂKv

            //Ô߃XLAj[VɌ̂ǂ`FbN
            ValidateMesh(input.RootNode, context, null);
            //XPgT
            BoneContent skeleton = MeshHelper.FindSkeleton(input.RootNode);
            if (skeleton == null)
                throw new InvalidContentException("XPg܂");
            // f̃bVꂼႤ[JWĂƈ
            // ʓ|Ȃ̂ŁASĂႤ(bV̕ϊW炩ߒ_
            // f[^ɓKp邱)
            FlattenTransforms(input.RootNode, skeleton);

            // oChE|[YƃXPg\ǂݍ
            IList<BoneContent> bones = MeshHelper.FlattenSkeleton(skeleton);

            /*if (bones.Count > MaxBones)
            {
                throw new InvalidContentException(string.Format(
                    "̃XPgɂ{0}̃{[܂Bő{[{1}łB",
                    bones.Count, MaxBones));
            }*/

            MMDBoneData[] BoneDataProcessed = new MMDBoneData[bones.Count];
            Dictionary<string, int> NamePosDictionary = new Dictionary<string, int>();
            int Pos = 0;
            foreach (BoneContent bone in bones)
            {
                //XLAj[Vpf[^擾
                MMDBoneData mmdbone = new MMDBoneData();
                mmdbone.BindPose = QuatTransform.FromMatrix(bone.Transform);
                mmdbone.InverseBindPose = QuatTransform.FromMatrix(Matrix.Invert(bone.AbsoluteTransform));
                mmdbone.SkeletonHierarchy = bones.IndexOf(bone.Parent as BoneContent);//eo^(ꍇ-1)
                if (!NamePosDictionary.ContainsKey(bone.Name) && bone.Name != "")
                    NamePosDictionary.Add(bone.Name, Pos);
                BoneDataProcessed[Pos] = mmdbone;
                Pos++;
            }
            //̃{[𓝍
            foreach (var i in input.Bones)
            {
                //{[̐VȈʒu擾
                Pos = NamePosDictionary[i.Name];
                //XLAj[Vf[^Ɠ
                BoneDataProcessed[Pos].BoneType = i.BoneType;
                if (i.IKParentBoneIndex == 0)
                    BoneDataProcessed[Pos].IKParentBoneIndex = 0;
                else
                    BoneDataProcessed[Pos].IKParentBoneIndex = (ushort)NamePosDictionary[input.Bones[i.IKParentBoneIndex].Name];
                BoneDataProcessed[Pos].Name = i.Name;
                if (i.HasIK)
                {//IKf[^Ȃ炻Rs[
                    BoneDataProcessed[Pos].IK = new MMDIKData();
                    BoneDataProcessed[Pos].HasIK = true;
                    BoneDataProcessed[Pos].IK.ControlWeight = i.IK.ControlWeight;
                    BoneDataProcessed[Pos].IK.IKBoneIndex = (ushort)NamePosDictionary[input.Bones[i.IK.IKBoneIndex].Name];
                    BoneDataProcessed[Pos].IK.IKChildBones = new ushort[i.IK.IKChildBones.Length];
                    for (int j = 0; j < i.IK.IKChildBones.Length; j++)
                        BoneDataProcessed[Pos].IK.IKChildBones[j] = (ushort)NamePosDictionary[input.Bones[i.IK.IKChildBones[j]].Name];
                    
                    BoneDataProcessed[Pos].IK.IKTargetBoneIndex = (ushort)NamePosDictionary[input.Bones[i.IK.IKTargetBoneIndex].Name];
                    BoneDataProcessed[Pos].IK.Iteration = i.IK.Iteration;
                }
            }
            
            //x[X{[ݒ
            BoneDataProcessed[0].Name = "base";
            BoneDataProcessed[0].BoneType = MMDBoneType.RotateAndMove;
            BoneDataProcessed[0].IKParentBoneIndex = 0;
            //IKChildf[^MMDXŏ₷悤ɏC
            for (int i = 0; i < BoneDataProcessed.Length;i++ )
            {
                if (BoneDataProcessed[i].HasIK)
                {
                    List<ushort> childList = new List<ushort>();
                    ushort j = BoneDataProcessed[i].IK.IKTargetBoneIndex;
                    while (true)
                    {
                        childList.Add(j);
                        //e{[擾
                        if (BoneDataProcessed[j].SkeletonHierarchy == -1)
                            break;//HeH
                        j = (ushort)BoneDataProcessed[j].SkeletonHierarchy;//boneindexWORD
                        //IKeȂ{[܂ŒT(Œ_߂悤iKȂ{[Ă)
                        bool flag = false;
                        foreach (var k in BoneDataProcessed[i].IK.IKChildBones)
                        {
                            if (k == j)
                            {
                                flag = true;
                                break;
                            }
                        }
                        if (!flag)
                            break;
                    }
                    BoneDataProcessed[i].IK.IKChildBones = childList.ToArray();
                }
            }
            // MMDModelDataɃvZXς݂̃{[i[
            result.Bones = BoneDataProcessed;
            
            //MMDɂ̓Aj[V͖̂ŁA͔΂
            //// Aj[Vf[^^CptH[}bgɕϊ
            //Dictionary<string, AnimationClip> animationClips;
            //animationClips = ProcessAnimations(skeleton.Animations, bones);

            //fvZbT[ɂ
            SkinnedModelProcessor skinnedProcessor = new SkinnedModelProcessor();
            //p[^ݒ
            if (UseCustomEffect && CustomEffectName != null)
                skinnedProcessor.EffectFile = CustomEffectName;
            else
                skinnedProcessor.EffectFile =  "";
            skinnedProcessor.GenerateMipmaps = GenerateMipmaps;
            skinnedProcessor.ResizeTexturesToPowerOfTwo = ResizeTexturesToPowerOfTwo;
            skinnedProcessor.TextureFormat = TextureFormat;
            skinnedProcessor.ColorKeyEnabled = false;
            //vZX
            result.ModelData = skinnedProcessor.Process(input.RootNode, context);
            OpaqueDataDictionary pParams = new OpaqueDataDictionary();
            pParams.Add("EffectFile", "");
            pParams.Add("Scale", 2);
            //result.ModelData = context.Convert<NodeContent, ModelContent>(input.RootNode, "SkinnedModelProcessor", pParams);
            
            //_eNX`pɒ_𐮗
            //tH[}bgF
            //_\ZN^̃wb_(Vector4Ɋ蓖)
            //struct VertToFace{
            //	float start;//base_\ԍꂽtB[h̊Jn_(Vector4P)
            //	float count;//base_\ԍꂽtB[ȟ(\ł͂ȂVector4̌)
            //  float vstart;//base_\Ƃ̈ړʂꂽtB[h̊Jn_
            //  float vcount;//base_\Ƃ̈ړʂꂽtB[ȟ(count*4-ƓɂȂ͂)
            //};
            //_\ԍtB[h(float:Vector44Â蓖)
            //base_\Ƃ̈ړ(Vector4Bw0)Bindex͒_\ԍtB[hƈv
            //܂̓XgAbv

            SortedDictionary<uint, List<VertSet>> vertdataTemp = new SortedDictionary<uint, List<VertSet>>();
            int fNumber = 0;
            for (int i = 0; i < input.Skins.Length; i++)
            {
                if (input.Skins[i].SkinType == 0)
                    continue;//base͖
                for (int j = 0; j < input.Skins[i].SkinVerts.Length; j++)
                {
                    VertSet vset = new VertSet();
                    vset.FaceNumber = fNumber;
                    vset.VertNumber = input.Skins[i].SkinVerts[j].VertIndex;
                    vset.vert = new Vector4(MMDMath.VectorFromArray(input.Skins[i].SkinVerts[j].Pos), 0);
                    if (vertdataTemp.ContainsKey(vset.VertNumber))
                        vertdataTemp[vset.VertNumber].Add(vset);
                    else
                    {
                        vertdataTemp.Add(vset.VertNumber, new List<VertSet>());
                        vertdataTemp[vset.VertNumber].Add(vset);
                    }
                }
                ++fNumber;
            }
            //\ɎgȂbase_ԍǉ
            for (int i = 0; i < input.Skins.Length; i++)
            {
                if (input.Skins[i].SkinType == 0)
                {
                    for (int j = 0; j < input.Skins[i].SkinVerts.Length; j++)
                    {
                        VertSet vset = new VertSet();
                        vset.FaceNumber = -1;//֘A\
                        vset.VertNumber = (uint)j;//\_̒`base\indexȂ̂ŁAɑ
                        vset.vert = Vector4.Zero;
                        if (!vertdataTemp.ContainsKey(vset.VertNumber))
                        {
                            vertdataTemp.Add(vset.VertNumber, new List<VertSet>());
                            vertdataTemp[vset.VertNumber].Add(vset);
                        }
                    }
                    break;
                }
            }
            //wb_ƒ_\ԍtB[h̍\
            Vector4[] vertHeader = new Vector4[vertdataTemp.Count];
            List<Vector4> VertData = new List<Vector4>();
            int count = 0;
            int VecPos = vertdataTemp.Count;
            foreach (var i in vertdataTemp)
            {
                vertHeader[count].X = VecPos;
                int size = 0;
                for (int j = 0; j < i.Value.Count; j += 4)
                {
                    //float[]ŃANZXX,Y,Z,W̏cc
                    VertData.Add(new Vector4(i.Value[j].FaceNumber,
                        (i.Value.Count > j + 1) ? i.Value[j + 1].FaceNumber : -1,
                        (i.Value.Count > j + 2) ? i.Value[j + 2].FaceNumber : -1,
                        (i.Value.Count > j + 3) ? i.Value[j + 3].FaceNumber : -1
                        ));
                    ++size;
                }
                vertHeader[count].Y = size;
                VecPos += size;
                ++count;
            }
            //base_\Ƃ̈ړʃtB[h̍\
            count = 0;
            foreach (var i in vertdataTemp)
            {
                vertHeader[count].Z = VecPos;
                vertHeader[count].W = i.Value.Count;
                for (int j = 0; j < i.Value.Count; j++)
                    VertData.Add(i.Value[j].vert);
                VecPos += i.Value.Count;
                ++count;
            }
            //wb_Ƃ킹ăf[^̊
            VertData.InsertRange(0, vertHeader);
            //_eNX`œK\ȃeNX`̃TCYƌߕ̎擾
            int dataspace, TexX, TexY;
            Factorization(VertData.Count, out dataspace, out TexX, out TexY);
            for (int i = 0; i < dataspace; i++)
                VertData.Add(Vector4.Zero);//
            VecPos += dataspace;
            //f[^i[
            result.FaceData = VertData.ToArray();
            result.FaceDataTextureSizeX = TexX;
            result.FaceDataTextureSizeY = TexY;
            //`FbNR[h
#if DEBUG
            if (VecPos != result.FaceData.Length)
                throw new System.ApplicationException((result.FaceData.Length - VecPos).ToString());
            if (result.FaceDataTextureSizeX * result.FaceDataTextureSizeY != result.FaceData.Length)
                throw new System.ApplicationException((result.FaceData.Length - result.FaceDataTextureSizeX * result.FaceDataTextureSizeY).ToString());
            for (int i = 0; i < input.NumVertexForFace; i++)
            {
                int s1, c1, s2, c2;
                s1 = (int)result.FaceData[i].X;
                c1 = (int)result.FaceData[i].Y;
                s2 = (int)result.FaceData[i].Z;
                c2 = (int)result.FaceData[i].W;
                if (s1 < input.NumVertexForFace || s2 < input.NumVertexForFace || c1 < 0 || c2 < 0)
                    throw new System.ApplicationException((input.NumVertexForFace - s1).ToString() + "," + (input.NumVertexForFace - s2).ToString() + "," + c1.ToString() + "," + c2.ToString());
                /*if (i == 600)
                    throw new System.Exception();*/
                //\ԍ`FbN
                int valCount = 0;
                for (int j = s1; j < s1 + c1; j++)
                {
                    int[] faces = new int[4] {  (int)result.FaceData[j].X, (int)result.FaceData[j].Y, (int)result.FaceData[j].Z,(int)result.FaceData[j].W };
                    for (int k = 0; k < 4; k++)
                    {
                        if (faces[k] == -1)
                            continue;
                        try
                        {
                            string temp = input.Skins[faces[k]].Name;//IndexOutł邩ccH
                        }
                        catch (System.ArgumentOutOfRangeException)
                        {
                            throw new System.ApplicationException(faces[k].ToString() + ">=" + input.Skins.Length.ToString());
                        }
                        valCount++;
                    }
                }
                for (int j = s2; j < s2 + valCount; j++)
                {
                    Vector4 temp = result.FaceData[j];
                }
            }
#endif
            //CPU\Aj[Vp̏m
            Factorization(input.NumVertexForFace, out dataspace, out TexX, out TexY);
            result.FaceVertTextureSizeX = input.NumVertexForFace;//TexX;
            result.FaceVertTextureSizeY = 1;//TexY;

            //̃fRs[
            //result.IKs = input.IKs;
            result.Skins = input.Skins;
            result.NumVertexForFace = input.NumVertexForFace;
            result.Rigids = input.Rigids;
            result.Joints = input.Joints;
            //̂̏C
            for (int i = 0; i < result.Rigids.Length; i++)
            {
                if (result.Rigids[i].RelatedBoneIndex != 0xffff)
                    result.Rigids[i].RelatedBoneIndex = (ushort)NamePosDictionary[input.Bones[result.Rigids[i].RelatedBoneIndex].Name];
            }
            
            //ԋp
            return result;
        }

        private void Factorization(int Number, out int dataspace, out int x, out int y)
        {
            if (Number == 0)
            {
                dataspace = 0;
                x = 0;
                y = 0;
                return;
            }
            int i = (int)Math.Floor(Math.Sqrt((double)Number));
            int end = (int)Math.Max(Math.Floor(Math.Sqrt((double)Number) / 1.5), Math.Ceiling((float)Number / 1024.0f));
            dataspace = int.MaxValue;
            x = i;
            for (; i >= end; i--)
            {
                y = (int)Math.Ceiling((double)Number / (double)i);
                if (y * i - Number < dataspace)
                {
                    dataspace = y * i - Number;
                    x = i;
                }
                if (dataspace == 0)
                    break;
            }
            if (dataspace == int.MaxValue)
            {
                if (Number > 1000 * 1000)
                    throw new InvalidContentException("\_f[^̉HɎs܂B\̒_܂");
                else
                    throw new ApplicationException("\_f[^̉HɎs܂");
            }
            y = (Number + dataspace) / x;
        }

        /// <summary>
        /// ̃bV̓XLAj[VɌ̂`FbN
        /// </summary>
        static void ValidateMesh(NodeContent node, ContentProcessorContext context,
                                 string parentBoneName)
        {
            MeshContent mesh = node as MeshContent;

            if (mesh != null)
            {
                // bV̐𒲂ׂ
                if (parentBoneName != null)
                {
                    context.Logger.LogWarning(null, null,
                        "{0}bV{1}{[̎qłB" +
                        "SkinnedModelProcessor̓bV{[̎qłP[X" +
                        "ΉĂ܂B",
                        mesh.Name, parentBoneName);
                }

                if (!MeshHasSkinning(mesh))
                {
                    context.Logger.LogWarning(null, null,
                        "{0}bV̓XLjO񂪂Ȃ̂ŕϊ܂",
                        mesh.Name);

                    mesh.Parent.Children.Remove(mesh);
                    return;
                }
            }
            else if (node is BoneContent)
            {
                // ̃m[h{[ȂA{[𒲍ł邱ƂoĂ
                parentBoneName = node.Name;
            }

            // ċAI(Ƀm[ĥŁA
            // qB̃Rs[𑖍)
            foreach (NodeContent child in new List<NodeContent>(node.Children))
                ValidateMesh(child, context, parentBoneName);
        }
        /// <summary>
        /// bVXLjOĂ邩ׂ
        /// </summary>
        static bool MeshHasSkinning(MeshContent mesh)
        {
            foreach (GeometryContent geometry in mesh.Geometry)
            {
                if (!geometry.Vertices.Channels.Contains(VertexChannelNames.Weights()))
                    return false;
            }

            return true;
        }
        /// <summary>
        /// SĂWԂɂȂ悤ɁAsKvȕϊs
        /// fEWIgɏĂt
        /// </summary>
        static void FlattenTransforms(NodeContent node, BoneContent skeleton)
        {
            foreach (NodeContent child in node.Children)
            {
                // XPg͏Ȃ
                if (child == skeleton)
                    continue;

                // [JϊsWIgɏĂ
                MeshHelper.TransformScene(child, child.Transform);

                // Ăt̂ŁA[JWϊs
                // Pʍs(Matrix.Identity)ɂȂ
                child.Transform = Matrix.Identity;

                // ċAĂяo
                FlattenTransforms(child, skeleton);
            }
        }
    }
}