﻿using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.Build.Framework;

namespace MikuMikuDance.XNA.Builder.Build
{
    /// <summary>
    /// エラーログクラス
    /// </summary>
    public class ErrorLogger : ILogger
    {
        /// <summary>
        /// エラー一覧
        /// </summary>
        public List<string> Errors { get; private set; }
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public ErrorLogger()
        {
            Errors = new List<string>();
        }
        #region ILogger メンバ
        /// <summary>
        /// 初期化
        /// </summary>
        /// <param name="eventSource">イベントソースオブジェクト</param>
        public void Initialize(IEventSource eventSource)
        {
            if (eventSource != null)
            {
                eventSource.ErrorRaised += new BuildErrorEventHandler(eventSource_ErrorRaised);
            }
        }

        void eventSource_ErrorRaised(object sender, BuildErrorEventArgs e)
        {
            Errors.Add(e.Message);
        }
        /// <summary>
        /// パラメータ
        /// </summary>
        public string Parameters { get; set; }
        /// <summary>
        /// 終了処理
        /// </summary>
        public void Shutdown() { }
        /// <summary>
        /// 詳細レベルの設定
        /// </summary>
        public LoggerVerbosity Verbosity
        {
            get
            {
                return verbosity;
            }
            set
            {
                verbosity = value;
            }
        }
        LoggerVerbosity verbosity = LoggerVerbosity.Normal;

        #endregion
    }
}
