﻿using Microsoft.Xna.Framework.Content.Pipeline.Graphics;
using Microsoft.Xna.Framework;
using WORD = System.UInt16;

namespace MikuMikuDance.XNA.Model
{
    /// <summary>
    /// MMDのボーンセットの中間生成物
    /// </summary>
    class MMDBoneSetIntermediate
    {
        //XNAボーンデータ
        public BoneContent Bone { get; set; }
        //親ボーン番号
        public WORD BoneParent { get; set; }
        //子ボーン番号
        public WORD BoneTail { get; set; }
        //ボーン種別(MMDModelLibraryより)
        public byte BoneType { get; set; }
        //影響IKボーン番号
        public WORD BoneIKParent { get; set; }
        
        public MMDBoneSetIntermediate(MikuMikuDance.Model.Ver1.ModelBone mmdbone)
        {
            //オブジェクトを生成
            Bone = new BoneContent();
            //ボーン名を取得
            Bone.Name = mmdbone.BoneName;
            //親と子ボーンを設定(あとで必要)
            BoneParent = mmdbone.ParentBoneIndex;
            BoneTail = mmdbone.TailPosBoneIndex;
            
            //メモ:基本的にbaseボーン(MMDの場合はセンター)の位置を移動マトリックスで
            //他のボーンを親ボーン座標からのマトリックスで表す
            //baseボーンの基準座標はモデルの基準座標で、位置は原点からの移動マトリックス
            //他のボーンは親ボーンの位置及び親ボーン座標からの移動、回転マトリックスで表される

            //ボーンの位置を移動マトリックス化
            //親ボーンはここではまだ分からないので、モデル基準座標を元にしたマトリックスを設定しておく
            Bone.Transform = Matrix.CreateTranslation(mmdbone.BoneHeadPos[0], mmdbone.BoneHeadPos[1], mmdbone.BoneHeadPos[2]);
            
            //MMDのプロパティ系で使いそうな物を確保
            BoneType = mmdbone.BoneType;
            BoneIKParent = mmdbone.IKParentBoneIndex;
        }
    }
}
