﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework;

namespace MikuMikuDance.XNA.Accessory
{
    /// <summary>
    /// スクリーンマネージャインターフェイス
    /// </summary>
    public interface IScreenManager
    {
        /// <summary>
        /// スクリーンを取得する。
        /// </summary>
        /// <param name="totalTick">GameTime.TotalGameTime.Tickの値</param>
        /// <param name="tex">テクスチャ</param>
        /// <returns>1フレームの1回目ならtrue、2回目以降ならfalseを返す</returns>
        bool GetScreenTex(long totalTick, out Texture2D tex);
        /// <summary>
        /// スクリーンモード
        /// </summary>
        /// <remarks>0:Off 1:通常 2:4:3モード</remarks>
        int ScreenMode { get; }
        /// <summary>
        /// スクリーンのズレ修正量
        /// </summary>
        Vector2 ScreenFix { get; }
    }
}
