﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Content;

namespace MikuMikuDance.XNA.Motion
{
    /// <summary>
    /// ベイク済みモーションデータ
    /// </summary>
    public class MMDBakedMotion
    {
        /// <summary>
        /// ベイク済みポーズ
        /// </summary>
        /// <remarks>フレーム番号ごとにボーンデータが並んでいる</remarks>
        public BakedBoneData[] Poses;
        /// <summary>
        /// ボーン数
        /// </summary>
        public int NumBone;
        /// <summary>
        /// ベイク済み表情
        /// </summary>
        /// <remarks>フレーム番号ごとに表情が並んでいる</remarks>
        public Vector4[] Faces;
        /// <summary>
        /// 表情数
        /// </summary>
        public int NumFace;
        /// <summary>
        /// ベイクに使用したモデル名
        /// </summary>
        /// <remarks>xmlで指定したファイルパスがそのまま入っています</remarks>
        public string ModelName;
        /// <summary>
        /// 最大フレーム
        /// </summary>
        public int MaxFrame;
        /// <summary>
        /// 最大ボーンフレーム
        /// </summary>
        public int MaxBoneFrame;
        /// <summary>
        /// 最大表情フレーム
        /// </summary>
        public int MaxFaceFrame;
    }

    
    
}
