//-----------------------------------------------------------------------------
// AccessoryEffect.fx
// ANZTp̃GtFNgBBasicEffect.fx̊gƂȂB
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
// eNX`Tv
//-----------------------------------------------------------------------------

uniform const texture Texture;

uniform const sampler TextureSampler : register(s0) = sampler_state
{
	Texture = (Texture);
	MipFilter = Linear;
	MinFilter = Linear;
	MagFilter = Linear;
};
//XtBA}bv
texture SphereTexture;
uniform const float		SphereType;
uniform const sampler SphereSampler : register(s1) = sampler_state
{
	Texture = (SphereTexture);
	MipFilter = Linear;
	MinFilter = Linear;
	MagFilter = Linear;
};

//XN[p
uniform shared const texture Screen;
//XN[[h(0:XN[Lv`OFFA1:On[h1(S)A2:On[h2(4:3䗦)
uniform shared const float ScreenMode;
uniform shared const float2 ScreenTexFix;
uniform const sampler ScreenSampler : register(s2) = sampler_state
{
	Texture = (Screen);
	MipFilter = Linear;
	MinFilter = Linear;
	MagFilter = Linear;
};
//VhE}bvp
shared texture ShadowMap;
const	float	ShadowBias=0.01f;
const	float	ShadowColor=0.8f;
sampler ShadowSampler = sampler_state
{
    Texture = <ShadowMap>;

    MipFilter = NONE;
    MinFilter = POINT;
    MagFilter = POINT;
    AddressU  = CLAMP;
    AddressV  = CLAMP;
};
//-----------------------------------------------------------------------------
// Cg
//-----------------------------------------------------------------------------
uniform shared const float3	EyePosition		: register(c0);		// in world space
uniform shared const float3	AmbientLightColor		: register(c1);
uniform shared const float3	DirLight0Direction		: register(c2);

//-----------------------------------------------------------------------------
// VhE}bv
//-----------------------------------------------------------------------------
uniform shared const float2 ShadowMapOffset						: register(c9);//VhE}bvItZbg

//-----------------------------------------------------------------------------
// ϊs
//-----------------------------------------------------------------------------

uniform const float4x4	World		: register(vs, c12);	// 12 - 15
uniform shared const float4x4	View		: register(vs, c16);	// 16 - 19
uniform shared const float4x4	Projection	: register(vs, c20);	// 20 - 23
uniform shared const float4x4	ShadowViewProj :register(vs, c24);  // 24 - 27 VhE}bvp

//-----------------------------------------------------------------------------
// tHOݒ
//-----------------------------------------------------------------------------

uniform const float		FogEnabled;
uniform const float		FogStart;
uniform const float		FogEnd;

uniform const float3	FogColor;



//-----------------------------------------------------------------------------
// }eAݒ
//-----------------------------------------------------------------------------

uniform const float3	DiffuseColor = 1;
uniform const float		Alpha = 1;
uniform const float3	EmissiveColor = 0;
uniform const float3	SpecularColor = 1;
uniform const float		SpecularPower = 16;


uniform const float3	DirLight0DiffuseColor;
uniform const float3	DirLight0SpecularColor;

uniform const float3	DirLight1Direction;
uniform const float3	DirLight1DiffuseColor;
uniform const float3	DirLight1SpecularColor;

uniform const float3	DirLight2Direction;
uniform const float3	DirLight2DiffuseColor;
uniform const float3	DirLight2SpecularColor;



//-----------------------------------------------------------------------------
// \̏o
//-----------------------------------------------------------------------------

struct ColorPair
{
	float3 Diffuse;
	float3 Specular;
};

struct CommonVSOutput
{
	float4	Pos_ws;
	float4	Pos_ps;
	float4	Diffuse;
	float3	Specular;
	float	FogFactor;
};
struct CommonVSOutputSd
{
	float4	Pos_ws;
	float4	Pos_ps;
	float4	Diffuse;
	float3	Specular;
	float	FogFactor;
	float4	Pos_Light;
};

// Nm: @
// Tx: eNX`
// Vc: _J[
//
// Nm Tx Vc
//  0  0  0	VSInput
//  0  0  1 VSInputVc
//  0  1  0 VSInputTx
//  0  1  1 VSInputTxVc
//  1  0  0 VSInputNm
//  1  0  1 VSInputNmVc
//  1  1  0 VSInputNmTx
//  1  1  1 VSInputNmTxVc


//-----------------------------------------------------------------------------
// _VF[_[͍\
//-----------------------------------------------------------------------------

struct VSInput
{
	float4	Position	: POSITION;
};

struct VSInputVc
{
	float4	Position	: POSITION;
	float4	Color		: COLOR;
};

struct VSInputNm
{
	float4	Position	: POSITION;
	float3	Normal		: NORMAL;
};

struct VSInputNmVc
{
	float4	Position	: POSITION;
	float3	Normal		: NORMAL;
	float4	Color		: COLOR;
};

struct VSInputTx
{
	float4	Position	: POSITION;
	float2	TexCoord	: TEXCOORD0;
};

struct VSInputTxVc
{
	float4	Position	: POSITION;
	float2	TexCoord	: TEXCOORD0;
	float4	Color		: COLOR;
};

struct VSInputNmTx
{
	float4	Position	: POSITION;
	float2	TexCoord	: TEXCOORD0;
	float3	Normal		: NORMAL;
};

struct VSInputNmTxVc
{
	float4	Position	: POSITION;
	float2	TexCoord	: TEXCOORD0;
	float3	Normal		: NORMAL;
	float4	Color		: COLOR;
};


//-----------------------------------------------------------------------------
// _VF[_o
//-----------------------------------------------------------------------------

struct VertexLightingVSOutput
{
	float4	PositionPS	: POSITION;		// vWFNVςݒ_ʒu
	float4	Diffuse		: COLOR0;
	float4	Specular	: COLOR1;		// Specular.rgbfog factor
};

struct VertexLightingVSOutputTx
{
	float4	PositionPS	: POSITION;		// vWFNVςݒ_ʒu
	float4	Diffuse		: COLOR0;
	float4	Specular	: COLOR1;
	float2	TexCoord	: TEXCOORD0;
};

struct PixelLightingVSOutput
{
	float4	PositionPS	: POSITION;		// vWFNVςݒ_ʒu
	float4	PositionWS	: TEXCOORD0;
	float3	NormalWS	: TEXCOORD1;
	float4	Diffuse		: COLOR0;		// diffuse.rgb  alpha
};

struct PixelLightingVSOutputTx
{
	float4	PositionPS	: POSITION;		// vWFNVςݒ_ʒu
	float2	TexCoord	: TEXCOORD0;
	float4	PositionWS	: TEXCOORD1;
	float3	NormalWS	: TEXCOORD2;
	float4	Diffuse		: COLOR0;		// diffuse.rgb  alpha
};
//XtBA}bv
struct VertexLightingVSOutputSp
{
	float4	PositionPS	: POSITION;		// vWFNVςݒ_ʒu
	float4	Diffuse		: COLOR0;
	float4	Specular	: COLOR1;		// Specular.rgb  fog factor
	float3  NormalWS	: TEXCOORD1;	// @
};

struct VertexLightingVSOutputTxSp
{
	float4	PositionPS	: POSITION;		// vWFNVςݒ_ʒu
	float4	Diffuse		: COLOR0;
	float4	Specular	: COLOR1;
	float2	TexCoord	: TEXCOORD0;
	float3  NormalWS	: TEXCOORD1;	// @
};
//VhE}bv`
struct ShadowMapVSOutput
{
	float4	PositionPS	: POSITION;
	float4	Pos_Light	: TEXCOORD2;
};
struct ShadowMapVSOutputTx
{
	float4	PositionPS	: POSITION;
	float2	TexCoord	: TEXCOORD0;
	float4	Pos_Light	: TEXCOORD2;
};
struct ShadowMapVSOutputSp
{
	float4	PositionPS	: POSITION;
	float3  NormalWS	: TEXCOORD1;	// @
	float4	Pos_Light	: TEXCOORD2;
};
struct ShadowMapVSOutputTxSp
{
	float4	PositionPS	: POSITION;
	float2	TexCoord	: TEXCOORD0;
	float3  NormalWS	: TEXCOORD1;	// @
	float4	Pos_Light	: TEXCOORD2;
};

//VhEt`p
struct VertexLightingVSOutputSd
{
	float4	PositionPS	: POSITION;		// vWFNVςݒ_ʒu
	float4	Diffuse		: COLOR0;
	float4	Specular	: COLOR1;		// Specular.rgbfog factor
	float4	Pos_Light	: TEXCOORD3;	// ݂_ʒu
};

struct VertexLightingVSOutputTxSd
{
	float4	PositionPS	: POSITION;		// vWFNVςݒ_ʒu
	float4	Diffuse		: COLOR0;
	float4	Specular	: COLOR1;
	float2	TexCoord	: TEXCOORD0;
	float4	Pos_Light	: TEXCOORD3;	// ݂_ʒu
};

struct PixelLightingVSOutputSd
{
	float4	PositionPS	: POSITION;		// vWFNVςݒ_ʒu
	float4	PositionWS	: TEXCOORD0;
	float3	NormalWS	: TEXCOORD1;
	float4	Pos_Light	: TEXCOORD3;	// ݂_ʒu
	float4	Diffuse		: COLOR0;		// diffuse.rgb  alpha
};

struct PixelLightingVSOutputTxSd
{
	float4	PositionPS	: POSITION;		// vWFNVςݒ_ʒu
	float2	TexCoord	: TEXCOORD0;
	float4	PositionWS	: TEXCOORD1;
	float3	NormalWS	: TEXCOORD2;
	float4	Pos_Light	: TEXCOORD3;	// ݂_ʒu
	float4	Diffuse		: COLOR0;		// diffuse.rgb  alpha
};
//XtBA}bv
struct VertexLightingVSOutputSpSd
{
	float4	PositionPS	: POSITION;		// vWFNVςݒ_ʒu
	float4	Diffuse		: COLOR0;
	float4	Specular	: COLOR1;		// Specular.rgb  fog factor
	float3  NormalWS	: TEXCOORD1;	// @
	float4	Pos_Light	: TEXCOORD3;	// ݂_ʒu
};

struct VertexLightingVSOutputTxSpSd
{
	float4	PositionPS	: POSITION;		// vWFNVςݒ_ʒu
	float4	Diffuse		: COLOR0;
	float4	Specular	: COLOR1;
	float2	TexCoord	: TEXCOORD0;
	float3  NormalWS	: TEXCOORD1;	// @
	float4	Pos_Light	: TEXCOORD3;	// ݂_ʒu
};
//-----------------------------------------------------------------------------
// sNZVF[_͍\
//-----------------------------------------------------------------------------

struct VertexLightingPSInput
{
	float4	Diffuse		: COLOR0;
	float4	Specular	: COLOR1;
};

struct VertexLightingPSInputTx
{
	float4	Diffuse		: COLOR0;
	float4	Specular	: COLOR1;
	float2	TexCoord	: TEXCOORD0;
};

struct PixelLightingPSInput
{
	float4	PositionWS	: TEXCOORD0;
	float3	NormalWS	: TEXCOORD1;
	float4	Diffuse		: COLOR0;		// diffuse.rgb and alpha
};

struct PixelLightingPSInputTx
{
	float2	TexCoord	: TEXCOORD0;
	float4	PositionWS	: TEXCOORD1;
	float3	NormalWS	: TEXCOORD2;
	float4	Diffuse		: COLOR0;		// diffuse.rgb and alpha
};
//XtBA}bv
struct VertexLightingPSInputSp
{
	float4	Diffuse		: COLOR0;
	float4	Specular	: COLOR1;
	float3	NormalWS	: TEXCOORD1;
};

struct VertexLightingPSInputTxSp
{
	float4	Diffuse		: COLOR0;
	float4	Specular	: COLOR1;
	float2	TexCoord	: TEXCOORD0;
	float3	NormalWS	: TEXCOORD1;
};
//VhE}bv`
struct ShadowMapPSInput
{
	float4	Pos_Light	: TEXCOORD2;
};
struct ShadowMapPSInputTx
{
	float2	TexCoord	: TEXCOORD0;
	float4	Pos_Light	: TEXCOORD2;
};
struct ShadowMapPSInputSp
{
	float3	NormalWS	: TEXCOORD1;
	float4	Pos_Light	: TEXCOORD2;
};
struct ShadowMapPSInputTxSp
{
	float2	TexCoord	: TEXCOORD0;
	float3	NormalWS	: TEXCOORD1;
	float4	Pos_Light	: TEXCOORD2;
};

//VhE`t
struct VertexLightingPSInputSd
{
	float4	Diffuse		: COLOR0;
	float4	Specular	: COLOR1;
	float4	Pos_Light	: TEXCOORD3;	// ݂_ʒu
};

struct VertexLightingPSInputTxSd
{
	float4	Diffuse		: COLOR0;
	float4	Specular	: COLOR1;
	float2	TexCoord	: TEXCOORD0;
	float4	Pos_Light	: TEXCOORD3;	// ݂_ʒu
};

struct PixelLightingPSInputSd
{
	float4	PositionWS	: TEXCOORD0;
	float3	NormalWS	: TEXCOORD1;
	float4	Diffuse		: COLOR0;		// diffuse.rgb and alpha
	float4	Pos_Light	: TEXCOORD3;	// ݂_ʒu
};

struct PixelLightingPSInputTxSd
{
	float2	TexCoord	: TEXCOORD0;
	float4	PositionWS	: TEXCOORD1;
	float3	NormalWS	: TEXCOORD2;
	float4	Diffuse		: COLOR0;		// diffuse.rgb and alpha
	float4	Pos_Light	: TEXCOORD3;	// ݂_ʒu
};
//XtBA}bv
struct VertexLightingPSInputSpSd
{
	float4	Diffuse		: COLOR0;
	float4	Specular	: COLOR1;
	float3	NormalWS	: TEXCOORD1;
	float4	Pos_Light	: TEXCOORD3;	// ݂_ʒu
};

struct VertexLightingPSInputTxSpSd
{
	float4	Diffuse		: COLOR0;
	float4	Specular	: COLOR1;
	float2	TexCoord	: TEXCOORD0;
	float3	NormalWS	: TEXCOORD1;
	float4	Pos_Light	: TEXCOORD3;	// ݂_ʒu
};

//-----------------------------------------------------------------------------
// CeBOvZ
// E: xNg
// N: [hWnɂPʖ@xNg
//-----------------------------------------------------------------------------
ColorPair ComputeLights(float3 E, float3 N)
{
	ColorPair result;
	
	result.Diffuse = AmbientLightColor;
	result.Specular = 0;

	// Directional Light 0
	float3 L = normalize(-DirLight0Direction);
	float3 H = normalize(E + L);
	float2 ret = lit(dot(N, L), dot(N, H), SpecularPower).yz;
	result.Diffuse += DirLight0DiffuseColor * ret.x;
	result.Specular += DirLight0SpecularColor * ret.y;
	
	// Directional Light 1
	L = -DirLight1Direction;
	H = normalize(E + L);
	ret = lit(dot(N, L), dot(N, H), SpecularPower).yz;
	result.Diffuse += DirLight1DiffuseColor * ret.x;
	result.Specular += DirLight1SpecularColor * ret.y;
	
	// Directional Light 2
	L = -DirLight2Direction;
	H = normalize(E + L);
	ret = lit(dot(N, L), dot(N, H), SpecularPower).yz;
	result.Diffuse += DirLight2DiffuseColor * ret.x;
	result.Specular += DirLight2SpecularColor * ret.y;
		
	result.Diffuse *= DiffuseColor;
	result.Diffuse	+= EmissiveColor;
	result.Diffuse	=saturate(result.Diffuse);
	result.Specular	*= SpecularColor;
		
	return result;
}


//-----------------------------------------------------------------------------
// p[sNZCeBOvZ
// When compiling for pixel shader 2.0, the lit intrinsic uses more slots
// than doing this directly ourselves, so we don't use the intrinsic.
// E: xNg
// N: [hWnɂPʖ@xNg
//-----------------------------------------------------------------------------
ColorPair ComputePerPixelLights(float3 E, float3 N)
{
	ColorPair result;
	
	result.Diffuse = AmbientLightColor;
	result.Specular = 0;
	
	// Light0
	float3 L = -DirLight0Direction;
	float3 H = normalize(E + L);
	float dt = max(0,dot(L,N));
    result.Diffuse += DirLight0DiffuseColor * dt;
    if (dt != 0)
		result.Specular += DirLight0SpecularColor * pow(max(0,dot(H,N)), SpecularPower);

	// Light1
	L = -DirLight1Direction;
	H = normalize(E + L);
	dt = max(0,dot(L,N));
    result.Diffuse += DirLight1DiffuseColor * dt;
    if (dt != 0)
	    result.Specular += DirLight1SpecularColor * pow(max(0,dot(H,N)), SpecularPower);
    
	// Light2
	L = -DirLight2Direction;
	H = normalize(E + L);
	dt = max(0,dot(L,N));
    result.Diffuse += DirLight2DiffuseColor * dt;
    if (dt != 0)
	    result.Specular += DirLight2SpecularColor * pow(max(0,dot(H,N)), SpecularPower);
    
    result.Diffuse *= DiffuseColor;
    result.Diffuse += EmissiveColor;
    result.Specular *= SpecularColor;
		
	return result;
}


//-----------------------------------------------------------------------------
// tHOt@N^[vZ
//-----------------------------------------------------------------------------
float ComputeFogFactor(float d)
{
    return clamp((d - FogStart) / (FogEnd - FogStart), 0, 1) * FogEnabled;
}


CommonVSOutput ComputeCommonVSOutput(float4 position)
{
	CommonVSOutput vout;
	
	float4 pos_ws = mul(position, World);
	float4 pos_vs = mul(pos_ws, View);
	float4 pos_ps = mul(pos_vs, Projection);
	vout.Pos_ws = pos_ws;
	vout.Pos_ps = pos_ps;
	
	vout.Diffuse	= float4(DiffuseColor.rgb + EmissiveColor, Alpha);
	vout.Specular	= 0;
	vout.FogFactor	= ComputeFogFactor(length(EyePosition - pos_ws ));
	
	return vout;
}

CommonVSOutput ComputeCommonVSOutputWithLighting(float4 position, float3 normal)
{
	CommonVSOutput vout;
	
	float4 pos_ws = mul(position, World);
	float4 pos_vs = mul(pos_ws, View);
	float4 pos_ps = mul(pos_vs, Projection);
	vout.Pos_ws = pos_ws;
	vout.Pos_ps = pos_ps;
	
	float3 N = normalize(mul(normal, World));
	float3 posToEye = EyePosition - pos_ws.xyz;
	float3 E = normalize(posToEye);
	ColorPair lightResult = ComputeLights(E, N);
	
	vout.Diffuse	= float4(lightResult.Diffuse.rgb, Alpha);
	vout.Specular	= lightResult.Specular;
	vout.FogFactor	= ComputeFogFactor(length(posToEye));
	
	return vout;
}


//-----------------------------------------------------------------------------
// _VF[_֐
//-----------------------------------------------------------------------------

VertexLightingVSOutput VSBasic(VSInput vin)
{
	VertexLightingVSOutput vout;
	
	CommonVSOutput cout = ComputeCommonVSOutput(vin.Position);

	vout.PositionPS	= cout.Pos_ps;
	vout.Diffuse	= cout.Diffuse;
	vout.Specular	= float4(cout.Specular, cout.FogFactor);
	
	return vout;
}


VertexLightingVSOutput VSBasicVc(VSInputVc vin)
{
	VertexLightingVSOutput vout;
	
	CommonVSOutput cout = ComputeCommonVSOutput(vin.Position);

	vout.PositionPS	= cout.Pos_ps;
	vout.Diffuse	= cout.Diffuse * vin.Color;
	vout.Specular	= float4(cout.Specular, cout.FogFactor);
	
	return vout;
}


VertexLightingVSOutput VSBasicNm(VSInputNm vin)
{
	VertexLightingVSOutput vout;
	
	CommonVSOutput cout = ComputeCommonVSOutputWithLighting(vin.Position, vin.Normal);

	vout.PositionPS	= cout.Pos_ps;
	vout.Diffuse	= cout.Diffuse;
	vout.Specular	= float4(cout.Specular, cout.FogFactor);
	
	return vout;
}


VertexLightingVSOutput VSBasicNmVc(VSInputNmVc vin)
{
	VertexLightingVSOutput vout;
	
	CommonVSOutput cout = ComputeCommonVSOutputWithLighting(vin.Position, vin.Normal);

	vout.PositionPS	= cout.Pos_ps;
	vout.Diffuse	= cout.Diffuse * vin.Color;
	vout.Specular	= float4(cout.Specular, cout.FogFactor);
	
	return vout;
}


VertexLightingVSOutputTx VSBasicTx(VSInputTx vin)
{
	VertexLightingVSOutputTx vout;
	
	CommonVSOutput cout = ComputeCommonVSOutput(vin.Position);

	vout.PositionPS	= cout.Pos_ps;
	vout.Diffuse	= cout.Diffuse;
	vout.Specular	= float4(cout.Specular, cout.FogFactor);
	vout.TexCoord	= vin.TexCoord;

	return vout;
}


VertexLightingVSOutputTx VSBasicTxVc(VSInputTxVc vin)
{
	VertexLightingVSOutputTx vout;
	
	CommonVSOutput cout = ComputeCommonVSOutput(vin.Position);

	vout.PositionPS	= cout.Pos_ps;
	vout.Diffuse	= cout.Diffuse * vin.Color;
	vout.Specular	= float4(cout.Specular, cout.FogFactor);
	vout.TexCoord	= vin.TexCoord;
	
	return vout;
}


VertexLightingVSOutputTx VSBasicNmTx(VSInputNmTx vin)
{
	VertexLightingVSOutputTx vout;
	
	CommonVSOutput cout = ComputeCommonVSOutputWithLighting(vin.Position, vin.Normal);

	vout.PositionPS	= cout.Pos_ps;
	vout.Diffuse	= cout.Diffuse;
	vout.Specular	= float4(cout.Specular, cout.FogFactor);
	vout.TexCoord	= vin.TexCoord;

	return vout;
}


VertexLightingVSOutputTx VSBasicNmTxVc(VSInputNmTxVc vin)
{
	VertexLightingVSOutputTx vout;
	
	CommonVSOutput cout = ComputeCommonVSOutputWithLighting(vin.Position, vin.Normal);

	vout.PositionPS	= cout.Pos_ps;
	vout.Diffuse	= cout.Diffuse * vin.Color;
	vout.Specular	= float4(cout.Specular, cout.FogFactor);
	vout.TexCoord	= vin.TexCoord;
	
	return vout;
}
//XtBA}bv
VertexLightingVSOutputSp VSBasicNmSp(VSInputNm vin)
{
	VertexLightingVSOutputSp vout;
	
	CommonVSOutput cout = ComputeCommonVSOutputWithLighting(vin.Position, vin.Normal);

	vout.PositionPS	= cout.Pos_ps;
	vout.Diffuse	= cout.Diffuse;
	vout.Specular	= float4(cout.Specular, cout.FogFactor);
	vout.NormalWS	= normalize(mul(vin.Normal, World));
	
	return vout;
}


VertexLightingVSOutputSp VSBasicNmVcSp(VSInputNmVc vin)
{
	VertexLightingVSOutputSp vout;
	
	CommonVSOutput cout = ComputeCommonVSOutputWithLighting(vin.Position, vin.Normal);

	vout.PositionPS	= cout.Pos_ps;
	vout.Diffuse	= cout.Diffuse * vin.Color;
	vout.Specular	= float4(cout.Specular, cout.FogFactor);
	vout.NormalWS		= normalize(mul(vin.Normal, World));
	
	return vout;
}
VertexLightingVSOutputTxSp VSBasicNmTxSp(VSInputNmTx vin)
{
	VertexLightingVSOutputTxSp vout;
	
	CommonVSOutput cout = ComputeCommonVSOutputWithLighting(vin.Position, vin.Normal);

	vout.PositionPS	= cout.Pos_ps;
	vout.Diffuse	= cout.Diffuse;
	vout.Specular	= float4(cout.Specular, cout.FogFactor);
	vout.TexCoord	= vin.TexCoord;
	vout.NormalWS		= normalize(mul(vin.Normal, World));
	
	return vout;
}


VertexLightingVSOutputTxSp VSBasicNmTxVcSp(VSInputNmTxVc vin)
{
	VertexLightingVSOutputTxSp vout;
	
	CommonVSOutput cout = ComputeCommonVSOutputWithLighting(vin.Position, vin.Normal);

	vout.PositionPS	= cout.Pos_ps;
	vout.Diffuse	= cout.Diffuse * vin.Color;
	vout.Specular	= float4(cout.Specular, cout.FogFactor);
	vout.TexCoord	= vin.TexCoord;
	vout.NormalWS		= normalize(mul(vin.Normal, World));
	
	return vout;
}
//-----------------------------------------------------------------------------
// p[sNZCeBOp_VF[_
//-----------------------------------------------------------------------------

PixelLightingVSOutput VSBasicPixelLightingNm(VSInputNm vin)
{
	PixelLightingVSOutput vout;
	
	float4 pos_ws = mul(vin.Position, World);
	float4 pos_vs = mul(pos_ws, View);
	float4 pos_ps = mul(pos_vs, Projection);
	
	vout.PositionPS		= pos_ps;
	vout.PositionWS.xyz	= pos_ws.xyz;
	vout.PositionWS.w	= ComputeFogFactor(length(EyePosition - pos_ws));
	vout.NormalWS		= normalize(mul(vin.Normal, World));
	vout.Diffuse		= float4(1, 1, 1, Alpha);
	
	return vout;
}


PixelLightingVSOutput VSBasicPixelLightingNmVc(VSInputNmVc vin)
{
	PixelLightingVSOutput vout;
	
	float4 pos_ws = mul(vin.Position, World);
	float4 pos_vs = mul(pos_ws, View);
	float4 pos_ps = mul(pos_vs, Projection);
	
	vout.PositionPS		= pos_ps;
	vout.PositionWS.xyz	= pos_ws.xyz;
	vout.PositionWS.w	= ComputeFogFactor(length(EyePosition - pos_ws));
	vout.NormalWS		= normalize(mul(vin.Normal, World));
	vout.Diffuse.rgb	= vin.Color.rgb;
	vout.Diffuse.a		= vin.Color.a * Alpha;
	
	return vout;
}


PixelLightingVSOutputTx VSBasicPixelLightingNmTx(VSInputNmTx vin)
{
	PixelLightingVSOutputTx vout;
	
	float4 pos_ws = mul(vin.Position, World);
	float4 pos_vs = mul(pos_ws, View);
	float4 pos_ps = mul(pos_vs, Projection);
	
	vout.PositionPS		= pos_ps;
	vout.PositionWS.xyz	= pos_ws.xyz;
	vout.PositionWS.w	= ComputeFogFactor(length(EyePosition - pos_ws));
	vout.NormalWS		= normalize(mul(vin.Normal, World));
	vout.Diffuse		= float4(1, 1, 1, Alpha);
	vout.TexCoord		= vin.TexCoord;

	return vout;
}


PixelLightingVSOutputTx VSBasicPixelLightingNmTxVc(VSInputNmTxVc vin)
{
	PixelLightingVSOutputTx vout;
	
	float4 pos_ws = mul(vin.Position, World);
	float4 pos_vs = mul(pos_ws, View);
	float4 pos_ps = mul(pos_vs, Projection);
	
	vout.PositionPS		= pos_ps;
	vout.PositionWS.xyz	= pos_ws.xyz;
	vout.PositionWS.w	= ComputeFogFactor(length(EyePosition - pos_ws));
	vout.NormalWS		= normalize(mul(vin.Normal, World));
	vout.Diffuse.rgb	= vin.Color.rgb;
	vout.Diffuse.a		= vin.Color.a * Alpha;
	vout.TexCoord		= vin.TexCoord;
	
	return vout;
}
//-----------------------------------------------------------------------------
// VhE}bv`p_VF[_
//-----------------------------------------------------------------------------
ShadowMapVSOutput VSShadowMap(VSInput vin)
{
	ShadowMapVSOutput vout;
	float4 pos_ws = mul(vin.Position, World);
	float4 pos_vs = mul(pos_ws, View);
	float4 pos_ps = mul(pos_vs, Projection);
	
	vout.PositionPS		= pos_ps;
	vout.Pos_Light		= vout.PositionPS;
	
	return vout;
}
ShadowMapVSOutputTx VSShadowMapTx(VSInputTx vin)
{
	ShadowMapVSOutputTx vout;
	float4 pos_ws = mul(vin.Position, World);
	float4 pos_vs = mul(pos_ws, View);
	float4 pos_ps = mul(pos_vs, Projection);
	
	vout.PositionPS		= pos_ps;
	vout.Pos_Light		= vout.PositionPS;
	vout.TexCoord		= vin.TexCoord;
	
	return vout;
}
ShadowMapVSOutputSp VSShadowMapSp(VSInputNm vin)
{
	ShadowMapVSOutputSp vout;
	float4 pos_ws = mul(vin.Position, World);
	float4 pos_vs = mul(pos_ws, View);
	float4 pos_ps = mul(pos_vs, Projection);
	
	vout.PositionPS		= pos_ps;
	vout.Pos_Light		= vout.PositionPS;
	vout.NormalWS		= normalize(mul(vin.Normal, World));
	
	return vout;
}
ShadowMapVSOutputTxSp VSShadowMapTxSp(VSInputNmTx vin)
{
	ShadowMapVSOutputTxSp vout;
	float4 pos_ws = mul(vin.Position, World);
	float4 pos_vs = mul(pos_ws, View);
	float4 pos_ps = mul(pos_vs, Projection);
	
	vout.PositionPS		= pos_ps;
	vout.Pos_Light		= vout.PositionPS;
	vout.TexCoord		= vin.TexCoord;
	vout.NormalWS		= normalize(mul(vin.Normal, World));
	
	return vout;
}


//-----------------------------------------------------------------------------
// VhEt_VF[_
//-----------------------------------------------------------------------------

VertexLightingVSOutputSd VSBasicSd(VSInput vin)
{
	VertexLightingVSOutputSd vout;
	
	CommonVSOutput cout = ComputeCommonVSOutput(vin.Position);

	vout.PositionPS	= cout.Pos_ps;
	vout.Diffuse	= cout.Diffuse;
	vout.Specular	= float4(cout.Specular, cout.FogFactor);
	vout.Pos_Light	= mul(cout.Pos_ws,ShadowViewProj);
	
	return vout;
}


VertexLightingVSOutputSd VSBasicVcSd(VSInputVc vin)
{
	VertexLightingVSOutputSd vout;
	
	CommonVSOutput cout = ComputeCommonVSOutput(vin.Position);

	vout.PositionPS	= cout.Pos_ps;
	vout.Diffuse	= cout.Diffuse * vin.Color;
	vout.Specular	= float4(cout.Specular, cout.FogFactor);
	vout.Pos_Light	= mul(cout.Pos_ws,ShadowViewProj);
	
	return vout;
}


VertexLightingVSOutputSd VSBasicNmSd(VSInputNm vin)
{
	VertexLightingVSOutputSd vout;
	
	CommonVSOutput cout = ComputeCommonVSOutputWithLighting(vin.Position, vin.Normal);

	vout.PositionPS	= cout.Pos_ps;
	vout.Diffuse	= cout.Diffuse;
	vout.Specular	= float4(cout.Specular, cout.FogFactor);
	vout.Pos_Light	= mul(cout.Pos_ws,ShadowViewProj);
	
	return vout;
}


VertexLightingVSOutputSd VSBasicNmVcSd(VSInputNmVc vin)
{
	VertexLightingVSOutputSd vout;
	
	CommonVSOutput cout = ComputeCommonVSOutputWithLighting(vin.Position, vin.Normal);

	vout.PositionPS	= cout.Pos_ps;
	vout.Diffuse	= cout.Diffuse * vin.Color;
	vout.Specular	= float4(cout.Specular, cout.FogFactor);
	vout.Pos_Light	= mul(cout.Pos_ws,ShadowViewProj);
	
	return vout;
}


VertexLightingVSOutputTxSd VSBasicTxSd(VSInputTx vin)
{
	VertexLightingVSOutputTxSd vout;
	
	CommonVSOutput cout = ComputeCommonVSOutput(vin.Position);

	vout.PositionPS	= cout.Pos_ps;
	vout.Diffuse	= cout.Diffuse;
	vout.Specular	= float4(cout.Specular, cout.FogFactor);
	vout.TexCoord	= vin.TexCoord;
	vout.Pos_Light	= mul(cout.Pos_ws,ShadowViewProj);
	
	return vout;
}


VertexLightingVSOutputTxSd VSBasicTxVcSd(VSInputTxVc vin)
{
	VertexLightingVSOutputTxSd vout;
	
	CommonVSOutput cout = ComputeCommonVSOutput(vin.Position);

	vout.PositionPS	= cout.Pos_ps;
	vout.Diffuse	= cout.Diffuse * vin.Color;
	vout.Specular	= float4(cout.Specular, cout.FogFactor);
	vout.TexCoord	= vin.TexCoord;
	vout.Pos_Light	= mul(cout.Pos_ws,ShadowViewProj);
	
	return vout;
}


VertexLightingVSOutputTxSd VSBasicNmTxSd(VSInputNmTx vin)
{
	VertexLightingVSOutputTxSd vout;
	
	CommonVSOutput cout = ComputeCommonVSOutputWithLighting(vin.Position, vin.Normal);

	vout.PositionPS	= cout.Pos_ps;
	vout.Diffuse	= cout.Diffuse;
	vout.Specular	= float4(cout.Specular, cout.FogFactor);
	vout.TexCoord	= vin.TexCoord;
	vout.Pos_Light	= mul(cout.Pos_ws,ShadowViewProj);
	
	return vout;
}


VertexLightingVSOutputTxSd VSBasicNmTxVcSd(VSInputNmTxVc vin)
{
	VertexLightingVSOutputTxSd vout;
	
	CommonVSOutput cout = ComputeCommonVSOutputWithLighting(vin.Position, vin.Normal);

	vout.PositionPS	= cout.Pos_ps;
	vout.Diffuse	= cout.Diffuse * vin.Color;
	vout.Specular	= float4(cout.Specular, cout.FogFactor);
	vout.TexCoord	= vin.TexCoord;
	vout.Pos_Light	= mul(cout.Pos_ws,ShadowViewProj);
	
	return vout;
}
//XtBA}bv
VertexLightingVSOutputSpSd VSBasicNmSpSd(VSInputNm vin)
{
	VertexLightingVSOutputSpSd vout;
	
	CommonVSOutput cout = ComputeCommonVSOutputWithLighting(vin.Position, vin.Normal);

	vout.PositionPS	= cout.Pos_ps;
	vout.Diffuse	= cout.Diffuse;
	vout.Specular	= float4(cout.Specular, cout.FogFactor);
	vout.NormalWS	= normalize(mul(vin.Normal, World));
	vout.Pos_Light	= mul(cout.Pos_ws,ShadowViewProj);
	
	return vout;
}


VertexLightingVSOutputSpSd VSBasicNmVcSpSd(VSInputNmVc vin)
{
	VertexLightingVSOutputSpSd vout;
	
	CommonVSOutput cout = ComputeCommonVSOutputWithLighting(vin.Position, vin.Normal);

	vout.PositionPS	= cout.Pos_ps;
	vout.Diffuse	= cout.Diffuse * vin.Color;
	vout.Specular	= float4(cout.Specular, cout.FogFactor);
	vout.NormalWS		= normalize(mul(vin.Normal, World));
	vout.Pos_Light	= mul(cout.Pos_ws,ShadowViewProj);
	
	return vout;
}
VertexLightingVSOutputTxSpSd VSBasicNmTxSpSd(VSInputNmTx vin)
{
	VertexLightingVSOutputTxSpSd vout;
	
	CommonVSOutput cout = ComputeCommonVSOutputWithLighting(vin.Position, vin.Normal);

	vout.PositionPS	= cout.Pos_ps;
	vout.Diffuse	= cout.Diffuse;
	vout.Specular	= float4(cout.Specular, cout.FogFactor);
	vout.TexCoord	= vin.TexCoord;
	vout.NormalWS		= normalize(mul(vin.Normal, World));
	vout.Pos_Light	= mul(cout.Pos_ws,ShadowViewProj);
	
	return vout;
}


VertexLightingVSOutputTxSpSd VSBasicNmTxVcSpSd(VSInputNmTxVc vin)
{
	VertexLightingVSOutputTxSpSd vout;
	
	CommonVSOutput cout = ComputeCommonVSOutputWithLighting(vin.Position, vin.Normal);

	vout.PositionPS	= cout.Pos_ps;
	vout.Diffuse	= cout.Diffuse * vin.Color;
	vout.Specular	= float4(cout.Specular, cout.FogFactor);
	vout.TexCoord	= vin.TexCoord;
	vout.NormalWS		= normalize(mul(vin.Normal, World));
	vout.Pos_Light	= mul(cout.Pos_ws,ShadowViewProj);
	
	return vout;
}
//-----------------------------------------------------------------------------
// VhE`tp[sNZCeBOp_VF[_
//-----------------------------------------------------------------------------

PixelLightingVSOutputSd VSBasicPixelLightingNmSd(VSInputNm vin)
{
	PixelLightingVSOutputSd vout;
	
	float4 pos_ws = mul(vin.Position, World);
	float4 pos_vs = mul(pos_ws, View);
	float4 pos_ps = mul(pos_vs, Projection);
	
	vout.PositionPS		= pos_ps;
	vout.PositionWS.xyz	= pos_ws.xyz;
	vout.PositionWS.w	= ComputeFogFactor(length(EyePosition - pos_ws));
	vout.NormalWS		= normalize(mul(vin.Normal, World));
	vout.Diffuse		= float4(1, 1, 1, Alpha);
	vout.Pos_Light		= mul(pos_ws,ShadowViewProj);
	
	return vout;
}


PixelLightingVSOutputSd VSBasicPixelLightingNmVcSd(VSInputNmVc vin)
{
	PixelLightingVSOutputSd vout;
	
	float4 pos_ws = mul(vin.Position, World);
	float4 pos_vs = mul(pos_ws, View);
	float4 pos_ps = mul(pos_vs, Projection);
	
	vout.PositionPS		= pos_ps;
	vout.PositionWS.xyz	= pos_ws.xyz;
	vout.PositionWS.w	= ComputeFogFactor(length(EyePosition - pos_ws));
	vout.NormalWS		= normalize(mul(vin.Normal, World));
	vout.Diffuse.rgb	= vin.Color.rgb;
	vout.Diffuse.a		= vin.Color.a * Alpha;
	vout.Pos_Light		= mul(pos_ws,ShadowViewProj);
	
	return vout;
}


PixelLightingVSOutputTxSd VSBasicPixelLightingNmTxSd(VSInputNmTx vin)
{
	PixelLightingVSOutputTxSd vout;
	
	float4 pos_ws = mul(vin.Position, World);
	float4 pos_vs = mul(pos_ws, View);
	float4 pos_ps = mul(pos_vs, Projection);
	
	vout.PositionPS		= pos_ps;
	vout.PositionWS.xyz	= pos_ws.xyz;
	vout.PositionWS.w	= ComputeFogFactor(length(EyePosition - pos_ws));
	vout.NormalWS		= normalize(mul(vin.Normal, World));
	vout.Diffuse		= float4(1, 1, 1, Alpha);
	vout.TexCoord		= vin.TexCoord;
	vout.Pos_Light		= mul(pos_ws,ShadowViewProj);
	
	return vout;
}


PixelLightingVSOutputTxSd VSBasicPixelLightingNmTxVcSd(VSInputNmTxVc vin)
{
	PixelLightingVSOutputTxSd vout;
	
	float4 pos_ws = mul(vin.Position, World);
	float4 pos_vs = mul(pos_ws, View);
	float4 pos_ps = mul(pos_vs, Projection);
	
	vout.PositionPS		= pos_ps;
	vout.PositionWS.xyz	= pos_ws.xyz;
	vout.PositionWS.w	= ComputeFogFactor(length(EyePosition - pos_ws));
	vout.NormalWS		= normalize(mul(vin.Normal, World));
	vout.Diffuse.rgb	= vin.Color.rgb;
	vout.Diffuse.a		= vin.Color.a * Alpha;
	vout.TexCoord		= vin.TexCoord;
	vout.Pos_Light		= mul(pos_ws,ShadowViewProj);
	
	return vout;
}

//-----------------------------------------------------------------------------
// sNZVF[_
//-----------------------------------------------------------------------------

float4 PSBasic(VertexLightingPSInput pin) : COLOR
{
	float4 color = pin.Diffuse + float4(pin.Specular.rgb, 0);
	color.rgb = lerp(color.rgb, FogColor, pin.Specular.w);
	return color;
}


float4 PSBasicTx(VertexLightingPSInputTx pin) : COLOR
{
	float4 color = tex2D(TextureSampler, pin.TexCoord) * pin.Diffuse + float4(pin.Specular.rgb, 0);
	color.rgb = lerp(color.rgb, FogColor, pin.Specular.w);
	return color;
}


float4 PSBasicPixelLighting(PixelLightingPSInput pin) : COLOR
{
	float3 posToEye = EyePosition - pin.PositionWS.xyz;
	
	float3 N = normalize(pin.NormalWS);
	float3 E = normalize(posToEye);
	
	ColorPair lightResult = ComputePerPixelLights(E, N);

	float4 diffuse = float4(lightResult.Diffuse * pin.Diffuse.rgb, pin.Diffuse.a);
	float4 color = diffuse + float4(lightResult.Specular, 0);
	color.rgb = lerp(color.rgb, FogColor, pin.PositionWS.w);
	
	return color;
}


float4 PSBasicPixelLightingTx(PixelLightingPSInputTx pin) : COLOR
{
	float3 posToEye = EyePosition - pin.PositionWS.xyz;
	
	float3 N = normalize(pin.NormalWS);
	float3 E = normalize(posToEye);
	
	ColorPair lightResult = ComputePerPixelLights(E, N);
	
	float4 diffuse = tex2D(TextureSampler, pin.TexCoord) * float4(lightResult.Diffuse * pin.Diffuse.rgb, pin.Diffuse.a);
	float4 color = diffuse + float4(lightResult.Specular, 0);
	color.rgb = lerp(color.rgb, FogColor, pin.PositionWS.w);
	
	return color;
}
//XtBA}bv
float4 PSBasicSp(VertexLightingPSInputSp pin) : COLOR
{
	float4 color = pin.Diffuse + float4(pin.Specular.rgb, 0);
	color.rgb = lerp(color.rgb, FogColor, pin.Specular.w);
	//XtBA}bvvZ
	float3 N = normalize(pin.NormalWS);
	float2 SphereCoord = float2(N.x*0.5f+0.5f,N.y*0.5f+0.5f);
	if(SphereType==1)
		color*=tex2D(SphereSampler,SphereCoord);//XtBA}bvZ
	else if(SphereType==2)
		color+=tex2D(SphereSampler,SphereCoord);//XtBA}bvZ
	return color;
}


float4 PSBasicTxSp(VertexLightingPSInputTxSp pin) : COLOR
{
	float4 color = tex2D(TextureSampler, pin.TexCoord) * pin.Diffuse + float4(pin.Specular.rgb, 0);
	color.rgb = lerp(color.rgb, FogColor, pin.Specular.w);
	//XtBA}bvvZ
	float3 N = normalize(pin.NormalWS);
	float2 SphereCoord = float2(N.x*0.5f+0.5f,N.y*0.5f+0.5f);
	if(SphereType==1)
		color*=tex2D(SphereSampler,SphereCoord);//XtBA}bvZ
	else if(SphereType==2)
		color+=tex2D(SphereSampler,SphereCoord);//XtBA}bvZ
	return color;
}


float4 PSBasicPixelLightingSp(PixelLightingPSInput pin) : COLOR
{
	float3 posToEye = EyePosition - pin.PositionWS.xyz;
	
	float3 N = normalize(pin.NormalWS);
	float3 E = normalize(posToEye);
	
	ColorPair lightResult = ComputePerPixelLights(E, N);

	float4 diffuse = float4(lightResult.Diffuse * pin.Diffuse.rgb, pin.Diffuse.a);
	float4 color = diffuse + float4(lightResult.Specular, 0);
	color.rgb = lerp(color.rgb, FogColor, pin.PositionWS.w);
	//XtBA}bvvZ
	float2 SphereCoord = float2(N.x*0.5f+0.5f,N.y*0.5f+0.5f);
	if(SphereType==1)
		color*=tex2D(SphereSampler,SphereCoord);//XtBA}bvZ
	else if(SphereType==2)
		color+=tex2D(SphereSampler,SphereCoord);//XtBA}bvZ
	
	return color;
}


float4 PSBasicPixelLightingTxSp(PixelLightingPSInputTx pin) : COLOR
{
	float3 posToEye = EyePosition - pin.PositionWS.xyz;
	
	float3 N = normalize(pin.NormalWS);
	float3 E = normalize(posToEye);
	
	ColorPair lightResult = ComputePerPixelLights(E, N);
	
	float4 diffuse = tex2D(TextureSampler, pin.TexCoord) * float4(lightResult.Diffuse * pin.Diffuse.rgb, pin.Diffuse.a);
	float4 color = diffuse + float4(lightResult.Specular, 0);
	color.rgb = lerp(color.rgb, FogColor, pin.PositionWS.w);
	//XtBA}bvvZ
	float2 SphereCoord = float2(N.x*0.5f+0.5f,N.y*0.5f+0.5f);
	if(SphereType==1)
		color*=tex2D(SphereSampler,SphereCoord);//XtBA}bvZ
	else if(SphereType==2)
		color+=tex2D(SphereSampler,SphereCoord);//XtBA}bvZ
	
	return color;
}
//XN[
float4 PSBasicScreen(VertexLightingPSInputTx pin) : COLOR
{
	float4 color = tex2D(ScreenSampler, pin.TexCoord) * pin.Diffuse + float4(pin.Specular.rgb, 0);
	color.rgb = lerp(color.rgb, FogColor, pin.Specular.w);
	return color;
}

float4 PSBasicPixelLightingScreen(PixelLightingPSInputTx pin) : COLOR
{
	float3 posToEye = EyePosition - pin.PositionWS.xyz;
	
	float3 N = normalize(pin.NormalWS);
	float3 E = normalize(posToEye);
	
	ColorPair lightResult = ComputePerPixelLights(E, N);
	
	float4 diffuse = tex2D(ScreenSampler, pin.TexCoord) * float4(lightResult.Diffuse * pin.Diffuse.rgb, pin.Diffuse.a);
	float4 color = diffuse + float4(lightResult.Specular, 0);
	color.rgb = lerp(color.rgb, FogColor, pin.PositionWS.w);
	
	return color;
}
//VhE}bv`
float4 PSShadowMap(ShadowMapPSInput pin) : COLOR
{
	float Depth=pin.Pos_Light.z/pin.Pos_Light.w;
	return float4(Depth,Depth,Depth,Alpha);
}
float4 PSShadowMapTx(ShadowMapPSInputTx pin) :COLOR
{
	float Depth=pin.Pos_Light.z/pin.Pos_Light.w;
	float4 color=float4(DiffuseColor,Alpha);
	color*=tex2D(TextureSampler,pin.TexCoord);
	return float4(Depth,Depth,Depth,color.a);
}
float4 PSShadowMapSp(ShadowMapPSInputSp pin) :COLOR
{
	float Depth=pin.Pos_Light.z/pin.Pos_Light.w;
	//XtBA}bvvZ
	float3 N = normalize(pin.NormalWS);
	float2 SphereCoord = float2(N.x*0.5f+0.5f,N.y*0.5f+0.5f);
	float4 color=float4(DiffuseColor,Alpha);
	if(SphereType==1)
		color*=tex2D(SphereSampler,SphereCoord);//XtBA}bvZ
	else if(SphereType==2)
		color+=tex2D(SphereSampler,SphereCoord);//XtBA}bvZ
	return float4(Depth,Depth,Depth,color.a);
}
float4 PSShadowMapTxSp(ShadowMapPSInputTxSp pin) :COLOR
{
	float Depth=pin.Pos_Light.z/pin.Pos_Light.w;
	//XtBA}bvvZ
	float3 N = normalize(pin.NormalWS);
	float2 SphereCoord = float2(N.x*0.5f+0.5f,N.y*0.5f+0.5f);
	float4 color=float4(DiffuseColor,Alpha);
	color*=tex2D(TextureSampler,pin.TexCoord);
	if(SphereType==1)
		color*=tex2D(SphereSampler,SphereCoord);//XtBA}bvZ
	else if(SphereType==2)
		color+=tex2D(SphereSampler,SphereCoord);//XtBA}bvZ
	return float4(Depth,Depth,Depth,color.a);
}
float4 PSShadowMapScreen(ShadowMapPSInputTx pin) :COLOR
{
	float Depth=pin.Pos_Light.z/pin.Pos_Light.w;
	float4 color=float4(DiffuseColor,Alpha);
	color*=tex2D(ScreenSampler,pin.TexCoord);
	return float4(Depth,Depth,Depth,color.a);
}

//-----------------------------------------------------------------------------
// VhE`tsNZVF[_
//-----------------------------------------------------------------------------

float4 PSBasicSd(VertexLightingPSInputSd pin) : COLOR
{
	//VhE}bv擾ʒuvZ
	float2 shadow_uv=0.5*pin.Pos_Light.xy/pin.Pos_Light.w+float2(0.5f,0.5f);
	shadow_uv.y=1.0f-shadow_uv.y;
	shadow_uv+=ShadowMapOffset;
	//VhE}bv_̐[x擾
	float shadow_val=tex2D(ShadowSampler,shadow_uv).r;
	//eB
	float depth=pin.Pos_Light.z/pin.Pos_Light.w;
	//͌猩݂̐[x񂪁AVhE}bv̐[x傫ȂA
	//̓VhE}bv`掞ɂ猩[x󂢁猩ĎOɂsNZɏ㏑Ă
	//㏑Ă遨̃sNZ猩ĎOɂ遨eƂȂB
	if(depth-shadow_val>ShadowBias*(1-shadow_uv.y))
	{
		//fBt[YFftHg̑fAmbientFɕύX
		pin.Diffuse=float4(DiffuseColor*AmbientLightColor*ShadowColor,Alpha);
		//XyL0Ƃ
		pin.Specular=0;
	}
	float4 color = pin.Diffuse + float4(pin.Specular.rgb, 0);
	color.rgb = lerp(color.rgb, FogColor, pin.Specular.w);
	return color;
}


float4 PSBasicTxSd(VertexLightingPSInputTxSd pin) : COLOR
{
	//VhE}bv擾ʒuvZ
	float2 shadow_uv=0.5*pin.Pos_Light.xy/pin.Pos_Light.w+float2(0.5f,0.5f);
	shadow_uv.y=1.0f-shadow_uv.y;
	shadow_uv+=ShadowMapOffset;
	//VhE}bv_̐[x擾
	float shadow_val=tex2D(ShadowSampler,shadow_uv).r;
	//eB
	float depth=pin.Pos_Light.z/pin.Pos_Light.w;
	//͌猩݂̐[x񂪁AVhE}bv̐[x傫ȂA
	//̓VhE}bv`掞ɂ猩[x󂢁猩ĎOɂsNZɏ㏑Ă
	//㏑Ă遨̃sNZ猩ĎOɂ遨eƂȂB
	if(depth-shadow_val>ShadowBias)
	{
		//fBt[YFftHg̑fAmbientFɕύX
		pin.Diffuse=float4(DiffuseColor*AmbientLightColor*ShadowColor,Alpha);
		//XyL0Ƃ
		pin.Specular=0;
	}
	float4 color = tex2D(TextureSampler, pin.TexCoord) * pin.Diffuse + float4(pin.Specular.rgb, 0);
	color.rgb = lerp(color.rgb, FogColor, pin.Specular.w);
	return color;
}


float4 PSBasicPixelLightingSd(PixelLightingPSInputSd pin) : COLOR
{
	float3 posToEye = EyePosition - pin.PositionWS.xyz;
	
	float3 N = normalize(pin.NormalWS);
	float3 E = normalize(posToEye);
	
	ColorPair lightResult = ComputePerPixelLights(E, N);
	
	//VhE}bv擾ʒuvZ
	float2 shadow_uv=0.5*pin.Pos_Light.xy/pin.Pos_Light.w+float2(0.5f,0.5f);
	shadow_uv.y=1.0f-shadow_uv.y;
	shadow_uv+=ShadowMapOffset;
	//VhE}bv_̐[x擾
	float shadow_val=tex2D(ShadowSampler,shadow_uv).r;
	//eB
	float depth=pin.Pos_Light.z/pin.Pos_Light.w;
	//͌猩݂̐[x񂪁AVhE}bv̐[x傫ȂA
	//̓VhE}bv`掞ɂ猩[x󂢁猩ĎOɂsNZɏ㏑Ă
	//㏑Ă遨̃sNZ猩ĎOɂ遨eƂȂB
	float4 color;
	if(depth-shadow_val>ShadowBias)
	{
		//fBt[YFftHg̑fAmbientFɕύX
		color=float4(DiffuseColor*AmbientLightColor*ShadowColor,Alpha);
	}
	else
	{
		float4 diffuse = float4(lightResult.Diffuse * pin.Diffuse.rgb, pin.Diffuse.a);
		color = diffuse + float4(lightResult.Specular, 0);
	}
	color.rgb = lerp(color.rgb, FogColor, pin.PositionWS.w);
	
	return color;
}

float4 PSBasicPixelLightingTxSd(PixelLightingPSInputTxSd pin) : COLOR
{
	float3 posToEye = EyePosition - pin.PositionWS.xyz;
	
	float3 N = normalize(pin.NormalWS);
	float3 E = normalize(posToEye);
	
	ColorPair lightResult = ComputePerPixelLights(E, N);
	//VhE}bv擾ʒuvZ
	float2 shadow_uv=0.5*pin.Pos_Light.xy/pin.Pos_Light.w+float2(0.5f,0.5f);
	shadow_uv.y=1.0f-shadow_uv.y;
	shadow_uv+=ShadowMapOffset;
	//VhE}bv_̐[x擾
	float shadow_val=tex2D(ShadowSampler,shadow_uv).r;
	//eB
	float depth=pin.Pos_Light.z/pin.Pos_Light.w;
	//͌猩݂̐[x񂪁AVhE}bv̐[x傫ȂA
	//̓VhE}bv`掞ɂ猩[x󂢁猩ĎOɂsNZɏ㏑Ă
	//㏑Ă遨̃sNZ猩ĎOɂ遨eƂȂB
	float4 color;
	if(depth-shadow_val>ShadowBias)
	{
		//fBt[YFftHg̑fAmbientFɕύX
		pin.Diffuse=float4(DiffuseColor*AmbientLightColor*ShadowColor,Alpha);
		lightResult.Diffuse=1;
		lightResult.Specular=0;
	}
	float4 diffuse = tex2D(TextureSampler, pin.TexCoord) * float4(lightResult.Diffuse * pin.Diffuse.rgb, pin.Diffuse.a);
	color = diffuse + float4(lightResult.Specular, 0);
	
	color.rgb = lerp(color.rgb, FogColor, pin.PositionWS.w);
	return color;
}
//XtBA}bv
float4 PSBasicSpSd(VertexLightingPSInputSpSd pin) : COLOR
{
	//VhE}bv擾ʒuvZ
	float2 shadow_uv=0.5*pin.Pos_Light.xy/pin.Pos_Light.w+float2(0.5f,0.5f);
	shadow_uv.y=1.0f-shadow_uv.y;
	shadow_uv+=ShadowMapOffset;
	//VhE}bv_̐[x擾
	float shadow_val=tex2D(ShadowSampler,shadow_uv).r;
	//eB
	float depth=pin.Pos_Light.z/pin.Pos_Light.w;
	//͌猩݂̐[x񂪁AVhE}bv̐[x傫ȂA
	//̓VhE}bv`掞ɂ猩[x󂢁猩ĎOɂsNZɏ㏑Ă
	//㏑Ă遨̃sNZ猩ĎOɂ遨eƂȂB
	if(depth-shadow_val>ShadowBias)
	{
		//fBt[YFftHg̑fAmbientFɕύX
		pin.Diffuse=float4(DiffuseColor*AmbientLightColor*ShadowColor,Alpha);
		//XyL0Ƃ
		pin.Specular=0;
	}
	float4 color = pin.Diffuse + float4(pin.Specular.rgb, 0);
	color.rgb = lerp(color.rgb, FogColor, pin.Specular.w);
	//XtBA}bvvZ
	float3 N = normalize(pin.NormalWS);
	float2 SphereCoord = float2(N.x*0.5f+0.5f,N.y*0.5f+0.5f);
	if(SphereType==1)
		color*=tex2D(SphereSampler,SphereCoord);//XtBA}bvZ
	else if(SphereType==2)
		color+=tex2D(SphereSampler,SphereCoord);//XtBA}bvZ
	return color;
}


float4 PSBasicTxSpSd(VertexLightingPSInputTxSpSd pin) : COLOR
{
	//VhE}bv擾ʒuvZ
	float2 shadow_uv=0.5*pin.Pos_Light.xy/pin.Pos_Light.w+float2(0.5f,0.5f);
	shadow_uv.y=1.0f-shadow_uv.y;
	shadow_uv+=ShadowMapOffset;
	//VhE}bv_̐[x擾
	float shadow_val=tex2D(ShadowSampler,shadow_uv).r;
	//eB
	float depth=pin.Pos_Light.z/pin.Pos_Light.w;
	//͌猩݂̐[x񂪁AVhE}bv̐[x傫ȂA
	//̓VhE}bv`掞ɂ猩[x󂢁猩ĎOɂsNZɏ㏑Ă
	//㏑Ă遨̃sNZ猩ĎOɂ遨eƂȂB
	if(depth-shadow_val>ShadowBias)
	{
		//fBt[YFftHg̑fAmbientFɕύX
		pin.Diffuse=float4(DiffuseColor*AmbientLightColor*ShadowColor,Alpha);
		//XyL0Ƃ
		pin.Specular=0;
	}
	float4 color = tex2D(TextureSampler, pin.TexCoord) * pin.Diffuse + float4(pin.Specular.rgb, 0);
	color.rgb = lerp(color.rgb, FogColor, pin.Specular.w);
	//XtBA}bvvZ
	float3 N = normalize(pin.NormalWS);
	float2 SphereCoord = float2(N.x*0.5f+0.5f,N.y*0.5f+0.5f);
	if(SphereType==1)
		color*=tex2D(SphereSampler,SphereCoord);//XtBA}bvZ
	else if(SphereType==2)
		color+=tex2D(SphereSampler,SphereCoord);//XtBA}bvZ
	return color;
}


float4 PSBasicPixelLightingSpSd(PixelLightingPSInputSd pin) : COLOR
{
	float3 posToEye = EyePosition - pin.PositionWS.xyz;
	
	float3 N = normalize(pin.NormalWS);
	float3 E = normalize(posToEye);
	
	ColorPair lightResult = ComputePerPixelLights(E, N);

	//VhE}bv擾ʒuvZ
	float2 shadow_uv=0.5*pin.Pos_Light.xy/pin.Pos_Light.w+float2(0.5f,0.5f);
	shadow_uv.y=1.0f-shadow_uv.y;
	shadow_uv+=ShadowMapOffset;
	//VhE}bv_̐[x擾
	float shadow_val=tex2D(ShadowSampler,shadow_uv).r;
	//eB
	float depth=pin.Pos_Light.z/pin.Pos_Light.w;
	//͌猩݂̐[x񂪁AVhE}bv̐[x傫ȂA
	//̓VhE}bv`掞ɂ猩[x󂢁猩ĎOɂsNZɏ㏑Ă
	//㏑Ă遨̃sNZ猩ĎOɂ遨eƂȂB
	float4 color;
	if(depth-shadow_val>ShadowBias)
	{
		//fBt[YFftHg̑fAmbientFɕύX
		pin.Diffuse=float4(DiffuseColor*AmbientLightColor*ShadowColor,Alpha);
		lightResult.Diffuse=1;
		lightResult.Specular=0;
	}
	float4 diffuse = float4(lightResult.Diffuse * pin.Diffuse.rgb, pin.Diffuse.a);
	color = diffuse + float4(lightResult.Specular, 0);
	
	color.rgb = lerp(color.rgb, FogColor, pin.PositionWS.w);
	//XtBA}bvvZ
	float2 SphereCoord = float2(N.x*0.5f+0.5f,N.y*0.5f+0.5f);
	if(SphereType==1)
		color*=tex2D(SphereSampler,SphereCoord);//XtBA}bvZ
	else if(SphereType==2)
		color+=tex2D(SphereSampler,SphereCoord);//XtBA}bvZ
	
	return color;
}


float4 PSBasicPixelLightingTxSpSd(PixelLightingPSInputTxSd pin) : COLOR
{
	float3 posToEye = EyePosition - pin.PositionWS.xyz;
	
	float3 N = normalize(pin.NormalWS);
	float3 E = normalize(posToEye);
	
	ColorPair lightResult = ComputePerPixelLights(E, N);
	
	//VhE}bv擾ʒuvZ
	float2 shadow_uv=0.5*pin.Pos_Light.xy/pin.Pos_Light.w+float2(0.5f,0.5f);
	shadow_uv.y=1.0f-shadow_uv.y;
	shadow_uv+=ShadowMapOffset;
	//VhE}bv_̐[x擾
	float shadow_val=tex2D(ShadowSampler,shadow_uv).r;
	//eB
	float depth=pin.Pos_Light.z/pin.Pos_Light.w;
	//͌猩݂̐[x񂪁AVhE}bv̐[x傫ȂA
	//̓VhE}bv`掞ɂ猩[x󂢁猩ĎOɂsNZɏ㏑Ă
	//㏑Ă遨̃sNZ猩ĎOɂ遨eƂȂB
	float4 color;
	if(depth-shadow_val>ShadowBias)
	{
		//fBt[YFftHg̑fAmbientFɕύX
		//fBt[YFftHg̑fAmbientFɕύX
		pin.Diffuse=float4(DiffuseColor*AmbientLightColor*ShadowColor,Alpha);
		lightResult.Diffuse=1;
		lightResult.Specular=0;
	}
	float4 diffuse = tex2D(TextureSampler, pin.TexCoord) * float4(lightResult.Diffuse * pin.Diffuse.rgb, pin.Diffuse.a);
	color = diffuse + float4(lightResult.Specular, 0);
	
	color.rgb = lerp(color.rgb, FogColor, pin.PositionWS.w);
	//XtBA}bvvZ
	float2 SphereCoord = float2(N.x*0.5f+0.5f,N.y*0.5f+0.5f);
	if(SphereType==1)
		color*=tex2D(SphereSampler,SphereCoord);//XtBA}bvZ
	else if(SphereType==2)
		color+=tex2D(SphereSampler,SphereCoord);//XtBA}bvZ
	
	return color;
}
//XN[
float4 PSBasicScreenSd(VertexLightingPSInputTxSd pin) : COLOR
{
	//VhE}bv擾ʒuvZ
	float2 shadow_uv=0.5*pin.Pos_Light.xy/pin.Pos_Light.w+float2(0.5f,0.5f);
	shadow_uv.y=1.0f-shadow_uv.y;
	shadow_uv+=ShadowMapOffset;
	//VhE}bv_̐[x擾
	float shadow_val=tex2D(ShadowSampler,shadow_uv).r;
	//݂̃sNŽ_̐[xvZ
	float depth=pin.Pos_Light.z/pin.Pos_Light.w;
	//eB
	//͌猩݂̐[x񂪁AVhE}bv̐[x傫ȂA
	//̓VhE}bv`掞ɂ猩[x󂢁猩ĎOɂsNZɏ㏑Ă
	//㏑Ă遨̃sNZ猩ĎOɂ遨eƂȂB
	if(depth-shadow_val>ShadowBias)
	{
		//fBt[YFftHg̑fAmbientFɕύX
		pin.Diffuse=float4(DiffuseColor*AmbientLightColor*ShadowColor,Alpha);
		//XyL0Ƃ
		pin.Specular=0;
	}
	float4 color = tex2D(ScreenSampler, pin.TexCoord) * pin.Diffuse + float4(pin.Specular.rgb, 0);
	color.rgb = lerp(color.rgb, FogColor, pin.Specular.w);
	return color;
}

float4 PSBasicPixelLightingScreenSd(PixelLightingPSInputTxSd pin) : COLOR
{
	float3 posToEye = EyePosition - pin.PositionWS.xyz;
	
	float3 N = normalize(pin.NormalWS);
	float3 E = normalize(posToEye);
	
	ColorPair lightResult = ComputePerPixelLights(E, N);
	
	//VhE}bv擾ʒuvZ
	float2 shadow_uv=0.5*pin.Pos_Light.xy/pin.Pos_Light.w+float2(0.5f,0.5f);
	shadow_uv.y=1.0f-shadow_uv.y;
	shadow_uv+=ShadowMapOffset;
	//VhE}bv_̐[x擾
	float shadow_val=tex2D(ShadowSampler,shadow_uv).r;
	//eB
	float depth=pin.Pos_Light.z/pin.Pos_Light.w;
	//͌猩݂̐[x񂪁AVhE}bv̐[x傫ȂA
	//̓VhE}bv`掞ɂ猩[x󂢁猩ĎOɂsNZɏ㏑Ă
	//㏑Ă遨̃sNZ猩ĎOɂ遨eƂȂB
	float4 color;
	if(depth-shadow_val>ShadowBias)
	{
		//fBt[YFftHg̑fAmbientFɕύX
		pin.Diffuse=float4(DiffuseColor*AmbientLightColor*ShadowColor,Alpha);
		lightResult.Diffuse=1;
		lightResult.Specular=0;
	}
	float4 diffuse = tex2D(ScreenSampler, pin.TexCoord) *float4(lightResult.Diffuse * pin.Diffuse.rgb, pin.Diffuse.a);
	color = diffuse + float4(lightResult.Specular, 0);
	
	color.rgb = lerp(color.rgb, FogColor, pin.PositionWS.w);
	
	return color;
}

//-----------------------------------------------------------------------------
// VF[_eNjbN`
//-----------------------------------------------------------------------------

int ShaderIndex = 0;


VertexShader VSArray[26] =
{
	compile vs_1_1 VSBasic(),
	compile vs_1_1 VSBasicVc(),
	compile vs_1_1 VSBasicTx(),
	compile vs_1_1 VSBasicTxVc(),

	compile vs_1_1 VSBasicNm(),
	compile vs_1_1 VSBasicNmVc(),
	compile vs_1_1 VSBasicNmTx(),
	compile vs_1_1 VSBasicNmTxVc(),
	
	compile vs_1_1 VSBasicPixelLightingNm(),
	compile vs_1_1 VSBasicPixelLightingNmVc(),
	compile vs_1_1 VSBasicPixelLightingNmTx(),
	compile vs_1_1 VSBasicPixelLightingNmTxVc(),
	
	//XtBA}bv
	compile vs_1_1 VSBasicNmSp(),
	compile vs_1_1 VSBasicNmVcSp(),
	compile vs_1_1 VSBasicNmTxSp(),
	compile vs_1_1 VSBasicNmTxVcSp(),
	
	compile vs_1_1 VSBasicPixelLightingNm(),
	compile vs_1_1 VSBasicPixelLightingNmVc(),
	compile vs_1_1 VSBasicPixelLightingNmTx(),
	compile vs_1_1 VSBasicPixelLightingNmTxVc(),
	
	//XN[
	compile vs_1_1 VSBasicTx(),
	compile vs_1_1 VSBasicTxVc(),
	compile vs_1_1 VSBasicNmTx(),
	compile vs_1_1 VSBasicNmTxVc(),
	
	compile vs_1_1 VSBasicPixelLightingNmTx(),
	compile vs_1_1 VSBasicPixelLightingNmTxVc(),
	
};


PixelShader PSArray[26] =
{
	compile ps_1_1 PSBasic(),
	compile ps_1_1 PSBasic(),
	compile ps_1_1 PSBasicTx(),
	compile ps_1_1 PSBasicTx(),
	compile ps_1_1 PSBasic(),
	compile ps_1_1 PSBasic(),
	compile ps_1_1 PSBasicTx(),
	compile ps_1_1 PSBasicTx(),
	
	compile ps_2_0 PSBasicPixelLighting(),
	compile ps_2_0 PSBasicPixelLighting(),
	compile ps_2_0 PSBasicPixelLightingTx(),
	compile ps_2_0 PSBasicPixelLightingTx(),
	
	//XtBA}bv
	compile ps_2_0 PSBasicSp(),
	compile ps_2_0 PSBasicSp(),
	compile ps_2_0 PSBasicTxSp(),
	compile ps_2_0 PSBasicTxSp(),
	
	compile ps_3_0 PSBasicPixelLightingSp(),
	compile ps_3_0 PSBasicPixelLightingSp(),
	compile ps_3_0 PSBasicPixelLightingTxSp(),
	compile ps_3_0 PSBasicPixelLightingTxSp(),
	
	//XN[
	compile ps_2_0 PSBasicScreen(),
	compile ps_2_0 PSBasicScreen(),
	compile ps_2_0 PSBasicScreen(),
	compile ps_2_0 PSBasicScreen(),
	
	compile ps_2_0 PSBasicPixelLightingScreen(),
	compile ps_2_0 PSBasicPixelLightingScreen(),
	
};

VertexShader VSShadowMapArray[26] =
{
	compile vs_3_0 VSShadowMap(),
	compile vs_3_0 VSShadowMap(),
	compile vs_3_0 VSShadowMapTx(),
	compile vs_3_0 VSShadowMapTx(),
	
	compile vs_3_0 VSShadowMap(),
	compile vs_3_0 VSShadowMap(),
	compile vs_3_0 VSShadowMapTx(),
	compile vs_3_0 VSShadowMapTx(),
	
	compile vs_3_0 VSShadowMap(),
	compile vs_3_0 VSShadowMap(),
	compile vs_3_0 VSShadowMapTx(),
	compile vs_3_0 VSShadowMapTx(),
	
	//XtBA}bv
	compile vs_3_0 VSShadowMapSp(),
	compile vs_3_0 VSShadowMapSp(),
	compile vs_3_0 VSShadowMapTxSp(),
	compile vs_3_0 VSShadowMapTxSp(),
	
	compile vs_3_0 VSShadowMapSp(),
	compile vs_3_0 VSShadowMapSp(),
	compile vs_3_0 VSShadowMapTxSp(),
	compile vs_3_0 VSShadowMapTxSp(),
	
	//XN[
	compile vs_3_0 VSShadowMapTx(),
	compile vs_3_0 VSShadowMapTx(),
	compile vs_3_0 VSShadowMapTx(),
	compile vs_3_0 VSShadowMapTx(),
	
	compile vs_3_0 VSShadowMapTx(),
	compile vs_3_0 VSShadowMapTx(),
	
};


PixelShader PSShadowMapArray[26] =
{
	compile ps_3_0 PSShadowMap(),
	compile ps_3_0 PSShadowMap(),
	compile ps_3_0 PSShadowMapTx(),
	compile ps_3_0 PSShadowMapTx(),
	
	compile ps_3_0 PSShadowMap(),
	compile ps_3_0 PSShadowMap(),
	compile ps_3_0 PSShadowMapTx(),
	compile ps_3_0 PSShadowMapTx(),
	
	compile ps_3_0 PSShadowMap(),
	compile ps_3_0 PSShadowMap(),
	compile ps_3_0 PSShadowMapTx(),
	compile ps_3_0 PSShadowMapTx(),
	
	//XtBA}bv
	compile ps_3_0 PSShadowMapSp(),
	compile ps_3_0 PSShadowMapSp(),
	compile ps_3_0 PSShadowMapTxSp(),
	compile ps_3_0 PSShadowMapTxSp(),
	
	compile ps_3_0 PSShadowMapSp(),
	compile ps_3_0 PSShadowMapSp(),
	compile ps_3_0 PSShadowMapTxSp(),
	compile ps_3_0 PSShadowMapTxSp(),
	
	//XN[
	compile ps_3_0 PSShadowMapTx(),
	compile ps_3_0 PSShadowMapTx(),
	compile ps_3_0 PSShadowMapTx(),
	compile ps_3_0 PSShadowMapTx(),
	
	compile ps_3_0 PSShadowMapTx(),
	compile ps_3_0 PSShadowMapTx(),
	
};

VertexShader VSWithShadowArray[26] =
{
	compile vs_3_0 VSBasicSd(),
	compile vs_3_0 VSBasicVcSd(),
	compile vs_3_0 VSBasicTxSd(),
	compile vs_3_0 VSBasicTxVcSd(),

	compile vs_3_0 VSBasicNmSd(),
	compile vs_3_0 VSBasicNmVcSd(),
	compile vs_3_0 VSBasicNmTxSd(),
	compile vs_3_0 VSBasicNmTxVcSd(),
	
	compile vs_3_0 VSBasicPixelLightingNmSd(),
	compile vs_3_0 VSBasicPixelLightingNmVcSd(),
	compile vs_3_0 VSBasicPixelLightingNmTxSd(),
	compile vs_3_0 VSBasicPixelLightingNmTxVcSd(),
	
	//XtBA}bv
	compile vs_3_0 VSBasicNmSpSd(),
	compile vs_3_0 VSBasicNmVcSpSd(),
	compile vs_3_0 VSBasicNmTxSpSd(),
	compile vs_3_0 VSBasicNmTxVcSpSd(),
	
	compile vs_3_0 VSBasicPixelLightingNmSd(),
	compile vs_3_0 VSBasicPixelLightingNmVcSd(),
	compile vs_3_0 VSBasicPixelLightingNmTxSd(),
	compile vs_3_0 VSBasicPixelLightingNmTxVcSd(),
	
	//XN[
	compile vs_3_0 VSBasicTxSd(),
	compile vs_3_0 VSBasicTxVcSd(),
	compile vs_3_0 VSBasicNmTxSd(),
	compile vs_3_0 VSBasicNmTxVcSd(),
	
	compile vs_3_0 VSBasicPixelLightingNmTxSd(),
	compile vs_3_0 VSBasicPixelLightingNmTxVcSd(),
	
};


PixelShader PSWithShadowArray[26] =
{
	compile ps_3_0 PSBasicSd(),
	compile ps_3_0 PSBasicSd(),
	compile ps_3_0 PSBasicTxSd(),
	compile ps_3_0 PSBasicTxSd(),
	
	compile ps_3_0 PSBasicSd(),
	compile ps_3_0 PSBasicSd(),
	compile ps_3_0 PSBasicTxSd(),
	compile ps_3_0 PSBasicTxSd(),
	
	compile ps_3_0 PSBasicPixelLightingSd(),
	compile ps_3_0 PSBasicPixelLightingSd(),
	compile ps_3_0 PSBasicPixelLightingTxSd(),
	compile ps_3_0 PSBasicPixelLightingTxSd(),
	
	//XtBA}bv
	compile ps_3_0 PSBasicSpSd(),
	compile ps_3_0 PSBasicSpSd(),
	compile ps_3_0 PSBasicTxSpSd(),
	compile ps_3_0 PSBasicTxSpSd(),
	
	compile ps_3_0 PSBasicPixelLightingSpSd(),
	compile ps_3_0 PSBasicPixelLightingSpSd(),
	compile ps_3_0 PSBasicPixelLightingTxSpSd(),
	compile ps_3_0 PSBasicPixelLightingTxSpSd(),
	
	//XN[
	compile ps_3_0 PSBasicScreenSd(),
	compile ps_3_0 PSBasicScreenSd(),
	compile ps_3_0 PSBasicScreenSd(),
	compile ps_3_0 PSBasicScreenSd(),
	
	compile ps_3_0 PSBasicPixelLightingScreenSd(),
	compile ps_3_0 PSBasicPixelLightingScreenSd(),
	
};

Technique BasicEffect
{
	Pass
	{
		VertexShader = (VSArray[ShaderIndex]);
		PixelShader	 = (PSArray[ShaderIndex]);
	}
}
Technique BasicWithShadow
{
	Pass
	{
		VertexShader = (VSWithShadowArray[ShaderIndex]);
		PixelShader	 = (PSWithShadowArray[ShaderIndex]);
	}
}


Technique ShadowMap
{
	Pass
	{
		VertexShader = (VSShadowMapArray[ShaderIndex]);
		PixelShader	 = (PSShadowMapArray[ShaderIndex]);
	}
}
