#region Using Xe[gg

using System;
using System.Collections.Generic;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Content;
using BulletX;
using BulletX.BulletCollision.CollisionDispatch;
using MikuMikuDance.XNA.Debug.Utils;
using Microsoft.Xna.Framework.Input;

#endregion

namespace MikuMikuDance.XNA.Debug
{
    /// <summary>
    /// fobOp̃OtBNXRegi[ׂ̃fobOp}l[W[(ɓ Y(HN:Ђ˂)AEBt)
    /// </summary>
    public class DebugManager : DefaultDebugDraw
    {
        // ͏pϐ
        // t[̃Q[pbhƃL[̓Xe[g
        GamePadState padState;
        KeyboardState keyState;

        // Ot[̃Q[pbhƃL[̓Xe[g
        GamePadState prevPadState;
        KeyboardState prevKeyState;

        MikuMikuDanceXNA m_mmdx;
        #region vpeB
        /// <summary>
        /// FPS̕\/\ɎgL[
        /// </summary>
        public Keys FPSKey = Keys.A;
        /// <summary>
        /// ^C[[̕\/\ɎgL[
        /// </summary>
        public Keys TimeRulerKey = Keys.B;
        /// <summary>
        /// ^C[[O̕\/\ɎgL[
        /// </summary>
        public Keys TimeLogKey = Keys.X;
        /// <summary>
        /// FPS̕\/\Ɏg{^
        /// </summary>
        public Buttons FPSButton = Buttons.A;
        /// <summary>
        /// ^C[[̕\/\Ɏg{^
        /// </summary>
        public Buttons TimeRulerButton = Buttons.B;
        /// <summary>
        /// ^C[[O̕\/\Ɏg{^
        /// </summary>
        public Buttons TimeLogButton = Buttons.X;

        /// <summary>
        /// fobOpSpriteBatch̎擾
        /// </summary>
        public SpriteBatch SpriteBatch { get; private set; }

        /// <summary>
        /// eNX`̎擾
        /// </summary>
        public Texture2D WhiteTexture { get; private set; }

        /// <summary>
        /// fobOptHg
        /// </summary>
        public SpriteFont DebugFont { get; private set; }

        /// <summary>
        /// FPSCounter
        /// </summary>
        public FpsCounter FPS { get; private set; }
        /// <summary>
        /// TimeRular
        /// </summary>
        public DefaultTimeRuler TimeRuler { get; private set; }
        /// <summary>
        /// DebugCommandUI
        /// </summary>
        public DebugCommandUI DebugCommandUI { get; private set; }
        /// <summary>
        /// ̂`悷邩ǂ
        /// </summary>
        public bool DrawRigids { get; set; }
        /// <summary>
        /// DebugDraw̐`悷邩ǂ
        /// </summary>
        public bool DrawMessage { get; set; }
        #endregion

        #region 
        /// <summary>
        /// RXgN^
        /// </summary>
        /// <param name="Game">Q[IuWFNg</param>
        /// <param name="mmdx">MikuMikuDanceXNA</param>
        /// <param name="debugFont">fobOptHg</param>
        /// <param name="device">GraphicsDevice</param>
        /// <param name="world">BulletCollisionWorld</param>
        public DebugManager(Game Game, MikuMikuDanceXNA mmdx, SpriteFont debugFont, GraphicsDevice device, CollisionWorld world)
            : this(Game, mmdx, debugFont, device, world, KeyboardType.Japanese) { }

        /// <summary>
        /// RXgN^
        /// </summary>
        /// <param name="Game">Q[IuWFNg</param>
        /// <param name="mmdx">MikuMikuDanceXNA</param>
        /// <param name="debugFont">fobOptHg</param>
        /// <param name="device">GraphicsDevice</param>
        /// <param name="world">BulletCollisionWorld</param>
        /// <param name="keytype">L[{[hCAEg</param>
        public DebugManager(Game Game, MikuMikuDanceXNA mmdx, SpriteFont debugFont, GraphicsDevice device, CollisionWorld world, KeyboardType keytype)
            : base(device, world)
        {
            // T[rXƂēo^
            Game.Services.AddService(typeof(DebugManager), this);
            // fobOpReg̓ǂݍ
            SpriteBatch = new SpriteBatch(device);

            // eNX`̐
            WhiteTexture = new Texture2D(device, 1, 1);
            Color[] whitePixels = new Color[] { Color.White };
            WhiteTexture.SetData<Color>(whitePixels);

            // fobO}R}hUȈƒǉ
            DebugCommandUI = new DebugCommandUI(Game, keytype);

            // fobOR}hUIŏʂɕ\ׂDrawOrderύX
            DebugCommandUI.DrawOrder = 100;
            Game.Components.Add(DebugCommandUI);
            //FPSJE^̍쐬
            FPS = new FpsCounter(Game);
            Game.Components.Add(FPS);
            FPS.DrawOrder = 99;
            FPS.Visible = true;
            //TimeRular̍쐬
            TimeRuler = new DefaultTimeRuler(Game);
            TimeRuler.Visible = true;
            TimeRuler.ShowLog = true;
            TimeRuler.DrawOrder = 99;
            Game.Components.Add(TimeRuler);
            //ZVXeɃtbN
            CollisionWorld.Profiler = TimeRuler;
            
            DebugFont = debugFont;

            DrawMessage = true;
            m_mmdx = mmdx;
        }

        #endregion
        /// <summary>
        /// ͏
        /// </summary>
        public void HandleInput()
        {
            padState = GamePad.GetState(PlayerIndex.One);
            keyState = Keyboard.GetState();

            // A{^AAL[FPSJE^[̕\A\
            if (IsButtonOrKeyPressed(FPSButton, FPSKey))
            {
                FPS.Visible = !FPS.Visible;
            }

            // B{^ABL[TimeRuler̕\A\
            if (IsButtonOrKeyPressed(TimeRulerButton, TimeRulerKey))
            {
                TimeRuler.Visible = !TimeRuler.Visible;
            }

            // X{^AXL[TimeRulerO̕\A\
            if (IsButtonOrKeyPressed(TimeLogButton, TimeLogKey))
            {
                TimeRuler.Visible = true;
                TimeRuler.ShowLog = !TimeRuler.ShowLog;
            }
            prevKeyState = keyState;
            prevPadState = padState;
        }
        /// <summary>
        /// w肳ꂽ{^A܂̓L[͂?
        /// </summary>
        /// <param name="button">{^</param>
        /// <param name="key">L[</param>
        /// <returns>͂ꍇtrueԂ</returns>
        bool IsButtonOrKeyPressed(Buttons button, Keys key)
        {
            return (padState.IsButtonDown(button) && prevPadState.IsButtonUp(button)) ||
                (keyState.IsKeyDown(key) && prevKeyState.IsKeyUp(key));
        }

        /// <summary>
        /// `
        /// </summary>
        /// <param name="GraphicsDevice">GraphicsDevice</param>
        public override void Draw(GraphicsDevice GraphicsDevice)
        {
            if (DrawMessage)
            {
                // fobO}l[W̃tHgSpriteBatchg킹Ă炤
                SpriteFont font = this.DebugFont;
                SpriteBatch sb = this.SpriteBatch;

                sb.Begin();

                // g̕\
                string message =
                    "A Button, A key: Show/Hide FPS Counter\n" +
                    "B Button, B key: Show/Hide Time Ruler\n" +
                    "X Button, X key: Show/Hide Time Ruler Log\n" +
                    "Tab key: Open debug command UI";
                Vector2 size = font.MeasureString(message);
                Layout layout = new Layout(GraphicsDevice.Viewport);

                float margin = font.LineSpacing;
                Rectangle rc = new Rectangle(0, 0,
                                        (int)(size.X + margin),
                                        (int)(size.Y + margin));

                // wi̔zuʒuvZĕ`
                rc = layout.Place(rc, 0.01f, 0.01f, Alignment.TopRight);
                sb.Draw(this.WhiteTexture, rc, new Color(0, 0, 0, 128));

                // gwi̐^񒆂ɔzuĕ`
                layout.ClientArea = rc;
                Vector2 pos = layout.Place(size, 0, 0, Alignment.Center);
                sb.DrawString(font, message, pos, Color.White);
                sb.End();
                GraphicsDevice.RenderState.DepthBufferEnable = true;
                GraphicsDevice.RenderState.AlphaTestEnable = true;
                GraphicsDevice.RenderState.ReferenceAlpha = 1;
                GraphicsDevice.RenderState.AlphaFunction = CompareFunction.GreaterEqual;
                GraphicsDevice.RenderState.DepthBufferEnable = true;
                GraphicsDevice.SamplerStates[0].AddressU = TextureAddressMode.Wrap;
                GraphicsDevice.SamplerStates[0].AddressV = TextureAddressMode.Wrap;
            }
            if (DrawRigids)
            {
                View = m_mmdx.Camera.GetViewMatrix();
                Proj = m_mmdx.Camera.GetProjectionMatrix(GraphicsDevice);
                base.Draw(GraphicsDevice);
            }
        }
    }
}