﻿using Microsoft.Xna.Framework;
using DWORD = System.UInt32;

namespace MikuMikuDance.XNA.Motion.MotionData
{
    /// <summary>
    /// カメラモーションデータ
    /// </summary>
    public struct MMDCameraMotion
    {
        /// <summary>
        /// フレーム番号
        /// </summary>
        public DWORD FrameNo;
        /// <summary>
        /// 距離
        /// </summary>
        public float Length;
        /// <summary>
        /// 位置
        /// </summary>
        public Vector3 Location;
        /// <summary>
        /// 回転
        /// </summary>
        public Quaternion Quatanion;
        /// <summary>
        /// 補完用曲線
        /// </summary>
        /// <remarks>順にX,Y,Z,回転,距離,視野角</remarks>
        public BezierCurve[] Curve;
        /// <summary>
        /// 視野角
        /// </summary>
        public float ViewAngle;
    }
}
