using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;
using MikuMikuDance.XNA;
using MikuMikuDance.XNA.Model;
using MikuMikuDance.XNA.Motion;
using MikuMikuDance.XNA.Debug;
using MikuMikuDance.XNA.Model.ModelData;
using MikuMikuDance.XNA.MultiThread;

namespace MikuMikuDanceXNADemo8
{
    
    /// <summary>
    /// ̃Tvł
    /// Eɓ Yꎁ蒸AMMDXpɒDebugVXe̎gɂ
    /// E}`XbhNX
    /// ɂĐ܂
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        //MikuMikuDance for XNA
        MikuMikuDanceXNA mmd;
        //MMDff[^
        MMDModel model;
        //MMD[Vf[^
        MMDMotion motion;
        //fobO}l[W
        DebugManager debugManager;
        //fobOptHg
        SpriteFont debugFont;
        //Xbh}l[W
        ThreadManager threadManager;
        //eXgXbh
        TestThread test;

        public Game1()
        {
            Content.RootDirectory = "Content";
            graphics = new GraphicsDeviceManager(this);
            //foCXMMDX̕Kv𖞂Ă邩`FbN
            MikuMikuDanceXNA.InitialSetup(this, graphics, true);
        }

        protected override void Initialize()
        {
            base.Initialize();
        }

        /// <summary>
        /// LoadContent֐
        /// e탍[h͂Ń[hsĂƗǂ
        /// </summary>
        protected override void LoadContent()
        {
            //Xbh}l[W̍쐬
            threadManager = new ThreadManager();
            //MikuMikuDanceXNA쐬āAɃXbh}l[W˂(Z}`Xbh܂)
            mmd = new MikuMikuDanceXNA(this, threadManager);
            //vWFNgContentɒǉĂMiku.pmdf[h
            //[hMikuMikuDanceXNA.LoadModel֐ōs
            //(ff[^͂ɂ܂肨؂肵܂B̃ft@CMITCZXKOł)
            model = mmd.LoadModel("Miku", this, QuatTransform.Identity);
            //ContentɒǉĂTrueMyHeart.vmd[V[h
            //[hMikuMikuDanceXNA.LoadMotion֐ōs
            motion = mmd.LoadMotion("TrueMyHeart");
            //f̃vC[Ăяo
            //[V0ԃgbNɃZbg
            model.Player.SetMotion(0, motion, true);
            //fobOp̃tHg̃[h
            debugFont = Content.Load<SpriteFont>("DebugFont");
            //fobO}l[W̍쐬
            debugManager = new DebugManager(this, mmd, debugFont, this.GraphicsDevice, mmd.Physic);
            //̂`悵ꍇDrawRigidstrueƂ
            //debugManager.DrawRigids = true;
            //eXgXbh̍쐬
            //XBox̓n[hEFAXbhԍw肷Kv
            //XBox̃n[hEFAXbh6AA0Ԃ2ԂXNAA5ԂBulletXgpȂ̂1,3,4Ԃ̂ǂꂩw肷B
#if XBOX
            test = new TestThread(4, this, threadManager, debugManager.TimeRuler);
#else
            test = new TestThread(this, threadManager, debugManager.TimeRuler);
#endif
        }

        /// <summary>
        /// UnloadContent֐
        /// A[hKvȕ͂ŃA[hs
        /// </summary>
        protected override void UnloadContent()
        {
        }

        /// <summary>
        /// Abvf[g֐
        /// t[`ȊÕR[hɋLq
        /// </summary>
        /// <param name="gameTime">݂̎Ԃ̃XibvVbg\IuWFNg</param>
        protected override void Update(GameTime gameTime)
        {
            //TimeRularɊJnt[`
            debugManager.TimeRuler.StartFrame();
            //Xbhɂ񓯊Jn
            threadManager.StartFrame(gameTime);
            //Updateg̊Jn
            debugManager.TimeRuler.BeginMark("Update", Color.Blue);
            //XBoxRg[[Back{^I
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();
            //L[{[hEscL[I
            if (Keyboard.GetState().IsKeyDown(Keys.Escape))
                this.Exit();
            //debugCommand\ĂȂƂ
            if (!debugManager.DebugCommandUI.Focused)
            {
                //G^[L[orA{^Ƃ
                if (Keyboard.GetState().IsKeyDown(Keys.Enter) || GamePad.GetState(PlayerIndex.One).Buttons.Start == ButtonState.Pressed)
                {
                    //ݍĐłȂ
                    if (!model.Player.IsPlay(0))
                    {
                        //0ԃgbNɃZbgĂ郂[VZbg
                        model.Player.Reset(0);
                        //0ԃgbNɃZbgĂ郂[VĐ
                        model.Player.Start(0, false);
                    }
                }
                //fobO}l[W[̃L[͔
                debugManager.HandleInput();
            }
            //f̍ĐDrawableGameComponentpĂ邽
            //XNAɂ莩ŏs

            //XNAUpdates
            base.Update(gameTime);
            //Updateg̏I
            debugManager.TimeRuler.EndMark("Update");
        }
        
        /// <summary>
        /// Draw֐
        /// t[`R[hɋLq
        /// </summary>
        /// <param name="gameTime">݂̎Ԃ̃XibvVbg\IuWFNg</param>
        protected override void Draw(GameTime gameTime)
        {
            debugManager.TimeRuler.BeginMark("Draw", Color.Yellow);
            //ʂCornflowerBlueFŏ
            GraphicsDevice.Clear(Color.CornflowerBlue);

            //fDrawableGameComponentpĂ邽
            //XNAɂ莩ŕ`悳

            //XNADraws
            base.Draw(gameTime);
            //fobO̕`
            debugManager.Draw(this.GraphicsDevice);
            
            debugManager.TimeRuler.EndMark("Draw");
        }
        protected override void EndDraw()
        {
            base.EndDraw();
            //`揈IɃXbh𓯊
            threadManager.Synchronize();
        }
        protected override void Dispose(bool disposing)
        {
            if (threadManager != null)
            {
                //Xbh̏Iyєjs
                threadManager.Dispose();
                threadManager = null;
            }
            base.Dispose(disposing);
        }
    }
}
