﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework.Input;

namespace MikuMikuDance.XNA.Debug
{
    class JapaneseKeyboardUtils : KeyboardUtils
    {
        /// <summary>
        /// 英字以外のキーの文字マップの初期化
        /// </summary>
        protected override void InitializeKeyMap()
        {
            // 日本語キーボードの上から1列目
            AddKeyMap(Keys.D1, "1!");
            AddKeyMap(Keys.D2, "2\"");
            AddKeyMap(Keys.D3, "3#");
            AddKeyMap(Keys.D4, "4$");
            AddKeyMap(Keys.D5, "5%");
            AddKeyMap(Keys.D6, "6&");
            AddKeyMap(Keys.D7, "7'");
            AddKeyMap(Keys.D8, "8(");
            AddKeyMap(Keys.D9, "9)");
            AddKeyMap(Keys.D0, "0");
            AddKeyMap(Keys.OemMinus, "-=");
            AddKeyMap(Keys.OemQuotes, "^~");
            AddKeyMap(Keys.OemPipe, "\\|");
            
            // 日本語キーボードの上から2列目
            AddKeyMap(Keys.OemTilde, "@`");
            AddKeyMap(Keys.OemOpenBrackets, "[{");
            
            // 日本語キーボードの上から3列目
            AddKeyMap(Keys.OemPlus, ";+");
            AddKeyMap(Keys.OemSemicolon, ":*");
            AddKeyMap(Keys.OemCloseBrackets, "]}");
            
            
            //日本語キーボードの上から4列目
            AddKeyMap(Keys.OemComma, ",<");
            AddKeyMap(Keys.OemPeriod, ".>");
            AddKeyMap(Keys.OemQuestion, "/?");
            AddKeyMap(Keys.OemBackslash, "\\_");

            // 日本語キーボードのキーパッドのキー
            AddKeyMap(Keys.NumPad1, "1");
            AddKeyMap(Keys.NumPad2, "2");
            AddKeyMap(Keys.NumPad3, "3");
            AddKeyMap(Keys.NumPad4, "4");
            AddKeyMap(Keys.NumPad5, "5");
            AddKeyMap(Keys.NumPad6, "6");
            AddKeyMap(Keys.NumPad7, "7");
            AddKeyMap(Keys.NumPad8, "8");
            AddKeyMap(Keys.NumPad9, "9");
            AddKeyMap(Keys.NumPad0, "0");
            AddKeyMap(Keys.Add, "+");
            AddKeyMap(Keys.Divide, "/");
            AddKeyMap(Keys.Multiply, "*");
            AddKeyMap(Keys.Subtract, "-");
            AddKeyMap(Keys.Decimal, ".");
        }
    }
}
