using BulletX.LinerMath;
using MikuMikuDance.XNA.Model.ModelData;
using System.Threading;
using System;
using MikuMikuDance.XNA.MultiThread;

namespace MikuMikuDance.XNA.Model
{
    /// <summary>
    /// MikuMikuDancepMotionState
    /// </summary>
    public class MMDMotionState : IMotionState, IDisposable
    {
        /// <summary>
        /// graphicsWorldTransform
        /// </summary>
        public btTransform GraphicsWorldTrans { get { return m_thread == null ? m_graphicsWorldTrans[0] : m_graphicsWorldTrans[m_thread.OutThread]; } }
        btTransform[] m_graphicsWorldTrans;
        btTransform m_centerOfMassOffset;
        btTransform m_startWorldTrans;
        MMDRigid m_rigid;
        Microsoft.Xna.Framework.Matrix m_rigidBias;
        MMDModel m_model;
        PhysicsThread m_thread;
        //֘A{[ԍ擾Ă
        ushort    RelatedBone;
        /// <summary>
        /// [U[f[^
        /// </summary>
        public object UserData { get; set; }
        /// <summary>
        /// ftHgRXgN^
        /// </summary>
        /// <param name="rigid">MMD̃f[^</param>
        /// <param name="Model">MMDff[^</param>
        /// <param name="thread">GWpXbh</param>
        public MMDMotionState(MMDRigid rigid, MMDModel Model, PhysicsThread thread)
        {
           UserData = null;
            m_rigid = rigid;
            m_thread = thread;
            //̎pvZ
            Microsoft.Xna.Framework.Matrix startTransform;
            if (rigid.RelatedBoneIndex != 0xffff)
                startTransform = Model.BoneManager.Bones[rigid.RelatedBoneIndex].WorldTransform.CreateMatrix();
            else
            {
                if (Model.BoneManager.ContainsBone("Z^["))
                    startTransform = Model.BoneManager.Bones[Model.BoneManager.IndexOf("Z^[")].WorldTransform.CreateMatrix();
                else
                    startTransform = Microsoft.Xna.Framework.Matrix.Identity;
            }
            //{[ƍ̂Ƃ̃YvZ
            Microsoft.Xna.Framework.Matrix RigidBias = CreateRigidBias(rigid);
            //pvZ
            startTransform = RigidBias * startTransform * Model.Transform.CreateMatrix();
            //̎pMotionStateɐݒ
            btTransform startTrans = new btTransform(ref startTransform);
            m_graphicsWorldTrans = new btTransform[thread != null ? 2 : 1];
            m_graphicsWorldTrans[0] = startTrans;
            if (thread != null)
                m_graphicsWorldTrans[1] = startTrans;
            m_centerOfMassOffset = btTransform.Identity;
            m_startWorldTrans = startTrans;
            //ꂩ̌vZ悤Ɋm
            m_rigidBias = RigidBias;
            RelatedBone = rigid.RelatedBoneIndex;
            m_model = Model;
        }
        //graphicsWorldTrans̍XV
        internal void Flush(bool reset)
        {
            if (RelatedBone >= m_model.BoneManager.Bones.Length)
                return;
            if (m_rigid.Type == 0 || reset)
            {
                Microsoft.Xna.Framework.Matrix temp, temp2, temp3=m_model.Transform.CreateMatrix();
                temp = m_rigidBias * m_model.BoneManager.Bones[RelatedBone].WorldTransform.CreateMatrix();
                Microsoft.Xna.Framework.Matrix.Multiply(ref temp, ref temp3, out temp2);
                if (!reset)
                    m_graphicsWorldTrans[m_thread != null ? m_thread.OutThread : 0] = new btTransform(ref temp2);
                else
                {
                    m_graphicsWorldTrans[0] = new btTransform(ref temp2);
                    if (m_thread != null)
                        m_graphicsWorldTrans[1] = m_graphicsWorldTrans[0];
                }
            }
            else
            {
                Microsoft.Xna.Framework.Matrix RigidPos;
                m_graphicsWorldTrans[m_thread != null ? m_thread.OutThread : 0].getXNAMatrix(out RigidPos);
                
                Microsoft.Xna.Framework.Matrix temp1, temp2, temp3;
                Microsoft.Xna.Framework.Matrix.Invert(ref m_rigidBias, out temp1);
                Microsoft.Xna.Framework.Matrix.Multiply(ref temp1, ref RigidPos, out temp2);
                temp1 = Microsoft.Xna.Framework.Matrix.Invert(m_model.Transform.CreateMatrix());
                Microsoft.Xna.Framework.Matrix.Multiply(ref temp2, ref temp1, out temp3);
                m_model.BoneManager.Bones[RelatedBone].WorldTransform = QuatTransform.FromMatrix(temp3);

            }

        }

        ///synchronizes world transform from user to physics
	    public virtual void	getWorldTransform(out btTransform centerOfMassWorldTrans ) 
	    {
                centerOfMassWorldTrans = m_centerOfMassOffset.inverse() * m_graphicsWorldTrans[m_thread!=null?m_thread.OnThread:0];
            
	    }

	    ///synchronizes world transform from physics to user
	    ///Bullet only calls the update of worldtransform for active objects
        public virtual void setWorldTransform(btTransform centerOfMassWorldTrans)
        {
            m_graphicsWorldTrans[m_thread != null ? m_thread.OnThread : 0] = centerOfMassWorldTrans * m_centerOfMassOffset;

        }
        Microsoft.Xna.Framework.Matrix CreateRigidBias(MMDRigid rigid)
        {
            return Microsoft.Xna.Framework.Matrix.CreateFromYawPitchRoll(rigid.Rotation[1], rigid.Rotation[0], rigid.Rotation[2])
                * Microsoft.Xna.Framework.Matrix.CreateTranslation(rigid.Position[0], rigid.Position[1], rigid.Position[2]);
        }



        #region IDisposable o
        /// <summary>
        /// j
        /// </summary>
        public void Dispose()
        {
            this.m_model = null;
            this.m_thread = null;
        }

        #endregion
    }
}