﻿using Microsoft.Xna.Framework;
using System;

namespace MikuMikuDance.XNA.Motion
{
    /// <summary>
    /// ベイク済みモーションの終了時コールバック用デリゲート
    /// </summary>
    /// <param name="sender">送信元</param>
    /// <param name="TrackNum">トラック番号</param>
    public delegate void BakedMotionEndDelegate(MMDBakedMotion sender, int TrackNum);
    /// <summary>
    /// ベイク済みモーションデータ
    /// </summary>
    public class MMDBakedMotion
    {
        /// <summary>
        /// ベイク済みポーズ
        /// </summary>
        /// <remarks>フレーム番号ごとにボーンデータが並んでいる</remarks>
        public BakedBoneData[] Poses;
        /// <summary>
        /// ボーン数
        /// </summary>
        public int NumBone;
        /// <summary>
        /// ベイク済み表情
        /// </summary>
        /// <remarks>フレーム番号ごとに表情が並んでいる</remarks>
        public Vector4[] Faces;
        /// <summary>
        /// 表情数
        /// </summary>
        public int NumFace;
        /// <summary>
        /// ベイクに使用したモデル名
        /// </summary>
        /// <remarks>xmlで指定したファイルパスがそのまま入っています</remarks>
        public string ModelName;
        /// <summary>
        /// 最大フレーム
        /// </summary>
        public int MaxFrame;
        /// <summary>
        /// 最大ボーンフレーム
        /// </summary>
        public int MaxBoneFrame;
        /// <summary>
        /// 最大表情フレーム
        /// </summary>
        public int MaxFaceFrame;
        /// <summary>
        /// 各モーション終了時に発生
        /// </summary>
        public event BakedMotionEndDelegate MotionEnd;
        /// <summary>
        /// ユーザーデータ
        /// </summary>
        public object UserData;

        internal void OnMotionEnd(int TrackNum)
        {
            if (MotionEnd != null)
                MotionEnd(this, TrackNum);
        }
    }

    
    
}
