﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using MikuMikuDance.Core.Motion;
using MikuMikuDance.SlimDX;
using System.IO;

namespace MikuMikuDance.NiVE2
{
    public partial class FrmMotionApply : Form
    {
        string modelfile, motionfile;
        MMDMotion motiondata = null;
        public MMDMotion MotionData { get { return motiondata; } }
        public string MotionFileName { get { return motionfile; } }
        public FrmMotionApply(string modelfile)
        {
            this.modelfile = modelfile;
            InitializeComponent();
        }

        private void btnOpen_Click(object sender, EventArgs e)
        {
            if (openFileDialog1.ShowDialog(this) == System.Windows.Forms.DialogResult.OK)
            {
                txtMotion.Text = openFileDialog1.FileName;
            }
        }

        private void txtMotion_TextChanged(object sender, EventArgs e)
        {
            btnOK.Enabled = (txtMotion.Text.Trim() != "");
        }

        private void FrmMotionApply_Load(object sender, EventArgs e)
        {
            txtModel.Text = modelfile;
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            if (!File.Exists(txtMotion.Text))
            {
                MessageBox.Show("モーションファイル: " + txtMotion.Text + "が見つかりません");
                DialogResult = DialogResult.None;
                return;
            }
            motiondata = SlimMMDXCore.Instance.LoadMotionFromFile(txtMotion.Text);
            motionfile = txtMotion.Text;
            DialogResult = DialogResult.OK;
        }
    }
}
