﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using MikuMikuDance.Core.Stages;
using NiVE2.Plugin.Interface;
using NiVE2.Plugin.Property;
using SlimDX;
using MikuMikuDance.Core.Misc;

namespace MikuMikuDance.NiVE2
{
    class MMDNiVECamera : MMDXDefaultCamera
    {
        public void Update(double time, IComposition composition)
        {
            ILayer layer = composition.GetActiveCamera(time);
            if (layer != null)
            {
                //カメラ設定
                var prop = layer.GetLayerProperty(time);
                VertexProperty position = (VertexProperty)prop["位置"];
                VertexProperty target = (VertexProperty)prop["目標点"];
                RadianProperty xrot = (RadianProperty)prop["X回転"];
                RadianProperty yrot = (RadianProperty)prop["Y回転"];
                RadianProperty zrot = (RadianProperty)prop["Z回転"];
                NumberProperty zoom = (NumberProperty)prop["ズーム"];

                this.CameraPos = new Vector3((float)position.X, (float)position.Y, (float)position.Z);
                
                Vector3 t = new Vector3((float)target.X, (float)target.Y, (float)target.Z);
                Vector3.Subtract(ref t, ref this.CameraPos, out this.CameraVector);
                this.Far = Math.Max(this.CameraVector.Length(), 300);
                Quaternion.RotationYawPitchRoll(MathHelper.ToRadians((float)yrot.Angle), MathHelper.ToRadians((float)xrot.Angle), MathHelper.ToRadians((float)zrot.Angle), out this.Rotation);
                this.FieldOfView = 2.0f * (float)Math.Atan2(0.5 * composition.Size.Height, (double)zoom.Value);
            }
        }
    }
}
