//-----------------------------------------------------------
// MMDEdgeEffect.fx
//
// MMDX
// Copyright (C) Wilfrem
//-----------------------------------------------------------

//-----------------------------------------------------------------------------
// GtFNgݒl
//-----------------------------------------------------------------------------
float EdgeWidth=0.1;//GbW
float EdgeSensitivity=1;//GbWǂ̂炢Â邩
float NormalThreashold=1.25;//@̌oE
float DepthThreashold=0.1;//fvX̌oE
float NormalSensitivity=1;//@ɂǂ̈ʃGbWÂ邩
float DepthSensitivity=10;//fvXɂǂ̈ʃGbWÂ邩

//𑜓x
float2 ScreenResolution;

//-----------------------------------------------------------------------------
// eXN`
//-----------------------------------------------------------------------------
texture Texture;		// eNX`
sampler EdgeSampler : register(s0) = sampler_state
{
	Texture = (Texture);
	MinFilter = Linear;
	MagFilter = Linear;

	AddressU = Clamp;
	AddressV = Clamp;
};

float4 PSDrawEdge(float2 texCoord : TEXCOORD0) : COLOR
{
	//GbWf[^̃TvʒuYItZbgvZ
	float2 offset = EdgeWidth/ScreenResolution;
	//TvO
	float4 sample1=tex2D(EdgeSampler,texCoord+float2(-1,-1)*offset);
	float4 sample2=tex2D(EdgeSampler,texCoord+float2(1,1)*offset);
	float4 sample3=tex2D(EdgeSampler,texCoord+float2(1,-1)*offset);
	float4 sample4=tex2D(EdgeSampler,texCoord+float2(-1,1)*offset);
	//return float4(sample1.x,sample1.y,sample1.z,1);
	//TvOɔGbWtB^(x,y,z1)ĂGbW`悵Ȃ
	if(!any(sample1-1) || !any(sample2-1) || !any(sample3-1) || !any(sample4-1))
	{
		return 0;
	}
	//@Ɛ[x̕ωʂ擾
	float4 delta=abs(sample1-sample2)+abs(sample3-sample4);
	float normalDelta=dot(delta.xyz,1);//xyz...オBČÂB
	float depthDelta=delta.w;
	//ωʂtB^AωʂSensitivityő傫
	normalDelta=saturate((normalDelta-NormalThreashold)*NormalSensitivity);
	depthDelta=saturate((depthDelta-DepthThreashold)*DepthSensitivity);
	//ŏIIȃGbW̔Z擾
	float edgeAmount=saturate(normalDelta+depthDelta)*EdgeSensitivity;
	//return sample1;
	return float4(0,0,0,edgeAmount);
}

Technique MMDEdgeEffect
{
	Pass
	{
		PixelShader = compile ps_2_0 PSDrawEdge();
	}
}
