using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
#if XNA
using Microsoft.Xna.Framework;
#elif SlimDX
using SlimDX;
#endif

namespace MikuMikuDance.Core.Stages
{
    /// <summary>
    /// JC^[tFCX
    /// </summary>
    public interface IMMDXCamera
    {
        /// <summary>
        /// J
        /// </summary>
        /// <param name="aspectRatio">AXyNg</param>
        /// <param name="view">r[</param>
        /// <param name="proj">vWFNV</param>
        void GetCameraParam(float aspectRatio, out  Matrix view, out Matrix proj);
        /// <summary>
        /// Jʒu
        /// </summary>
        Vector3 Position { get; set; }
        /// <summary>
        /// ]̐ݒ
        /// </summary>
        /// <param name="rotate">]</param>
        void SetRotation(Quaternion rotate);
        /// <summary>
        /// p̐ݒ/擾
        /// </summary>
        float FieldOfView { get; set; }
        /// <summary>
        /// Near
        /// </summary>
        float Near { get; set; }
        /// <summary>
        /// Far
        /// </summary>
        float Far { get; set; }
        
        /// <summary>
        /// JxNg̐ݒ
        /// </summary>
        /// <param name="newVector">JxNg</param>
        void SetVector(Vector3 newVector);
    }
}
