#!/usr/bin/perl -w
#=============================================================================
#
#	mMeasureǡ¬꡿ǡ
#	mMeasure data measure & graph create daemon
#
#		Copyright (c) 2005 TIME INTERMEDIA CORPORATION
#
#	Release Version: mmeasure 1.0
#	$Revision: $
#	$Date: $
#	$Author: masq $
#
#=============================================================================

use strict;

use diagnostics;
use FindBin;
use lib ".";
use lib $FindBin::RealBin;

use lib "..";
require "library/all.pl";

use subs qw( main_loop daemonize check_for_running_daemon 
	scan_for_modules call_read_datas call_read_data update_graphs );

$|=1;

my $conf_file = $FindBin::RealBin . "/../mmeasure.conf";
print "Checking Configurations: '$conf_file'...\n";
my %conf = load_configurations( $conf_file );

print "Evaluating arguments...\n";
my ( $debuglevel, $runmode, $parallel ) = check_for_args( @ARGV );
if ( $debuglevel > $conf{ 'DEBUGLEVEL' } )
{
	$conf{ 'DEBUGLEVEL' } = $debuglevel;
}
else
{
	$debuglevel = $conf{ 'DEBUGLEVEL' };
}
if ( $debuglevel > 0 )
{
	foreach my $k ( keys %conf )
	{
		print $k . "=" . $conf{ $k } . "\n";
	}
}

if ( ( $runmode & 8 ) > 0 )
{
	$runmode &= 127;
	update_graphs( $debuglevel, $parallel, scan_for_modules( $debuglevel ) );
}

if ( $runmode < 128 )
{
	exit 0;
}

check_for_running_daemon();

my $debug="";
if ( ( $runmode & 1 ) > 0 )
{
	print "Debug mode enabled!\nLogdir: " . $conf{ 'LOGDIR' } . "\nPIDfile: " . $conf{ 'PIDFILE' } . "\n\n";
	$debug="d";
}

daemonize( $debug );

if ( $parallel eq "&")
{
	print "Running with parallel module-calls\n";
}

my $MODPARM = options_to_args( %conf );

$SIG{ TERM } = \&finalize;
$SIG{ HUP } = \&finalize;

main_loop( $debuglevel, $parallel );

#-------------------------------------------------------------------------
#	ᥤ롼
#-------------------------------------------------------------------------
sub main_loop
{
	my ( $debuglevel, $parallel ) = @_;

	my ( $now, $last, $last_scan_modules, $last_check_alert_mail, $last_graph_update, $last_mail_reset, @modules );
	my $alert_message = "";

	$now = time;
	$last = $now - 100;
	$last_scan_modules = $now;
	$last_check_alert_mail = $now;
	$last_graph_update = int( $now / $conf{ 'TIMER_GRAPH_UPDATE_MINUTE' } ) * $conf{ 'TIMER_GRAPH_UPDATE_MINUTE' };

	@modules = scan_for_modules( $debuglevel );
	initialize_modules( @modules );

	my %timer_mail_reset;
	$timer_mail_reset{ 'load_average' } = $now;
	$timer_mail_reset{ 'cpu_usage' } = $now;
	$timer_mail_reset{ 'memory' } = $now;
	$timer_mail_reset{ 'disk' } = $now;
	$timer_mail_reset{ 'connection' } = $now;
	$timer_mail_reset{ 'thread' } = $now;
	$timer_mail_reset{ 'slow_query' } = $now;
	$timer_mail_reset{ 'query_cache' } = $now;
	$timer_mail_reset{ 'table_cache' } = $now;
	$timer_mail_reset{ 'temporary_memory' } = $now;
	$timer_mail_reset{ 'key' } = $now;
	$timer_mail_reset{ 'myisam_key_cache' } = $now;
	$timer_mail_reset{ 'select_full_join' } = $now;
	$timer_mail_reset{ 'select_range_check' } = $now;
	$timer_mail_reset{ 'sort_merge_passes' } = $now;

	while ()
	{
		$now = time;
		if ( $last + $conf{ 'TIMER_READ_DATA_SECOND' } <= $now )
		{
			if ( $debuglevel > 0 )
			{
				print $now . ":main loop running\n";
			}

			if ( $last_scan_modules + $conf{ 'TIMER_SCAN_MODULES_SECOND' } <= $now )
			{
				@modules = scan_for_modules( $debuglevel );
				$last_scan_modules = $now;
				if ( $debuglevel < 0 )
				{
					logrotate( $debuglevel );
				}
			}
			call_read_datas( $debuglevel, $parallel, $MODPARM, @modules );

			if ( $last_check_alert_mail + $conf{ 'TIMER_ALERT_MAIL_CHECK_SECOND' } <= $now )
			{
				my $db = db_connect( 
					$conf{ 'MYSQL_HOST' }, 
					$conf{ 'MYSQL_USER' }, 
					$conf{ 'MYSQL_PASSWORD' }, 
					$conf{ 'MYSQL_PORT' }, 
					$conf{ 'MYSQL_SOCKET' } );
				my %status = select_2column( $db, "show status" );
				my %variables = select_2column( $db, "show variables" );
				$db->disconnect;

				if ( $timer_mail_reset{ 'connection' } <= $now )
				{
					my $value = alerter_get_connection( 
						$status{ 'Max_used_connections' }, $variables{ 'max_connections' } );
					my $judge = alerter_judge_connection( $value, %conf );
					if ( $judge ne "just" )
					{
						$alert_message .= alerter_mail_format_percentage( "³Ψ", 
							alerter_advise_connection( $judge ), $value );
						$timer_mail_reset{ 'connection' } += $conf{ 'TIMER_MAIL_RESET_MINUTE' };
					}
				}
				if ( $timer_mail_reset{ 'slow_query' } <= $now )
				{
					my $value = $status{ 'Slow_queries' };
					if ( $value > 0 )
					{
						$alert_message .= alerter_mail_format_number( "꡼", 
							alerter_advise_slow_query( $value ), $value );
						$timer_mail_reset{ 'slow_query' } += $conf{ 'TIMER_MAIL_RESET_MINUTE' };
					}
				}
				if ( $timer_mail_reset{ 'table_cache' } <= $now )
				{
					my $value = alerter_get_table_cache( 
						$status{ 'Open_tables' }, $variables{ 'table_cache' } );
					my $judge = alerter_judge_table_cache( $value, %conf );
					if ( $judge ne "just" )
					{
						$alert_message .= alerter_mail_format_percentage( "ơ֥륭åΨ", 
							alerter_advise_table_cache( $judge ), $value );
						$timer_mail_reset{ 'table_cache' } += $conf{ 'TIMER_MAIL_RESET_MINUTE' };
					}
				}
				if ( $timer_mail_reset{ 'temporary_memory' } <= $now )
				{
					my $value = alerter_get_temporary_memory( 
						$status{ 'Created_tmp_tables' }, $status{ 'Created_tmp_disk_tables' } );
					my $judge = alerter_judge_temporary_memory( $value, %conf );
					if ( $judge ne "just" )
					{
						$alert_message .= alerter_mail_format_percentage( "ƥݥ꡼꡼Ψ", 
							alerter_advise_temporary_memory( $judge ), $value );
						$timer_mail_reset{ 'temporary_memory' } += $conf{ 'TIMER_MAIL_RESET_MINUTE' };
					}
				}
				if ( $timer_mail_reset{ 'select_full_join' } <= $now )
				{
					my $value = $status{ 'Select_full_join' };
					if ( $value > 0 )
					{
						$alert_message .= alerter_mail_format_number( "Ѥʤ祤", 
							alerter_advise_select_full_join( $value ), $value );
						$timer_mail_reset{ 'select_full_join' } += $conf{ 'TIMER_MAIL_RESET_MINUTE' };
					}
				}
				if ( $timer_mail_reset{ 'select_range_check' } <= $now )
				{
					my $value = $status{ 'Select_range_check' };
					if ( $value > 0 )
					{
						$alert_message .= alerter_mail_format_number( "Υǥå", 
							alerter_advise_select_range_check( $value ), $value );
						$timer_mail_reset{ 'select_range_check' } += $conf{ 'TIMER_MAIL_RESET_MINUTE' };
					}
				}
				if ( $alert_message ne "" )
				{
					alerter_sendmail( $conf{ 'MAIL_HOST' }, 
						$conf{ 'MAIL_TO' }, $conf{ 'MAIL_FROM' }, 
						$conf{ 'MAIL_SUBJECT' }, $alert_message, 
						$conf{ 'MAIL_CC' }, $conf{ 'MAIL_BCC' } );
				}
				$alert_message = "";
				$last_check_alert_mail = $now;
			}
			$last = $now;
		}

		if ( $last_graph_update + $conf{ 'TIMER_GRAPH_UPDATE_MINUTE' } <= $now )
		{
			update_graphs( $debuglevel, "&" );
			$last_graph_update += $conf{ 'TIMER_GRAPH_UPDATE_MINUTE' };
		}

		sleep( 1 );
	}
}

#-------------------------------------------------------------------------
#	ǡ
#-------------------------------------------------------------------------
sub daemonize
{
	my ( $debug ) = @_;

	print "Entering daemon mode...\n";
	if ( $debug eq "" )
	{
		open STDIN, "/dev/null";
		open STDOUT, ">>$conf{ 'LOGDIR' }" . "/mmeasure.log";
		open STDERR, ">>$conf{ 'LOGDIR' }" . "/mmeasure.err";
		chdir "/";
		fork && exit 0;
		print "\n\n################################################################\n";
		print time . ": forked into background and running on PID " . $$ . "\n";
	}
	else
	{
		print time . ": debug-mode on PID " . $$ . "\n";
	}
	open FILE, ">$conf{ 'PIDFILE' }";
	print FILE $$;
	close FILE;
}

#-------------------------------------------------------------------------
#	λʥǡβ
#-------------------------------------------------------------------------
sub finalize
{
	my ( $sig ) = @_;

	if ( defined $sig )
	{
		if ( $sig eq "TERM" )
		{
			print time . " TERM signal raceived, daemon exiting normally.\n";
			if ( -e $conf{ 'PIDFILE' } )
			{
				unlink $conf{ 'PIDFILE' };
				print "PID-file removed.\n";
			}
			close STDIN;
			close STDOUT;
			close STDERR;
			exit 0;
		}

		if ( $sig eq "HUP" )
		{
			print time . " HUP signal received - signal not implemented yet...\n";
			foreach ( keys %conf )
			{
				print $_ . " -> " . $conf{$_} . "\n";
			}
		}
	}
}

#-------------------------------------------------------------------------
#	ǡɤ߹ߥ⥸塼뷲θƤӽФ롼
#-------------------------------------------------------------------------
sub call_read_datas
{
	my ( $debuglevel, $parallel, $MODPARM, @modules ) = @_;
	my ( $sub, $ouser, $osystem, $user, $system, $utime, $stime );

	if ( $debuglevel > 0 )
	{
		print time . ": getting samples.\n";
	}
	for $sub ( @modules )
	{
		my $modname = uc $sub;
		$modname =~s/^DATA-//g;

		if ( $debuglevel > 1 )
    	{
			printf "  %15s ... " . $sub;
		}
		if ( $debuglevel > 2 )
		{
			( undef, undef, $ouser, $osystem ) = times;
			call_read_data( "$conf{ 'PATH_MMEASURE_DAEMON' }/$sub" . "MODNAME=\"$modname\" ". $MODPARM );
			( undef, undef, $user, $system ) = times;
			$utime = $user - $ouser;
			$stime = $system - $osystem;
			printf "done in %.3f (u=%.3f s=%.3f).\n", ( $utime + $stime ), $utime, $stime;
		}
		else
		{
			call_read_data( "$conf{ 'PATH_MMEASURE_DAEMON' }/$sub", "MODNAME=\"$modname\" " . $MODPARM . " " . $parallel );
			if ( $debuglevel > 1 )
			{
				print "done.\n";
			}
		}
	}
	if ( $debuglevel > 0 )
	{
		print time . ": done.\n";
	}
}

#-------------------------------------------------------------------------
#	ǡɤ߹ߥ⥸塼θƤӽФ
#-------------------------------------------------------------------------
sub call_read_data
{
	my ( $modulepath, $parameters ) = @_;

	if ( -e "$modulepath/read-data" )
	{
		system( "cd \"$modulepath\"; nice -5 ./read-data $parameters" );
	}
	else
	{
		system( "cd \"$modulepath\"; nice -5 ./read-data.pl $parameters" );
	}
}

#-------------------------------------------------------------------------
#	դΥåץǡ
#-------------------------------------------------------------------------
sub update_graphs
{
	my ( $debuglevel, $par ) = @_;

	if ( defined $conf{ 'PATH_MMEASURE_DAEMON' } )
	{
		if ( -e "$conf{ 'PATH_MMEASURE_DAEMON' }/update_graphs.sh" )
		{
			system( "cd \"$conf{ 'PATH_MMEASURE_DAEMON' }\"; ./update_graphs.sh $par" );
		}
	}
}

#-------------------------------------------------------------------------
#	ưѤߥǡΥå
#-------------------------------------------------------------------------
sub check_for_running_daemon
{
	my ( $pid, $name );

	if ( -e $conf{ 'PIDFILE' } )
	{
		open PFILE, $conf{ 'PIDFILE' };
		$pid = <PFILE>;
		close PFILE; 
		chomp $pid;
		if ( defined $pid )
		{
			if ( -d "/proc/$pid" )
			{
				print "\nAnother daemon is probably running on PID " . $pid . "\nLet me check that...\n";
				open PROCFILE, "/proc/$pid/cmdline";
				$name = <PROCFILE>;
				close PROCFILE;
				if ( defined $name )
				{
					if ( index( $name, "mmeasure" ) >= 0)
					{
						print "\ndaemon stopped.\n\n";
						exit 1;
					}
				}
				print "Seems to be an old PID-file. :)\n";
				unlink $conf{ 'PIDFILE' } or die "ERROR: $!\n";
			}
		}
	}
}

#-------------------------------------------------------------------------
#	եΥơ
#-------------------------------------------------------------------------
sub logrotate
{
	my ( $debuglevel ) = @_;
	my ( $size, $file );

	if ( ( defined $debuglevel ) && ( $debuglevel < 0 ) )
	{
		$file = "$conf{ 'LOGDIR' }/mmeasure.err";
		( undef, undef, undef, undef, undef, undef, undef, $size, undef, undef, undef, undef, undef ) = stat( $file );
		if ( defined $size )
		{
			if ( $size > $conf{ 'LOGSIZE' } )
			{
				print time . " $file exceeding " . $conf{ 'LOGSIZE' } . " bytes - rotating - keeping " . $conf{ 'LOGBACKUPS' } . " backups.\n";
				for ( my $nn = $conf{ 'LOGBACKUPS' }; $nn > 1; $nn-- )
				{
					if ( -e "$file.$nn" )
					{
						unlink "$file.$nn";
					}
					if ( -e "$file." . ( $nn - 1 ) )
					{
						rename "$file." . ( $nn - 1 ), "$file." . $nn;
					}
				}
				close STDERR;
				rename $file, "$file.1";
				open STDERR, ">>$file";
			}	
		}

		$file = "$conf{ 'LOGDIR' }/mmeasure.log";
		( undef, undef, undef, undef, undef, undef, undef, $size, undef, undef, undef, undef, undef ) = stat( $file );
		if ( defined $size )
		{
			if ( $size > $conf{ 'LOGSIZE' } )
			{
				print time . " $file exceeding " . $conf{ 'LOGSIZE' } . " bytes - rotating - keeping " . $conf{ 'LOGBACKUPS' } . " backups.\n";
				for ( my $nn = $conf{ 'LOGBACKUPS' }; $nn > 1; $nn-- )
				{
					if ( -e "$file.$nn" )
					{
						unlink "$file.$nn";
					}
					if ( -e "$file." . ( $nn - 1 ) )
					{
						rename "$file." . ( $nn - 1 ), "$file." . $nn;
					}
				}
				close STDOUT;
				rename $file, "$file.1";
				open STDOUT, ">>$file";
			}
		}
	}
}

#-------------------------------------------------------------------------
#	ޥɥ饤Υå
#-------------------------------------------------------------------------
sub check_for_args
{
	my @args = @_;

	my $debuglevel = -1;
	my $runmode = 0;
	my $parallel = "";

	foreach my $arg ( @args )
	{
		if (index( $arg, "d" ) >= 0)
		{
			$runmode |= 1;
		}
		if (index( $arg, "g" ) >= 0)
		{
			$runmode |= 8;
		}
		if (index( $arg, "v" ) >= 0)
		{
			$runmode |= 16;
		}
		if (index( $arg, "D" ) >= 0)
		{
			$runmode |= 128;
		}
		if (index( $arg, "?" ) >= 0)
		{
			$runmode |= 256;
		}
		if (index( $arg, "p" ) >= 0)
		{
			$parallel= "&";
		}
		$arg =~ s/[a-zA-Z]//g;
		if ( $arg =~ /[0-9]/ )
		{
			if ( $arg > 0 )
			{
				$debuglevel = $arg
			}
		}
	}
	
	if ( ( $runmode == 0) || ( $runmode > 255 ) )
	{
		print "mMeasure daemon 1.0.2\n";
		print "usage:\ndaemon [options[debuglevel]]\n	options:\n";
		print "	D - enter daemon-mode (i.e. start the main loop)\n";
		print "	d - enter debugging mode (don't fork into background)\n";
		print "	g - update graphs\n";
		print "	p - call modules parallel (not in debug mode)\n";
		print "\n";
		exit 0;
	}

	return ( $debuglevel, $runmode, $parallel );
}

#-------------------------------------------------------------------------
#	⥸塼뷲Υ
#-------------------------------------------------------------------------
sub scan_for_modules
{

	my ( $debuglevel )=@_;
	my ( @modules, @dirs, $sub, $name );

	if ( $debuglevel > 0 )
	{
		print time . ": evaluating modules.\n";
	}
	opendir DIR, $conf{ 'PATH_MMEASURE_DAEMON' };
	@dirs = grep( /data-/, readdir( DIR ) );
	closedir( DIR );
	undef @modules;
	for $sub ( @dirs )
	{
		if ( -d "$conf{ 'PATH_MMEASURE_DAEMON' }/$sub" )
		{
			if ( ! -e "$conf{ 'PATH_MMEASURE_DAEMON' }/$sub/rrd" )
			{
				mkdir "$conf{ 'PATH_MMEASURE_DAEMON' }/$sub/rrd", 0755;
			}
			( $name = $sub ) =~ s/^data-//g;
			if ( $debuglevel > 1 )
			{
				print "	" . uc $name;
			}
			if ( $conf{ 'RUN' } =~ /\*|(^| )$name( |$)/ )
			{
				push( @modules, $sub );
				if ( $debuglevel > 1 )
				{
					print " inserted.";
				}
			}
			if ( $debuglevel > 1 )
			{
				print "\n";
			}
		}
	}
	return @modules;
}

#-------------------------------------------------------------------------
#	⥸塼뷲ν
#-------------------------------------------------------------------------
sub initialize_modules
{
	my ( @modules ) = @_;
	my ( $sub, $ouser, $osystem, $user, $system, $utime );

	print time . " Initializing modules...\n";
	for $sub ( @modules )
	{
		unlink "$conf{ 'PATH_MMEASURE_DAEMON' }/$sub/*.dat";
		unlink "$conf{ 'PATH_MMEASURE_DAEMON' }/$sub/*.old";
		if ( -e "$conf{ 'PATH_MMEASURE_DAEMON' }/$sub/init" )
		{
			print time . " initializing " . $sub . "\n";
			system "cd $conf{ 'PATH_MMEASURE_DAEMON' }/$sub; ./init";
			print time . " initializing of " . $sub . " DONE!\n\n";
		}
	}
	print time . " END Initializing modules...\n";
	print "################################################################\n";
}
