#!/bin/sh
#=============================================================================
#
#	MySQL RRDǡ١
#	MySQL RRD database maker
#
#		Copyright (c) 2005 TIME INTERMEDIA CORPORATION
#
#	Release Version: mmeasure 1.0
#	$Revision: $
#	$Date: $
#	$Author: masq $
#
#=============================================================================

. ../../mmeasure.conf

step="60"
minsamples="720"

avgsamps ()
{
	avg=$(($1 / $2))
	if [ ${avg} -lt 1 ]
	then
		avg=1
	fi
	echo ${avg}
}

archives ()
{
	arch=$(($1 / $2))
	if [[ $(($2 * ${arch} * $3)) -lt $4 ]]
	then
		arch=$((${arch} + 1))
	fi
	echo ${arch}
}

heartbeat=$((${step} * 2))

hoursamps=$((3600 / ${step}))
houravgs=$(avgsamps ${hoursamps} ${minsamples})
hourarchives=$(archives ${hoursamps} ${houravgs} ${step} 3600)

daysamps=$((86400 / ${step}))
dayavgs=$(avgsamps ${daysamps} ${minsamples})
dayarchives=$(archives ${daysamps} ${dayavgs} ${step} 86400)

weeksamps=$((604800 / ${step}))
weekavgs=$(avgsamps ${weeksamps} ${minsamples})
weekarchives=$(archives ${weeksamps} ${weekavgs} ${step} 604800)

monthsamps=$((2678400 / ${step}))
monthavgs=$(avgsamps ${monthsamps} ${minsamples})
montharchives=$(archives ${monthsamps} ${monthavgs} ${step} 2678400)

yearsamps=$((31622400 / ${step}))
yearavgs=$(avgsamps ${yearsamps} ${minsamples})
yeararchives=$(archives ${yearsamps} ${yearavgs} ${step} 31622400)

HOUR_RRA="RRA:AVERAGE:0.5:${houravgs}:${hourarchives}"
DAY_RRA="RRA:AVERAGE:0.5:${dayavgs}:${dayarchives}"
WEEK_RRA="RRA:AVERAGE:0.5:${weekavgs}:${weekarchives}"
MONTH_RRA="RRA:AVERAGE:0.5:${monthavgs}:${montharchives}"
YEAR_RRA="RRA:AVERAGE:0.5:${yearavgs}:${yeararchives}"
ALL_RRA="${HOUR_RRA} ${DAY_RRA} ${WEEK_RRA} ${MONTH_RRA} ${YEAR_RRA}"

	$PATH_RRDTOOL create rrd/connections.rrd --step ${step} \
		DS:Threads_connected:GAUGE:${heartbeat}:0:U \
		DS:max_connections:GAUGE:${heartbeat}:0:U \
		DS:Max_used:GAUGE:${heartbeat}:0:U \
		DS:risky:GAUGE:${heartbeat}:0:U \
		DS:lack:GAUGE:${heartbeat}:0:U \
		DS:best:GAUGE:${heartbeat}:0:U \
		${ALL_RRA}

	$PATH_RRDTOOL create rrd/queries.rrd --step ${step} \
		DS:questions:COUNTER:${heartbeat}:0:U \
		DS:com_select:COUNTER:${heartbeat}:0:U \
		DS:com_insert:COUNTER:${heartbeat}:0:U \
		DS:com_update:COUNTER:${heartbeat}:0:U \
		DS:com_delete:COUNTER:${heartbeat}:0:U \
		${ALL_RRA}

	$PATH_RRDTOOL create rrd/table_cache.rrd --step ${step} \
		DS:open_tables:GAUGE:${heartbeat}:0:U \
		DS:table_cache:GAUGE:${heartbeat}:0:U \
		DS:created_tmp_tables:COUNTER:${heartbeat}:0:U \
		DS:created_tmp_disk_t:COUNTER:${heartbeat}:0:U \
		DS:risky:GAUGE:${heartbeat}:0:U \
		DS:lack:GAUGE:${heartbeat}:0:U \
		DS:best:GAUGE:${heartbeat}:0:U \
		${ALL_RRA}

	$PATH_RRDTOOL create rrd/key_cache.rrd --step ${step} \
		DS:key_reads:COUNTER:${heartbeat}:0:U \
		DS:key_read_requests:COUNTER:${heartbeat}:0:U \
		DS:key_buffer_size:GAUGE:${heartbeat}:0:U \
		DS:key_blocks_used:GAUGE:${heartbeat}:0:U \
		DS:select_full_join:COUNTER:${heartbeat}:0:U \
		DS:select_range_check:COUNTER:${heartbeat}:0:U \
		DS:handler_read_key:COUNTER:${heartbeat}:0:U \
		DS:handler_read_rnd:COUNTER:${heartbeat}:0:U \
		DS:slow_queries:COUNTER:${heartbeat}:0:U \
		${ALL_RRA}

	$PATH_RRDTOOL create rrd/query_cache.rrd --step ${step} \
		DS:Qcache_free_memory:GAUGE:${heartbeat}:0:U \
		DS:query_cache_size:GAUGE:${heartbeat}:0:U \
		DS:risky:GAUGE:${heartbeat}:0:U \
		DS:lack:GAUGE:${heartbeat}:0:U \
		DS:best:GAUGE:${heartbeat}:0:U \
		${ALL_RRA}

