use strict;

sub test_alerter_get_connection
{
	my $self = shift();
	$self->assert_equals( 100, alerter_get_connection( 1, 1 ) );
	$self->assert_equals( 50, alerter_get_connection( 1, 2 ) );
	$self->assert_equals( 33.33, alerter_get_connection( 1, 3 ) );
	$self->assert_equals( 0, alerter_get_connection( 0, 1 ) );
}

sub test_alerter_judge_connection
{
	my $self = shift();
	my %conf = load_configurations( "tests/mmeasure.conf" );
	$self->assert_equals( "risky", alerter_judge_connection( 100, %conf ) );
	$self->assert_equals( "risky", alerter_judge_connection( 96, %conf ) );
	$self->assert_equals( "risky", alerter_judge_connection( 95, %conf ) );
	$self->assert_equals( "lack", alerter_judge_connection( 94, %conf ) );
	$self->assert_equals( "lack", alerter_judge_connection( 93, %conf ) );
	$self->assert_equals( "lack", alerter_judge_connection( 85, %conf ) );
	$self->assert_equals( "just", alerter_judge_connection( 84, %conf ) );
	$self->assert_equals( "just", alerter_judge_connection( 41, %conf ) );
	$self->assert_equals( "just", alerter_judge_connection( 40, %conf ) );
	$self->assert_equals( "overspec", alerter_judge_connection( 39, %conf ) );
	$self->assert_equals( "overspec", alerter_judge_connection( 38, %conf ) );
	$self->assert_equals( "overspec", alerter_judge_connection( 0, %conf ) );
}

sub test_alerter_advise_connection
{
	my $self = shift();
	$self->assert_equals( "max_connectionsΥ䤷Ʋ", alerter_advise_connection( "risky" ) );
	$self->assert_equals( "max_connectionsΥ䤹ȤǤ¿Ʊ³桼ޤ", alerter_advise_connection( "lack" ) );
	$self->assert_equals( "max_connectionsŬꤵƤޤ", alerter_advise_connection( "just" ) );
	$self->assert_equals( "³Фmax_connections꤬礭ޤ", alerter_advise_connection( "overspec" ) );
}

sub test_alerter_advise_slow_query
{
	my $self = shift();
	$self->assert_equals( "٤꡼䥤ǥåȤäƤʤ꡼Ϥޤ", alerter_advise_slow_query( 0 ) );
	$self->assert_equals( "꡼åơ٤꡼䥤ǥåƲ", alerter_advise_slow_query( 1 ) );
}

sub test_alerter_get_table_cache
{
	my $self = shift();
	$self->assert_equals( 100, alerter_get_table_cache( 1, 1 ) );
	$self->assert_equals( 50, alerter_get_table_cache( 1, 2 ) );
	$self->assert_equals( 33.33, alerter_get_table_cache( 1, 3 ) );
	$self->assert_equals( 0, alerter_get_table_cache( 0, 1 ) );
}

sub test_alerter_judge_table_cache
{
	my $self = shift();
	my %conf = load_configurations( "tests/mmeasure.conf" );
	$self->assert_equals( "risky", alerter_judge_table_cache( 100, %conf ) );
	$self->assert_equals( "risky", alerter_judge_table_cache( 99, %conf ) );
	$self->assert_equals( "risky", alerter_judge_table_cache( 98, %conf ) );
	$self->assert_equals( "lack", alerter_judge_table_cache( 97, %conf ) );
	$self->assert_equals( "lack", alerter_judge_table_cache( 87, %conf ) );
	$self->assert_equals( "lack", alerter_judge_table_cache( 86, %conf ) );
	$self->assert_equals( "just", alerter_judge_table_cache( 85, %conf ) );
	$self->assert_equals( "just", alerter_judge_table_cache( 41, %conf ) );
	$self->assert_equals( "just", alerter_judge_table_cache( 40, %conf ) );
	$self->assert_equals( "overspec", alerter_judge_table_cache( 39, %conf ) );
	$self->assert_equals( "overspec", alerter_judge_table_cache( 38, %conf ) );
	$self->assert_equals( "overspec", alerter_judge_table_cache( 0, %conf ) );
}

sub test_alerter_advise_table_cache
{
	my $self = shift();
	$self->assert_equals( "table_cacheΥ䤹Ȥǽޤ", alerter_advise_table_cache( "risky" ) );
	$self->assert_equals( "table_cacheΥ­ʤʤǽ㲼붲줬ޤ", alerter_advise_table_cache( "lack" ) );
	$self->assert_equals( "table_cacheŬꤵƤޤ", alerter_advise_table_cache( "just" ) );
	$self->assert_equals( "table_cache꤬礭ޤ", alerter_advise_table_cache( "overspec" ) );
}

sub test_alerter_get_temporary_memory
{
	my $self = shift();
	$self->assert_equals( 99.90, alerter_get_temporary_memory( 1000, 1 ) );
	$self->assert_equals( 66.67, alerter_get_temporary_memory( 3, 1 ) );
	$self->assert_equals( 50, alerter_get_temporary_memory( 2, 1 ) );
	$self->assert_equals( 33.33, alerter_get_temporary_memory( 3, 2 ) );
	$self->assert_equals( 0, alerter_get_temporary_memory( 0, 1 ) );
	$self->assert_equals( 0, alerter_get_temporary_memory( 1, 0 ) );
}

sub test_alerter_judge_temporary_memory
{
	my $self = shift();
	my %conf = load_configurations( "tests/mmeasure.conf" );
	$self->assert_equals( "overspec", alerter_judge_temporary_memory( 100, %conf ) );
	$self->assert_equals( "overspec", alerter_judge_temporary_memory( 99, %conf ) );
	$self->assert_equals( "just", alerter_judge_temporary_memory( 98, %conf ) );
	$self->assert_equals( "just", alerter_judge_temporary_memory( 81, %conf ) );
	$self->assert_equals( "just", alerter_judge_temporary_memory( 80, %conf ) );
	$self->assert_equals( "lack", alerter_judge_temporary_memory( 79, %conf ) );
	$self->assert_equals( "lack", alerter_judge_temporary_memory( 61, %conf ) );
	$self->assert_equals( "lack", alerter_judge_temporary_memory( 60, %conf ) );
	$self->assert_equals( "risky", alerter_judge_temporary_memory( 59, %conf ) );
	$self->assert_equals( "risky", alerter_judge_temporary_memory( 1, %conf ) );
	$self->assert_equals( "just", alerter_judge_temporary_memory( 0, %conf ) );
}

sub test_alerter_advise_temporary_memory
{
	my $self = shift();
	$self->assert_equals( "tmp_table_sizeΥ䤷ǽƲ", alerter_advise_temporary_memory( "risky" ) );
	$self->assert_equals( "tmp_table_sizeΥ䤹Ȥǽ夹ǽ⤤Ǥ", alerter_advise_temporary_memory( "lack" ) );
	$self->assert_equals( "tmp_table_sizeŬꤵƤޤ", alerter_advise_temporary_memory( "just" ) );
	$self->assert_equals( "tmp_table_size꤬礭ޤ", alerter_advise_temporary_memory( "overspec" ) );
}

sub test_alerter_advise_key
{
	my $self = shift();
	$self->assert_equals( "Ѥʤ׵᤬¿ޤǥååƲ", alerter_advise_key( "risky" ) );
	$self->assert_equals( "Ŭ˻ѤƤޤ", alerter_advise_key( "just" ) );
}

sub test_alerter_advise_select_full_join
{
	my $self = shift();
	$self->assert_equals( "ƤselectȤäƥ祤󤷤ƤŬʾ֤Ǥ", alerter_advise_select_full_join( 0 ) );
	$self->assert_equals( "Ȥ鷺˥祤󤷤ƤselectΤǥǥååƲ", alerter_advise_select_full_join( 1 ) );
}

sub test_alerter_advise_select_range_check
{
	my $self = shift();
	$self->assert_equals( "󥸥å祤󤬤ʤŬʾ֤Ǥ", alerter_advise_select_range_check( 0 ) );
	$self->assert_equals( "󥸥å祤󤷤ƤselectΤǥǥååƲ", alerter_advise_select_range_check( 1 ) );
}

sub test_alerter_mail_format_percentage
{
	my $self = shift();
	$self->assert_equals( "ڥ٥ 123 %\nå\n\n", alerter_mail_format_percentage( "٥", "å", 123 ) );
}

sub test_alerter_mail_format_number
{
	my $self = shift();
	$self->assert_equals( "ڥ٥ 123 \nå\n\n", alerter_mail_format_number( "٥", "å", 123 ) );
}

1;
