use strict;

sub test_load_configurations_mysql
{
	my $self = shift();
	my %conf = load_configurations( "tests/mmeasure.conf" );
	$self->assert_equals( "mmeasure", $conf{ 'MYSQL_USER' } );
	$self->assert_equals( "g8Ut4rp2", $conf{ 'MYSQL_PASSWORD' } );
	$self->assert_equals( "localhost", $conf{ 'MYSQL_HOST' } );
	$self->assert_equals( "3306", $conf{ 'MYSQL_PORT' } );
	$self->assert_equals( "/tmp/mysql.sock", $conf{ 'MYSQL_SOCKET' } );
}

sub test_load_configurations_mail
{
	my $self = shift();
	my %conf = load_configurations( "tests/mmeasure.conf" );
	$self->assert_equals( "localhost", $conf{ 'MAIL_HOST' } );
	$self->assert_equals( "from\@mmeasure.com", $conf{ 'MAIL_FROM' } );
	$self->assert_equals( "to\@mmeasure.com", $conf{ 'MAIL_TO' } );
	$self->assert_equals( "cc\@mmeasure.com", $conf{ 'MAIL_CC' } );
	$self->assert_equals( "bcc\@mmeasure.com", $conf{ 'MAIL_BCC' } );
}

sub test_load_configurations_web
{
	my $self = shift();
	my %conf = load_configurations( "tests/mmeasure.conf" );
	$self->assert_equals( "/usr/local/mmeasure/web/graphs", $conf{ 'WEBDIR' } );
}

sub test_load_configurations_path
{
	my $self = shift();
	my %conf = load_configurations( "tests/mmeasure.conf" );
	$self->assert_equals( "/usr/local/rrdtool/bin/rrdtool", $conf{ 'PATH_RRDTOOL' } );
	$self->assert_equals( "/usr/local/mmeasure", $conf{ 'PATH_MMEASURE' } );
	$self->assert_equals( "/usr/local/mmeasure/daemon", $conf{ 'PATH_MMEASURE_DAEMON' } );
}

sub test_bad_load_configurations
{
	my $self = shift();
	my %conf = load_configurations( "tests/mmeasure.conf" );
	$self->assert_not_equals( "not_exist", $conf{ '_NOT_EXIST' }, "_NOT_EXIST" );
}

sub test_read_configuration_file
{
	my $self = shift();
	my @raw_conf = read_configuration_file( "tests/mmeasure.conf" );
	$self->assert_equals( "CONNECTION_RISKY=95", $raw_conf[ 0 ] );
	$self->assert_equals( "CONNECTION_LACK=85", $raw_conf[ 1 ] );
	$self->assert_equals( "TEMPORARY_MEMORY_RISKY=60", $raw_conf[ 3 ] );
}

sub test_correct_configuration_item
{
	my $self = shift();
	my %expect;
	$expect{ "TEST_VALUE" } = "This is test.";
	$expect{ "TEST_PATH" } = "/tmp";
	$self->assert_equals( "This is test.", correct_configuration_item( "TEST_VALUE", "value", "", "", "value for test", %expect ) );
	$self->assert_equals( "/tmp", correct_configuration_item( "TEST_PATH", "path", "", "", "path for test", %expect ) );
}

sub test_parse_line
{
	my $self = shift();
	my ( $expect_name, $expect_value, $expect_comment );
	( $expect_name, $expect_value, $expect_comment ) = parse_line( "NAME=VALUE" );
	$self->assert_equals( "NAME", $expect_name );
	$self->assert_equals( "VALUE", $expect_value );
	$self->assert_equals( "", $expect_comment );
	( $expect_name, $expect_value, $expect_comment ) = parse_line( "NAME=VALUE #COMMENT" );
	$self->assert_equals( "NAME", $expect_name );
	$self->assert_equals( "VALUE", $expect_value );
	$self->assert_equals( "COMMENT", $expect_comment );
}

sub test_expand_directory
{
	my $self = shift();
	my %conf = load_configurations( "tests/mmeasure.conf" );
	$self->assert_equals( "abc", expand_directory( "abc", %conf ) );
	$self->assert_equals( "abc/usr/local/mmeasurexyz", expand_directory( "abc\$PATH_MMEASURExyz", %conf ) );
	$self->assert_equals( "abc/usr/local/mmeasure/daemonxyz", expand_directory( "abc\$PATH_MMEASURE_DAEMONxyz", %conf ) );
}

1;
