<?php
class alerter_tester extends TestCase
{
	function testMessageConnectionUsedRate()
	{
		$conf = LoadConfiguration( "mmeasure.conf" );
		$this->assertEquals( "<strong>max_connections</strong>Υ䤷Ʋ", MessageConnectionUsedRate( 100, $conf ) );
		$this->assertEquals( "<strong>max_connections</strong>Υ䤷Ʋ", MessageConnectionUsedRate( 96, $conf ) );
		$this->assertEquals( "<strong>max_connections</strong>Υ䤷Ʋ", MessageConnectionUsedRate( 95, $conf ) );
		$this->assertEquals( "<strong>max_connections</strong>Υ䤹ȤǤ¿Ʊ³桼ޤ", MessageConnectionUsedRate( 94, $conf ) );
		$this->assertEquals( "<strong>max_connections</strong>Υ䤹ȤǤ¿Ʊ³桼ޤ", MessageConnectionUsedRate( 93, $conf ) );
		$this->assertEquals( "<strong>max_connections</strong>Υ䤹ȤǤ¿Ʊ³桼ޤ", MessageConnectionUsedRate( 85, $conf ) );
		$this->assertEquals( "<strong>max_connections</strong>ŬꤵƤޤ", MessageConnectionUsedRate( 84, $conf ) );
		$this->assertEquals( "<strong>max_connections</strong>ŬꤵƤޤ", MessageConnectionUsedRate( 41, $conf ) );
		$this->assertEquals( "<strong>max_connections</strong>ŬꤵƤޤ", MessageConnectionUsedRate( 40, $conf ) );
		$this->assertEquals( "³Ф<strong>max_connections</strong>꤬礭ޤ", MessageConnectionUsedRate( 39, $conf ) );
		$this->assertEquals( "³Ф<strong>max_connections</strong>꤬礭ޤ", MessageConnectionUsedRate( 38, $conf ) );
		$this->assertEquals( "³Ф<strong>max_connections</strong>꤬礭ޤ", MessageConnectionUsedRate( 0, $conf ) );
	}

	function testMessageSlowQueries()
	{
		$this->assertEquals( "٤꡼䥤ǥåȤäƤʤ꡼Ϥޤ", MessageSlowQueries( 0, "ON" ) );
		$this->assertEquals( "꡼åơ٤꡼䥤ǥåƲ", MessageSlowQueries( 1, "ON" ) );
		$this->assertEquals( "꡼ONˤơ꡼åƲ", MessageSlowQueries( 1, "OFF" ) );
	}

	function testAdviceQueryCache()
	{
		$conf = LoadConfiguration( "mmeasure.conf" );
		$this->assertEquals( "<strong>query_cache_type</strong>OFFΤᡢ꡼å̵Ǥ", AdviceQueryCache( 0, 0, "OFF", $conf ) );
		$this->assertEquals( "<strong>query_cache_size</strong>0ХȤΤᡢ꡼å̵Ǥ", AdviceQueryCache( 0, 0, "ON", $conf ) );
		$this->assertEquals( "<strong>query_cache_size</strong>Υ䤷Ʋ", AdviceQueryCache( 100, 1, "ON", $conf ) );
		$this->assertEquals( "<strong>query_cache_size</strong>Υ䤷Ʋ", AdviceQueryCache( 96, 1, "ON", $conf ) );
		$this->assertEquals( "<strong>query_cache_size</strong>Υ䤷Ʋ", AdviceQueryCache( 95, 1, "ON", $conf ) );
		$this->assertEquals( "<strong>query_cache_size</strong>Υ­ʤʤѥեޥ󥹤㲼붲줬ޤ", AdviceQueryCache( 94, 1, "ON", $conf ) );
		$this->assertEquals( "<strong>query_cache_size</strong>Υ­ʤʤѥեޥ󥹤㲼붲줬ޤ", AdviceQueryCache( 93, 1, "ON", $conf ) );
		$this->assertEquals( "<strong>query_cache_size</strong>Υ­ʤʤѥեޥ󥹤㲼붲줬ޤ", AdviceQueryCache( 85, 1, "ON", $conf ) );
		$this->assertEquals( "<strong>query_cache_size</strong>ŬꤵƤޤ", AdviceQueryCache( 84, 1, "ON", $conf ) );
		$this->assertEquals( "<strong>query_cache_size</strong>ŬꤵƤޤ", AdviceQueryCache( 61, 1, "ON", $conf ) );
		$this->assertEquals( "<strong>query_cache_size</strong>ŬꤵƤޤ", AdviceQueryCache( 60, 1, "ON", $conf ) );
		$this->assertEquals( "åѤߤΥ꡼̤Ф<strong>query_cache_size</strong>礭ޤ", AdviceQueryCache( 59, 1, "ON", $conf ) );
		$this->assertEquals( "åѤߤΥ꡼̤Ф<strong>query_cache_size</strong>礭ޤ", AdviceQueryCache( 58, 1, "ON", $conf ) );
		$this->assertEquals( "åѤߤΥ꡼̤Ф<strong>query_cache_size</strong>礭ޤ", AdviceQueryCache( 0, 1, "ON", $conf ) );
	}
}
?>
